/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instruction;

import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class CannotRemoveMultiInstanceInnerActivityValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl innerActivity;
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        if (this.isMultiInstance(sourceActivity) && instructions.getInstructionsBySourceScope(innerActivity = this.getInnerActivity(sourceActivity)).isEmpty()) {
            report.addFailure("Cannot remove the inner activity of a multi-instance body when the body migrates");
        }
    }

    protected boolean isMultiInstance(ScopeImpl flowScope) {
        return flowScope.getActivityBehavior() instanceof MultiInstanceActivityBehavior;
    }

    protected ActivityImpl getInnerActivity(ActivityImpl multiInstanceBody) {
        MultiInstanceActivityBehavior activityBehavior = (MultiInstanceActivityBehavior)multiInstanceBody.getActivityBehavior();
        return activityBehavior.getInnerActivity(multiInstanceBody);
    }
}

