/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instruction;

import java.util.List;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class SameEventScopeInstructionValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ScopeImpl sourceEventScope = instruction.getSourceActivity().getEventScope();
        ScopeImpl targetEventScope = instruction.getTargetActivity().getEventScope();
        if (sourceEventScope == null && targetEventScope == null) {
            return;
        }
        if (targetEventScope == null) {
            this.addFailure(instruction, report);
        } else {
            ScopeImpl mappedSourceEventScope = this.findMappedEventScope(sourceEventScope, instructions);
            if (mappedSourceEventScope == null || !mappedSourceEventScope.getId().equals(targetEventScope.getId())) {
                this.addFailure(instruction, report);
            }
        }
    }

    protected ScopeImpl findMappedEventScope(ScopeImpl sourceEventScope, ValidatingMigrationInstructions instructions) {
        List<ValidatingMigrationInstruction> eventScopeInstructions;
        if (sourceEventScope != null && (eventScopeInstructions = instructions.getInstructionsBySourceScope(sourceEventScope)).size() > 0) {
            return eventScopeInstructions.get(0).getTargetActivity();
        }
        return null;
    }

    protected void addFailure(ValidatingMigrationInstruction instruction, MigrationInstructionValidationReportImpl report) {
        report.addFailure("Event scope of the activity has changed and wasn't migrated");
    }
}

