/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instruction;

import org.camunda.bpm.engine.impl.migration.validation.activity.HasNoEventSubProcessChildActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.activity.HasNoEventSubProcessParentActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.activity.SupportedActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.activity.SupportedBoundaryEventActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class SupportedActivitiesInstructionValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        this.validateSourceActivity(instruction, sourceActivity, report);
        ActivityImpl targetActivity = instruction.getTargetActivity();
        this.validateTargetActivity(instruction, targetActivity, report);
    }

    public void validateSourceActivity(ValidatingMigrationInstruction instruction, ActivityImpl activity, MigrationInstructionValidationReportImpl report) {
        if (!SupportedActivityValidator.INSTANCE.valid(activity)) {
            report.addFailure("Type of the source activity '" + activity.getId() + "' is not supported by the migration");
        }
        if (!SupportedBoundaryEventActivityValidator.INSTANCE.valid(activity)) {
            report.addFailure("Type of the source boundary event '" + activity.getId() + "' is not supported by migration");
        }
        if (!HasNoEventSubProcessParentActivityValidator.INSTANCE.valid(activity)) {
            report.addFailure("Source activity '" + activity.getId() + "' is child of an event sub process");
        }
        if (!HasNoEventSubProcessChildActivityValidator.INSTANCE.valid(activity)) {
            report.addFailure("Source activity '" + activity.getId() + "' has an event sub process child");
        }
    }

    public void validateTargetActivity(ValidatingMigrationInstruction instruction, ActivityImpl activity, MigrationInstructionValidationReportImpl report) {
        if (!SupportedActivityValidator.INSTANCE.valid(activity)) {
            report.addFailure("Type of the target activity '" + activity.getId() + "' is not supported by the migration");
        }
        if (!SupportedBoundaryEventActivityValidator.INSTANCE.valid(activity)) {
            report.addFailure("Type of the target boundary event '" + activity.getId() + "' is not supported by migration");
        }
        if (!HasNoEventSubProcessParentActivityValidator.INSTANCE.valid(activity)) {
            report.addFailure("Target activity '" + activity.getId() + "' is child of an event sub process");
        }
        if (!HasNoEventSubProcessChildActivityValidator.INSTANCE.valid(activity)) {
            report.addFailure("Target activity '" + activity.getId() + "' has an event sub process child");
        }
    }
}

