/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instruction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.CollectionUtil;

public class ValidatingMigrationInstructions {
    protected List<ValidatingMigrationInstruction> instructions;
    protected Map<ScopeImpl, List<ValidatingMigrationInstruction>> instructionsBySourceScope;
    protected Map<ScopeImpl, List<ValidatingMigrationInstruction>> instructionsByTargetScope;

    public ValidatingMigrationInstructions(List<ValidatingMigrationInstruction> instructions) {
        this.instructions = instructions;
        this.instructionsBySourceScope = new HashMap<ScopeImpl, List<ValidatingMigrationInstruction>>();
        this.instructionsByTargetScope = new HashMap<ScopeImpl, List<ValidatingMigrationInstruction>>();
        for (ValidatingMigrationInstruction instruction : instructions) {
            this.indexInstruction(instruction);
        }
    }

    public ValidatingMigrationInstructions() {
        this(new ArrayList<ValidatingMigrationInstruction>());
    }

    public void addInstruction(ValidatingMigrationInstruction instruction) {
        this.instructions.add(instruction);
        this.indexInstruction(instruction);
    }

    protected void indexInstruction(ValidatingMigrationInstruction instruction) {
        CollectionUtil.addToMapOfLists(this.instructionsBySourceScope, instruction.getSourceActivity(), instruction);
        CollectionUtil.addToMapOfLists(this.instructionsByTargetScope, instruction.getTargetActivity(), instruction);
    }

    public List<ValidatingMigrationInstruction> getInstructions() {
        return this.instructions;
    }

    public List<ValidatingMigrationInstruction> getInstructionsBySourceScope(ScopeImpl scope) {
        List<ValidatingMigrationInstruction> instructions = this.instructionsBySourceScope.get(scope);
        if (instructions == null) {
            return Collections.emptyList();
        }
        return instructions;
    }

    public List<ValidatingMigrationInstruction> getInstructionsByTargetScope(ScopeImpl scope) {
        List<ValidatingMigrationInstruction> instructions = this.instructionsByTargetScope.get(scope);
        if (instructions == null) {
            return Collections.emptyList();
        }
        return instructions;
    }
}

