/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class DeploymentManager
extends AbstractManager {
    public void insertDeployment(DeploymentEntity deployment) {
        this.getDbEntityManager().insert(deployment);
        this.createDefaultAuthorizations(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceManager().insertResource(resource);
        }
        Context.getProcessEngineConfiguration().getDeploymentCache().deploy(deployment);
    }

    public void deleteDeployment(String deploymentId, boolean cascade) {
        this.deleteDeployment(deploymentId, cascade, false);
    }

    public void deleteDeployment(String deploymentId, boolean cascade, boolean skipCustomListeners) {
        String processDefinitionId;
        List<ProcessDefinition> processDefinitions = this.getProcessDefinitionManager().findProcessDefinitionsByDeploymentId(deploymentId);
        if (cascade) {
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionId = processDefinition.getId();
                this.getProcessInstanceManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted deployment", true, skipCustomListeners);
            }
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            this.getIdentityLinkManager().deleteIdentityLinksByProcDef(processDefinitionId);
            List<JobEntity> timerStartJobs = this.getJobManager().findJobsByConfiguration("timer-start-event", processDefinition.getKey(), processDefinition.getTenantId());
            ProcessDefinitionEntity latestVersion = this.getProcessDefinitionManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId());
            if (latestVersion != null && latestVersion.getId().equals(processDefinition.getId())) {
                for (JobEntity job : timerStartJobs) {
                    job.delete();
                }
            }
            if (!cascade) continue;
            this.getHistoricIncidentManager().deleteHistoricIncidentsByProcessDefinitionId(processDefinitionId);
            this.getHistoricJobLogManager().deleteHistoricJobLogsByProcessDefinitionId(processDefinitionId);
        }
        if (cascade) {
            this.getHistoricJobLogManager().deleteHistoricJobLogsByDeploymentId(deploymentId);
        }
        this.getProcessDefinitionManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            Context.getProcessEngineConfiguration().getDeploymentCache().removeProcessDefinition(processDefinitionId);
            ArrayList<EventSubscriptionEntity> eventSubscriptionsToRemove = new ArrayList<EventSubscriptionEntity>();
            List<EventSubscriptionEntity> messageEventSubscriptions = this.getEventSubscriptionManager().findEventSubscriptionsByConfiguration("message", processDefinitionId);
            eventSubscriptionsToRemove.addAll(messageEventSubscriptions);
            List<EventSubscriptionEntity> signalEventSubscriptions = this.getEventSubscriptionManager().findEventSubscriptionsByConfiguration("signal", processDefinitionId);
            eventSubscriptionsToRemove.addAll(signalEventSubscriptions);
            for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptionsToRemove) {
                eventSubscriptionEntity.delete();
            }
            this.getJobDefinitionManager().deleteJobDefinitionsByProcessDefinitionId(processDefinition.getId());
        }
        this.deleteCaseDeployment(deploymentId, cascade);
        this.deleteDecisionDeployment(deploymentId, cascade);
        this.getResourceManager().deleteResourcesByDeploymentId(deploymentId);
        this.deleteAuthorizations(Resources.DEPLOYMENT, deploymentId);
        this.getDbEntityManager().delete(DeploymentEntity.class, "deleteDeployment", deploymentId);
    }

    protected void deleteCaseDeployment(String deploymentId, boolean cascade) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isCmmnEnabled()) {
            List<CaseDefinition> caseDefinitions = this.getCaseDefinitionManager().findCaseDefinitionByDeploymentId(deploymentId);
            if (cascade) {
                for (CaseDefinition caseDefinition : caseDefinitions) {
                    String caseDefinitionId = caseDefinition.getId();
                    this.getCaseInstanceManager().deleteCaseInstancesByCaseDefinition(caseDefinitionId, "deleted deployment", true);
                }
            }
            this.getCaseDefinitionManager().deleteCaseDefinitionsByDeploymentId(deploymentId);
            for (CaseDefinition caseDefinition : caseDefinitions) {
                String processDefinitionId = caseDefinition.getId();
                Context.getProcessEngineConfiguration().getDeploymentCache().removeCaseDefinition(processDefinitionId);
            }
        }
    }

    protected void deleteDecisionDeployment(String deploymentId, boolean cascade) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isDmnEnabled()) {
            DecisionDefinitionManager decisionDefinitionManager = this.getDecisionDefinitionManager();
            List<DecisionDefinition> decisionDefinitions = decisionDefinitionManager.findDecisionDefinitionByDeploymentId(deploymentId);
            if (cascade) {
                for (DecisionDefinition decisionDefinition : decisionDefinitions) {
                    this.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstancesByDecisionDefinitionId(decisionDefinition.getId());
                }
            }
            decisionDefinitionManager.deleteDecisionDefinitionsByDeploymentId(deploymentId);
            DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
            for (DecisionDefinition decisionDefinition : decisionDefinitions) {
                String decisionDefinitionId = decisionDefinition.getId();
                deploymentCache.removeDecisionDefinition(decisionDefinitionId);
            }
        }
    }

    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbEntityManager().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DeploymentEntity)list.get(0);
        }
        return null;
    }

    public DeploymentEntity findDeploymentById(String deploymentId) {
        return this.getDbEntityManager().selectById(DeploymentEntity.class, deploymentId);
    }

    public List<DeploymentEntity> findDeploymentsByIds(String ... deploymentsIds) {
        return this.getDbEntityManager().selectList("selectDeploymentsByIds", deploymentsIds);
    }

    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        this.getAuthorizationManager().configureDeploymentQuery(deploymentQuery);
        return (Long)this.getDbEntityManager().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        this.getAuthorizationManager().configureDeploymentQuery(deploymentQuery);
        return this.getDbEntityManager().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbEntityManager().selectList("selectResourceNamesByDeploymentId", deploymentId);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    protected void createDefaultAuthorizations(DeploymentEntity deployment) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newDeployment(deployment);
            this.saveDefaultAuthorizations(authorizations);
        }
    }
}

