/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class ExternalTaskManager
extends AbstractManager {
    public ExternalTaskEntity findExternalTaskById(String id) {
        return this.getDbEntityManager().selectById(ExternalTaskEntity.class, id);
    }

    public void insert(ExternalTaskEntity externalTask) {
        this.getDbEntityManager().insert(externalTask);
    }

    public void delete(ExternalTaskEntity externalTask) {
        this.getDbEntityManager().delete(externalTask);
    }

    public List<ExternalTaskEntity> findExternalTasksByExecutionId(String id) {
        return this.getDbEntityManager().selectList("selectExternalTasksByExecutionId", id);
    }

    public List<ExternalTaskEntity> selectExternalTasksForTopics(Collection<String> topics, int maxResults) {
        if (topics.size() == 0) {
            return new ArrayList<ExternalTaskEntity>();
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("topics", topics);
        parameters.put("now", ClockUtil.getCurrentTime());
        ListQueryParameterObject parameter = new ListQueryParameterObject(parameters, 0, maxResults);
        this.configureAuthorizationCheck(parameter);
        return this.getDbEntityManager().selectList("selectExternalTasksForTopics", parameter);
    }

    public List<ExternalTask> findExternalTasksByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureAuthorizationCheck(externalTaskQuery);
        return this.getDbEntityManager().selectList("selectExternalTaskByQueryCriteria", externalTaskQuery);
    }

    public long findExternalTaskCountByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureAuthorizationCheck(externalTaskQuery);
        return (Long)this.getDbEntityManager().selectOne("selectExternalTaskCountByQueryCriteria", externalTaskQuery);
    }

    protected void updateExternalTaskSuspensionState(String processInstanceId, String processDefinitionId, String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExternalTaskEntity.class, "updateExternalTaskSuspensionStateByParameters", parameters);
    }

    public void updateExternalTaskSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(processInstanceId, null, null, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(null, processDefinitionId, null, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(null, null, processDefinitionKey, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExternalTaskEntity.class, "updateExternalTaskSuspensionStateByParameters", parameters);
    }

    protected void configureAuthorizationCheck(ExternalTaskQueryImpl query) {
        this.getAuthorizationManager().configureExternalTaskQuery(query);
    }

    protected void configureAuthorizationCheck(ListQueryParameterObject parameter) {
        this.getAuthorizationManager().configureExternalTaskFetch(parameter);
    }
}

