/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;

public class HistoricBatchManager
extends AbstractManager {
    public long findBatchCountByQueryCriteria(HistoricBatchQueryImpl historicBatchQuery) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricBatchCountByQueryCriteria", historicBatchQuery);
    }

    public List<HistoricBatch> findBatchesByQueryCriteria(HistoricBatchQueryImpl historicBatchQuery, Page page) {
        return this.getDbEntityManager().selectList("selectHistoricBatchesByQueryCriteria", historicBatchQuery, page);
    }

    public HistoricBatchEntity findHistoricBatchById(String batchId) {
        return this.getDbEntityManager().selectById(HistoricBatchEntity.class, batchId);
    }

    public void deleteHistoricBatchById(String id) {
        this.getDbEntityManager().delete(HistoricBatchEntity.class, "deleteHistoricBatchById", id);
    }

    public void createHistoricBatch(BatchEntity batch) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.BATCH_START, batch)) {
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent evt = eventProducer.createBatchStartEvent(batch);
            eventHandler.handleEvent(evt);
        }
    }

    public void completeHistoricBatch(BatchEntity batch) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.BATCH_END, batch)) {
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent evt = eventProducer.createBatchEndEvent(batch);
            eventHandler.handleEvent(evt);
        }
    }
}

