/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobPriorityProvider;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.JobExceptionUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;

public abstract class JobEntity
implements Serializable,
Job,
DbEntity,
HasDbRevision {
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static final boolean DEFAULT_EXCLUSIVE = true;
    public static final int DEFAULT_RETRIES = 3;
    public static int MAX_EXCEPTION_MESSAGE_LENGTH = 666;
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected Date duedate;
    protected String lockOwner = null;
    protected Date lockExpirationTime = null;
    protected String executionId = null;
    protected String processInstanceId = null;
    protected String processDefinitionId = null;
    protected String processDefinitionKey = null;
    protected boolean isExclusive = true;
    protected int retries = 3;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String jobHandlerType = null;
    protected String jobHandlerConfiguration = null;
    protected ByteArrayEntity exceptionByteArray;
    protected String exceptionByteArrayId;
    protected String exceptionMessage;
    protected String deploymentId;
    protected String jobDefinitionId;
    protected long priority = DefaultJobPriorityProvider.DEFAULT_PRIORITY;
    protected String tenantId;
    protected boolean executing = false;
    protected String activityId;
    protected JobDefinition jobDefinition;
    protected ExecutionEntity execution;
    protected long sequenceCounter = 1L;

    public void execute(CommandContext commandContext) {
        if (this.executionId != null) {
            ExecutionEntity execution = this.getExecution();
            EnsureUtil.ensureNotNull("Cannot find execution with id '" + this.executionId + "' referenced from job '" + this + "'", "execution", (Object)execution);
        }
        this.getActivityId();
        this.incrementSequenceCounter();
        this.preExecute(commandContext);
        JobHandler jobHandler = this.getJobHandler();
        EnsureUtil.ensureNotNull("Cannot find job handler '" + this.jobHandlerType + "' from job '" + this + "'", "jobHandler", (Object)jobHandler);
        jobHandler.execute(this.jobHandlerConfiguration, this.execution, commandContext, this.tenantId);
        this.postExecute(commandContext);
    }

    protected void preExecute(CommandContext commandContext) {
    }

    protected void postExecute(CommandContext commandContext) {
        LOG.debugJobExecuted(this);
        this.delete(true);
        commandContext.getHistoricJobLogManager().fireJobSuccessfulEvent(this);
    }

    public void insert() {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            execution.addJob(this);
            ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
            this.deploymentId = processDefinition.getDeploymentId();
        }
        commandContext.getJobManager().insertJob(this);
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean incidentResolved) {
        ExecutionEntity execution;
        CommandContext commandContext = Context.getCommandContext();
        this.incrementSequenceCounter();
        commandContext.getJobManager().deleteJob(this, !this.executing);
        if (this.exceptionByteArrayId != null) {
            commandContext.getByteArrayManager().deleteByteArrayById(this.exceptionByteArrayId);
        }
        if ((execution = this.getExecution()) != null) {
            execution.removeJob(this);
        }
        this.removeFailedJobIncident(incidentResolved);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("executionId", this.executionId);
        persistentState.put("lockOwner", this.lockOwner);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        persistentState.put("retries", this.retries);
        persistentState.put("duedate", this.duedate);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("jobDefinitionId", this.jobDefinitionId);
        persistentState.put("deploymentId", this.deploymentId);
        persistentState.put("jobHandlerConfiguration", this.jobHandlerConfiguration);
        persistentState.put("priority", this.priority);
        persistentState.put("tenantId", this.tenantId);
        if (this.exceptionByteArrayId != null) {
            persistentState.put("exceptionByteArrayId", this.exceptionByteArrayId);
        }
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void setExecution(ExecutionEntity execution) {
        if (execution != null) {
            this.executionId = execution.getId();
            this.processInstanceId = execution.getProcessInstanceId();
            execution.addJob(this);
        } else {
            this.execution.removeJob(this);
            this.processInstanceId = null;
            this.executionId = null;
        }
    }

    public long getSequenceCounter() {
        return this.sequenceCounter;
    }

    public void setSequenceCounter(long sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
    }

    public void incrementSequenceCounter() {
        ++this.sequenceCounter;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    protected ExecutionEntity getExecution() {
        this.ensureExecutionInitialized();
        return this.execution;
    }

    protected void ensureExecutionInitialized() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        if (retries < 0) {
            retries = 0;
        }
        if (this.retries == 0 && retries > 0) {
            this.removeFailedJobIncident(true);
        }
        if (retries == 0 && this.retries > 0) {
            this.createFailedJobIncident();
        }
        this.retries = retries;
    }

    public void setRetriesFromPersistence(int retries) {
        this.retries = retries;
    }

    protected void createFailedJobIncident() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isCreateIncidentOnFailedJobEnabled()) {
            String incidentHandlerType = "failedJob";
            if (this.id == null) {
                this.id = processEngineConfiguration.getIdGenerator().getNextId();
            } else {
                List<Incident> failedJobIncidents = Context.getCommandContext().getIncidentManager().findIncidentByConfigurationAndIncidentType(this.id, incidentHandlerType);
                if (!failedJobIncidents.isEmpty()) {
                    return;
                }
            }
            IncidentContext incidentContext = this.createIncidentContext();
            incidentContext.setActivityId(this.getActivityId());
            processEngineConfiguration.getIncidentHandler(incidentHandlerType).handleIncident(incidentContext, this.exceptionMessage);
        }
    }

    protected void removeFailedJobIncident(boolean incidentResolved) {
        IncidentHandler handler = Context.getProcessEngineConfiguration().getIncidentHandler("failedJob");
        IncidentContext incidentContext = this.createIncidentContext();
        if (incidentResolved) {
            handler.resolveIncident(incidentContext);
        } else {
            handler.deleteIncident(incidentContext);
        }
    }

    protected IncidentContext createIncidentContext() {
        IncidentContext incidentContext = new IncidentContext();
        incidentContext.setProcessDefinitionId(this.processDefinitionId);
        incidentContext.setTenantId(this.tenantId);
        incidentContext.setConfiguration(this.id);
        if (this.executionId != null) {
            incidentContext.setExecutionId(this.executionId);
        }
        return incidentContext;
    }

    public String getExceptionStacktrace() {
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        return JobExceptionUtil.getJobExceptionStacktrace(byteArray);
    }

    public void setSuspensionState(int state) {
        this.suspensionState = state;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String claimedBy) {
        this.lockOwner = claimedBy;
    }

    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date claimedUntil) {
        this.lockExpirationTime = claimedUntil;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    public void setExceptionStacktrace(String exception) {
        byte[] exceptionBytes = StringUtil.toByteArray(exception);
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        if (byteArray == null) {
            byteArray = JobExceptionUtil.createJobExceptionByteArray(exceptionBytes);
            this.exceptionByteArrayId = byteArray.getId();
            this.exceptionByteArray = byteArray;
        } else {
            byteArray.setBytes(exceptionBytes);
        }
    }

    protected JobHandler getJobHandler() {
        Map<String, JobHandler> jobHandlers = Context.getProcessEngineConfiguration().getJobHandlers();
        return jobHandlers.get(this.jobHandlerType);
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public JobDefinition getJobDefinition() {
        this.ensureJobDefinitionInitialized();
        return this.jobDefinition;
    }

    public void setJobDefinition(JobDefinition jobDefinition) {
        this.jobDefinition = jobDefinition;
        this.jobDefinitionId = jobDefinition != null ? jobDefinition.getId() : null;
    }

    protected void ensureJobDefinitionInitialized() {
        if (this.jobDefinition == null && this.jobDefinitionId != null) {
            this.jobDefinition = Context.getCommandContext().getJobDefinitionManager().findById(this.jobDefinitionId);
        }
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage != null && exceptionMessage.length() > MAX_EXCEPTION_MESSAGE_LENGTH ? exceptionMessage.substring(0, MAX_EXCEPTION_MESSAGE_LENGTH) : exceptionMessage;
    }

    public String getExceptionByteArrayId() {
        return this.exceptionByteArrayId;
    }

    protected ByteArrayEntity getExceptionByteArray() {
        this.ensureExceptionByteArrayInitialized();
        return this.exceptionByteArray;
    }

    protected void ensureExceptionByteArrayInitialized() {
        if (this.exceptionByteArray == null && this.exceptionByteArrayId != null) {
            this.exceptionByteArray = Context.getCommandContext().getDbEntityManager().selectById(ByteArrayEntity.class, this.exceptionByteArrayId);
        }
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public boolean isInInconsistentLockState() {
        return this.lockOwner != null && this.lockExpirationTime == null || this.retries == 0 && (this.lockOwner != null || this.lockExpirationTime != null);
    }

    public void resetLock() {
        this.lockOwner = null;
        this.lockExpirationTime = null;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
    }

    public String getActivityId() {
        this.ensureActivityIdInitialized();
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    protected void ensureActivityIdInitialized() {
        if (this.activityId == null) {
            JobDefinition jobDefinition = this.getJobDefinition();
            if (jobDefinition != null) {
                this.activityId = jobDefinition.getActivityId();
            } else {
                ExecutionEntity execution = this.getExecution();
                if (execution != null) {
                    this.activityId = execution.getActivityId();
                }
            }
        }
    }

    public void unlock() {
        this.lockOwner = null;
        this.lockExpirationTime = null;
    }

    public abstract String getType();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobEntity other = (JobEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", duedate=" + this.duedate + ", lockOwner=" + this.lockOwner + ", lockExpirationTime=" + this.lockExpirationTime + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", isExclusive=" + this.isExclusive + ", isExclusive=" + this.isExclusive + ", jobDefinitionId=" + this.jobDefinitionId + ", jobHandlerType=" + this.jobHandlerType + ", jobHandlerConfiguration=" + this.jobHandlerConfiguration + ", exceptionByteArray=" + this.exceptionByteArray + ", exceptionByteArrayId=" + this.exceptionByteArrayId + ", exceptionMessage=" + this.exceptionMessage + ", deploymentId=" + this.deploymentId + ", priority=" + this.priority + ", tenantId=" + this.tenantId + "]";
    }
}

