/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.UserOperationLogQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.UserOperationLogEntryEventEntity;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContext;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContextEntryBuilder;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class UserOperationLogManager
extends AbstractHistoricManager {
    public UserOperationLogEntry findOperationLogById(String entryId) {
        return this.getDbEntityManager().selectById(UserOperationLogEntryEventEntity.class, entryId);
    }

    public long findOperationLogEntryCountByQueryCriteria(UserOperationLogQueryImpl query) {
        this.getAuthorizationManager().configureUserOperationLogQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectUserOperationLogEntryCountByQueryCriteria", query);
    }

    public List<UserOperationLogEntry> findOperationLogEntriesByQueryCriteria(UserOperationLogQueryImpl query, Page page) {
        this.getAuthorizationManager().configureUserOperationLogQuery(query);
        return this.getDbEntityManager().selectList("selectUserOperationLogEntriesByQueryCriteria", query, page);
    }

    public void deleteOperationLogEntryById(String entryId) {
        if (this.isHistoryLevelFullEnabled()) {
            this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntryById", entryId);
        }
    }

    protected void fireUserOperationLog(UserOperationLogContext context) {
        context.setUserId(this.getAuthenticatedUserId());
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
        HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
        List<HistoryEvent> historyEvents = eventProducer.createUserOperationLogEvents(context);
        eventHandler.handleEvents(historyEvents);
    }

    public void logUserOperations(UserOperationLogContext context) {
        if (this.isUserOperationLogEnabled()) {
            this.fireUserOperationLog(context);
        }
    }

    public void logTaskOperations(String operation, TaskEntity task, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Task").inContextOf(task, propertyChanges);
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logLinkOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "IdentityLink").inContextOf(task, Arrays.asList(propertyChange));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logProcessInstanceOperation(String operation, String processInstanceId, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            ProcessDefinitionEntity definition;
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "ProcessInstance").propertyChanges(propertyChange).processInstanceId(processInstanceId).processDefinitionId(processDefinitionId).processDefinitionKey(processDefinitionKey);
            if (processInstanceId != null) {
                ExecutionEntity instance = this.getProcessInstanceManager().findExecutionById(processInstanceId);
                if (instance != null) {
                    entryBuilder.inContextOf(instance);
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                entryBuilder.inContextOf(definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logProcessDefinitionOperation(String operation, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "ProcessDefinition").propertyChanges(propertyChange).processDefinitionId(processDefinitionId).processDefinitionKey(processDefinitionKey);
            if (processDefinitionId != null) {
                ProcessDefinitionEntity definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
                entryBuilder.inContextOf(definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logJobOperation(String operation, String jobId, String jobDefinitionId, String processInstanceId, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            ProcessDefinitionEntity definition;
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Job").jobId(jobId).jobDefinitionId(jobDefinitionId).processDefinitionId(processDefinitionId).processDefinitionKey(processDefinitionKey).propertyChanges(propertyChange);
            if (jobId != null) {
                JobEntity job = this.getJobManager().findJobById(jobId);
                if (job != null) {
                    entryBuilder.inContextOf(job);
                }
            } else if (jobDefinitionId != null) {
                JobDefinitionEntity jobDefinition = this.getJobDefinitionManager().findById(jobDefinitionId);
                if (jobDefinition != null) {
                    entryBuilder.inContextOf(jobDefinition);
                }
            } else if (processInstanceId != null) {
                ExecutionEntity processInstance = this.getProcessInstanceManager().findExecutionById(processInstanceId);
                if (processInstance != null) {
                    entryBuilder.inContextOf(processInstance);
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                entryBuilder.inContextOf(definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logJobDefinitionOperation(String operation, String jobDefinitionId, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            ProcessDefinitionEntity definition;
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "JobDefinition").jobDefinitionId(jobDefinitionId).processDefinitionId(processDefinitionId).processDefinitionKey(processDefinitionKey).propertyChanges(propertyChange);
            if (jobDefinitionId != null) {
                JobDefinitionEntity jobDefinition = this.getJobDefinitionManager().findById(jobDefinitionId);
                if (jobDefinition != null) {
                    entryBuilder.inContextOf(jobDefinition);
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                entryBuilder.inContextOf(definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logAttachmentOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Attachment").inContextOf(task, Arrays.asList(propertyChange));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logVariableOperation(String operation, String executionId, String taskId, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Variable").propertyChanges(propertyChange);
            if (executionId != null) {
                ExecutionEntity execution = this.getProcessInstanceManager().findExecutionById(executionId);
                entryBuilder.inContextOf(execution);
            } else if (taskId != null) {
                TaskEntity task = this.getTaskManager().findTaskById(taskId);
                entryBuilder.inContextOf(task, Arrays.asList(propertyChange));
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logDeploymentOperation(String operation, String deploymentId, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Deployment").deploymentId(deploymentId).propertyChanges(propertyChanges);
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    protected boolean isUserOperationLogEnabled() {
        return this.isHistoryLevelFullEnabled() && (this.isUserOperationLogEnabledOnCommandContext() && this.isUserAuthenticated() || !this.writeUserOperationLogOnlyWithLoggedInUser());
    }

    protected boolean isUserAuthenticated() {
        String userId = this.getAuthenticatedUserId();
        return userId != null && !userId.isEmpty();
    }

    protected String getAuthenticatedUserId() {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getAuthenticatedUserId();
    }

    protected boolean writeUserOperationLogOnlyWithLoggedInUser() {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        return configuration.isRestrictUserOperationLogToAuthenticatedUsers();
    }

    protected boolean isUserOperationLogEnabledOnCommandContext() {
        return Context.getCommandContext().isUserOperationLogEnabled();
    }
}

