/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;

public class VariableInstanceHistoryListener
implements VariableInstanceLifecycleListener<VariableInstanceEntity> {
    public static final VariableInstanceHistoryListener INSTANCE = new VariableInstanceHistoryListener();

    @Override
    public void onCreate(VariableInstanceEntity variableInstance, AbstractVariableScope sourceScope) {
        if (this.getHistoryLevel().isHistoryEventProduced(HistoryEventTypes.VARIABLE_INSTANCE_CREATE, variableInstance)) {
            HistoryEvent evt = this.getHistoryEventProducer().createHistoricVariableCreateEvt(variableInstance, sourceScope);
            this.getHistoryEventHandler().handleEvent(evt);
        }
    }

    @Override
    public void onDelete(VariableInstanceEntity variableInstance, AbstractVariableScope sourceScope) {
        if (this.getHistoryLevel().isHistoryEventProduced(HistoryEventTypes.VARIABLE_INSTANCE_DELETE, variableInstance)) {
            HistoryEvent evt = this.getHistoryEventProducer().createHistoricVariableDeleteEvt(variableInstance, sourceScope);
            this.getHistoryEventHandler().handleEvent(evt);
        }
    }

    @Override
    public void onUpdate(VariableInstanceEntity variableInstance, AbstractVariableScope sourceScope) {
        if (this.getHistoryLevel().isHistoryEventProduced(HistoryEventTypes.VARIABLE_INSTANCE_UPDATE, variableInstance)) {
            HistoryEvent evt = this.getHistoryEventProducer().createHistoricVariableUpdateEvt(variableInstance, sourceScope);
            this.getHistoryEventHandler().handleEvent(evt);
        }
    }

    protected HistoryLevel getHistoryLevel() {
        return Context.getProcessEngineConfiguration().getHistoryLevel();
    }

    protected HistoryEventProducer getHistoryEventProducer() {
        return Context.getProcessEngineConfiguration().getHistoryEventProducer();
    }

    protected HistoryEventHandler getHistoryEventHandler() {
        return Context.getProcessEngineConfiguration().getHistoryEventHandler();
    }
}

