/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.VariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;

public class VariableInstanceManager
extends AbstractManager {
    public List<VariableInstanceEntity> findVariableInstancesByTaskId(String taskId) {
        return this.getDbEntityManager().selectList("selectVariablesByTaskId", taskId);
    }

    public List<VariableInstanceEntity> findVariableInstancesByExecutionId(String executionId) {
        return this.getDbEntityManager().selectList("selectVariablesByExecutionId", executionId);
    }

    public List<VariableInstanceEntity> findVariableInstancesByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectVariablesByProcessInstanceId", processInstanceId);
    }

    public List<VariableInstanceEntity> findVariableInstancesByCaseExecutionId(String caseExecutionId) {
        return this.getDbEntityManager().selectList("selectVariablesByCaseExecutionId", caseExecutionId);
    }

    public void deleteVariableInstanceByTask(TaskEntity task) {
        List<VariableInstanceEntity> variableInstances = task.variableStore.getVariables();
        for (VariableInstanceEntity variableInstance : variableInstances) {
            variableInstance.delete();
        }
    }

    public long findVariableInstanceCountByQueryCriteria(VariableInstanceQueryImpl variableInstanceQuery) {
        this.configureAuthorizationCheck(variableInstanceQuery);
        return (Long)this.getDbEntityManager().selectOne("selectVariableInstanceCountByQueryCriteria", variableInstanceQuery);
    }

    public List<VariableInstance> findVariableInstanceByQueryCriteria(VariableInstanceQueryImpl variableInstanceQuery, Page page) {
        this.configureAuthorizationCheck(variableInstanceQuery);
        return this.getDbEntityManager().selectList("selectVariableInstanceByQueryCriteria", variableInstanceQuery, page);
    }

    protected void configureAuthorizationCheck(VariableInstanceQueryImpl query) {
        this.getAuthorizationManager().configureVariableInstanceQuery(query);
    }
}

