/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class HistoricActivityInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testSimpleQueryMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        this.verifyQueryResults(query, 6);
    }

    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        this.verifyQueryResults(query, 14);
    }

    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        this.verifyQueryResults(query, 9);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    protected void verifyQueryResults(HistoricActivityInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

