/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class HistoricIdentityLinkLogAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_PROCESS_KEY = "demoAssigneeProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/authorization/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryForStandaloneTaskHistoricIdentityLinkWithoutAuthrorization() {
        this.disableAuthorization();
        Task taskAssignee = this.taskService.newTask("newTask");
        taskAssignee.setAssignee("aUserId");
        this.taskService.saveTask(taskAssignee);
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.disableAuthorization();
        this.taskService.deleteTask("newTask", true);
        this.enableAuthorization();
    }

    public void testQueryForTaskHistoricIdentityLinkWithoutUserPermission() {
        this.disableAuthorization();
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    public void testQueryForTaskHistoricIdentityLinkWithUserPermission() {
        this.disableAuthorization();
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryWithMultiple() {
        this.disableAuthorization();
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryCaseTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testMixedQuery() {
        this.disableAuthorization();
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.createCaseInstanceByKey(CASE_KEY);
        this.taskService.addCandidateUser(((Task)this.taskService.createTaskQuery().list().get(3)).getId(), "dUserId");
        this.createCaseInstanceByKey(CASE_KEY);
        this.taskService.addCandidateUser(((Task)this.taskService.createTaskQuery().list().get(4)).getId(), "eUserId");
        this.createTaskAndAssignUser("one");
        this.createTaskAndAssignUser("two");
        this.createTaskAndAssignUser("three");
        this.createTaskAndAssignUser("four");
        this.createTaskAndAssignUser("five");
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 7);
        this.disableAuthorization();
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 10);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.enableAuthorization();
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void createTaskAndAssignUser(String taskId) {
        Task task = this.taskService.newTask(taskId);
        task.setAssignee("demo");
        this.taskService.saveTask(task);
    }
}

