/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class HistoricJobLogAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/authorization/timerStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                return null;
            }
        });
        this.deleteDeployment(this.deploymentId);
    }

    public void testStartTimerJobLogQueryWithoutAuthorization() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testStartTimerJobLogQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testStartTimerJobLogQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithHistoryReadPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 4);
    }

    public void testSimpleQueryWithHistoryReadPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 5);
    }

    public void testSimpleQueryWithMultiple() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 5);
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.enableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithHistoryReadPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 12);
    }

    public void testQueryWithHistoryReadPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 17);
    }

    public void testQueryAfterStandaloneJob() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 1);
        HistoricJobLog jobLog = (HistoricJobLog)query.singleResult();
        HistoricJobLogAuthorizationTest.assertNull((Object)jobLog.getProcessDefinitionKey());
        this.deleteDeployment(this.deploymentId);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
    }

    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 6);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    public void testGetHistoricStandaloneJobLogExceptionStacktrace() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        String jobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult()).getId();
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(jobLogId);
        HistoricJobLogAuthorizationTest.assertNull((Object)stacktrace);
        this.deleteDeployment(this.deploymentId);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
    }

    public void testGetHistoricJobLogExceptionStacktraceWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        try {
            this.historyService.getHistoricJobLogExceptionStacktrace(jobLogId);
            HistoricJobLogAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the historic job log exception stacktrace");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), message);
            this.assertTextPresent(ONE_INCIDENT_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetHistoricJobLogExceptionStacktraceWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(jobLogId);
        HistoricJobLogAuthorizationTest.assertNotNull((Object)stacktrace);
    }

    public void testGetHistoricJobLogExceptionStacktraceWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(jobLogId);
        HistoricJobLogAuthorizationTest.assertNotNull((Object)stacktrace);
    }

    protected void verifyQueryResults(HistoricJobLogQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

