/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ReadOnlyIdentityServiceTest {
    protected static final String CONFIGURATION_RESOURCE = "org/camunda/bpm/engine/test/api/identity/read.only.identity.service.camunda.cfg.xml";
    @Rule
    public ProcessEngineRule engineRule = new ProcessEngineRule("org/camunda/bpm/engine/test/api/identity/read.only.identity.service.camunda.cfg.xml", true);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.identityService = this.engineRule.getIdentityService();
        Assert.assertTrue((boolean)this.identityService.isReadOnly());
    }

    @Test
    public void newUser() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.newUser("user");
    }

    @Test
    public void saveUser() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.saveUser(null);
    }

    @Test
    public void deleteUser() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.deleteUser("user");
    }

    @Test
    public void newGroup() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.newGroup("group");
    }

    @Test
    public void saveGroup() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.saveGroup(null);
    }

    @Test
    public void deleteGroup() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.deleteGroup("group");
    }

    @Test
    public void newTenant() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.newTenant("tenant");
    }

    @Test
    public void saveTenant() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.saveTenant(null);
    }

    @Test
    public void deleteTenant() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.deleteTenant("tenant");
    }

    @Test
    public void createGroupMembership() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.createMembership("user", "group");
    }

    @Test
    public void deleteGroupMembership() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.deleteMembership("user", "group");
    }

    @Test
    public void createTenantUserMembership() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.createTenantUserMembership("tenant", "user");
    }

    @Test
    public void createTenantGroupMembership() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.createTenantGroupMembership("tenant", "group");
    }

    @Test
    public void deleteTenantUserMembership() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.deleteTenantUserMembership("tenant", "user");
    }

    @Test
    public void deleteTenantGroupMembership() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This identity service implementation is read-only.");
        this.identityService.deleteTenantGroupMembership("tenant", "group");
    }

    @Test
    public void checkPassword() {
        this.identityService.checkPassword("user", "password");
    }

    @Test
    public void createQuery() {
        this.identityService.createUserQuery().list();
        this.identityService.createGroupQuery().list();
        this.identityService.createTenantQuery().list();
    }
}

