/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.api.mgmt.metrics.AbstractMetricsTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class MetricsTest
extends AbstractMetricsTest {
    public void testDeleteMetrics() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().sum());
        this.managementService.deleteMetrics(null);
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
    }

    public void testDeleteMetricsWithTimestamp() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().sum());
        this.managementService.deleteMetrics(ClockUtil.getCurrentTime());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
    }

    public void testDeleteMetricsWithTimestampBefore() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().sum());
        this.managementService.deleteMetrics(new Date(ClockUtil.getCurrentTime().getTime() - 10000L));
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
    }

    public void testDeleteMetricsWithReporterId() {
        this.processEngineConfiguration.setDbMetricsReporterActivate(true);
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter1");
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.managementService.reportDbMetricsNow();
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter2");
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.managementService.reportDbMetricsNow();
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter1").sum());
        this.managementService.deleteMetrics(null, "reporter1");
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter1").sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter2").sum());
        this.processEngineConfiguration.setDbMetricsReporterActivate(false);
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId(null);
    }

    public void testReportNow() {
        this.processEngineConfiguration.setDbMetricsReporterActivate(true);
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.managementService.reportDbMetricsNow();
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.processEngineConfiguration.setDbMetricsReporterActivate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReportNowIfMetricsIsDisabled() {
        boolean defaultIsMetricsEnabled = this.processEngineConfiguration.isMetricsEnabled();
        this.processEngineConfiguration.setMetricsEnabled(false);
        try {
            this.managementService.reportDbMetricsNow();
            MetricsTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Metrics reporting is disabled", e.getMessage());
        }
        finally {
            this.processEngineConfiguration.setMetricsEnabled(defaultIsMetricsEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReportNowIfReporterIsNotActive() {
        boolean defaultIsMetricsEnabled = this.processEngineConfiguration.isMetricsEnabled();
        boolean defaultIsMetricsReporterActivate = this.processEngineConfiguration.isDbMetricsReporterActivate();
        this.processEngineConfiguration.setMetricsEnabled(true);
        this.processEngineConfiguration.setDbMetricsReporterActivate(false);
        try {
            this.managementService.reportDbMetricsNow();
            MetricsTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Metrics reporting to database is disabled", e.getMessage());
        }
        finally {
            this.processEngineConfiguration.setMetricsEnabled(defaultIsMetricsEnabled);
            this.processEngineConfiguration.setDbMetricsReporterActivate(defaultIsMetricsReporterActivate);
        }
    }

    public void testQuery() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("UNKNOWN").sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().startDate(new Date(1000L)).sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().startDate(new Date(1000L)).endDate(new Date(ClockUtil.getCurrentTime().getTime() + 2000L)).sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).endDate(ClockUtil.getCurrentTime()).sum());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)6L, (long)this.managementService.createMetricsQuery().sum());
        MetricsTest.assertEquals((long)6L, (long)this.managementService.createMetricsQuery().startDate(new Date(1000L)).sum());
        MetricsTest.assertEquals((long)6L, (long)this.managementService.createMetricsQuery().startDate(new Date(1000L)).endDate(new Date(ClockUtil.getCurrentTime().getTime() + 2000L)).sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).endDate(ClockUtil.getCurrentTime()).sum());
    }

    public void testQueryEndDateExclusive() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        ClockUtil.setCurrentTime((Date)new Date(5000L));
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)new Date(6000L));
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)new Date(7000L));
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)9L, (long)this.managementService.createMetricsQuery().sum());
        MetricsTest.assertEquals((long)9L, (long)this.managementService.createMetricsQuery().startDate(new Date(0L)).sum());
        MetricsTest.assertEquals((long)6L, (long)this.managementService.createMetricsQuery().startDate(new Date(0L)).endDate(new Date(7000L)).sum());
        MetricsTest.assertEquals((long)9L, (long)this.managementService.createMetricsQuery().startDate(new Date(0L)).endDate(new Date(8000L)).sum());
    }

    public void testReportWithReporterId() {
        this.processEngineConfiguration.setDbMetricsReporterActivate(true);
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter1");
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.managementService.reportDbMetricsNow();
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter2");
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.managementService.reportDbMetricsNow();
        MetricsTest.assertEquals((long)6L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter1").sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter2").sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").reporter("aNonExistingReporter").sum());
        this.processEngineConfiguration.setDbMetricsReporterActivate(false);
        this.processEngineConfiguration.getDbMetricsReporter().setReporterId(null);
    }
}

