/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyRepositoryServiceTest {
    protected static final String TENANT_TWO = "tenant2";
    protected static final String TENANT_ONE = "tenant1";
    protected static final BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess().done();
    protected static final String CMMN = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;
    protected ProcessEngineConfiguration processEngineConfiguration;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void deploymentWithoutTenantId() {
        this.createDeploymentBuilder().deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assert.assertThat((Object)deployment, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)deployment.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void deploymentWithTenantId() {
        this.createDeploymentBuilder().tenantId(TENANT_ONE).deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assert.assertThat((Object)deployment, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)deployment.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void processDefinitionVersionWithTenantId() {
        this.createDeploymentBuilder().tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().tenantId(TENANT_TWO).deploy();
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByTenantId().asc()).orderByProcessDefinitionVersion().asc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(2)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void deploymentWithDuplicateFilteringForSameTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void deploymentWithDuplicateFilteringForDifferentTenants() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_TWO).deploy();
        Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void deploymentWithDuplicateFilteringIgnoreDeploymentForNoTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void deploymentWithDuplicateFilteringIgnoreDeploymentForTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").deploy();
        Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void getPreviousProcessDefinitionWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_TWO, emptyProcess);
        this.testRule.deployForTenant(TENANT_TWO, emptyProcess);
        List latestProcessDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        ProcessDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((ProcessDefinitionEntity)latestProcessDefinitions.get(0));
        ProcessDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((ProcessDefinitionEntity)latestProcessDefinitions.get(1));
        Assert.assertThat((Object)previousDefinitionTenantOne.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)previousDefinitionTenantOne.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    @Test
    public void getPreviousCaseDefinitionWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        List latestCaseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        CaseDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((CaseDefinitionEntity)latestCaseDefinitions.get(0));
        CaseDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((CaseDefinitionEntity)latestCaseDefinitions.get(1));
        Assert.assertThat((Object)previousDefinitionTenantOne.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)previousDefinitionTenantOne.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    @Test
    public void getPreviousDecisionDefinitionWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        List latestDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        DecisionDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((DecisionDefinitionEntity)latestDefinitions.get(0));
        DecisionDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((DecisionDefinitionEntity)latestDefinitions.get(1));
        Assert.assertThat((Object)previousDefinitionTenantOne.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)previousDefinitionTenantOne.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)previousDefinitionTenantTwo.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    protected <T extends ResourceDefinitionEntity> T getPreviousDefinition(final T definitionEntity) {
        return (T)((ResourceDefinitionEntity)((ProcessEngineConfigurationImpl)this.processEngineConfiguration).getCommandExecutorTxRequired().execute(new Command<T>(){

            public T execute(CommandContext commandContext) {
                return definitionEntity.getPreviousDefinition();
            }
        }));
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", emptyProcess);
    }

    @After
    public void tearDown() throws Exception {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }
}

