/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessTaskTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String CMMN_LATEST = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn";
    protected static final String CMMN_DEPLOYMENT = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTaskDeploymentBinding.cmmn";
    protected static final String CMMN_VERSION = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTaskVersionBinding.cmmn";
    protected static final String CMMN_VERSION_2 = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTaskVersionBinding_v2.cmmn";
    protected static final String CMMN_TENANT_CONST = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTaskTenantIdConst.cmmn";
    protected static final String CMMN_TENANT_EXPR = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTaskTenantIdExpr.cmmn";
    protected static final String PROCESS_TASK_ID = "PI_ProcessTask_1";
    protected static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();

    public void testStartProcessInstanceWithDeploymentBinding() {
        this.deploymentForTenant(TENANT_ONE, CMMN_DEPLOYMENT, PROCESS);
        this.deploymentForTenant(TENANT_TWO, CMMN_DEPLOYMENT, PROCESS);
        this.createCaseInstance("testCaseDeployment", TENANT_ONE);
        this.createCaseInstance("testCaseDeployment", TENANT_TWO);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceWithLatestBindingSameVersion() {
        this.deploymentForTenant(TENANT_ONE, CMMN_LATEST, PROCESS);
        this.deploymentForTenant(TENANT_TWO, CMMN_LATEST, PROCESS);
        this.createCaseInstance("testCase", TENANT_ONE);
        this.createCaseInstance("testCase", TENANT_TWO);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceWithLatestBindingDifferentVersion() {
        this.deploymentForTenant(TENANT_ONE, CMMN_LATEST, PROCESS);
        this.deploymentForTenant(TENANT_TWO, CMMN_LATEST, PROCESS);
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.createCaseInstance("testCase", TENANT_ONE);
        this.createCaseInstance("testCase", TENANT_TWO);
        ProcessDefinition latestProcessTenantTwo = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).processDefinitionKey("testProcess").latestVersion().singleResult();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).processDefinitionId(latestProcessTenantTwo.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceWithVersionBinding() {
        this.deploymentForTenant(TENANT_ONE, CMMN_VERSION, PROCESS);
        this.deploymentForTenant(TENANT_TWO, CMMN_VERSION, PROCESS);
        this.createCaseInstance("testCaseVersion", TENANT_ONE);
        this.createCaseInstance("testCaseVersion", TENANT_TWO);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailStartProcessInstanceFromOtherTenantWithDeploymentBinding() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_DEPLOYMENT});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        try {
            this.createCaseInstance("testCaseDeployment", TENANT_ONE);
            MultiTenancyProcessTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key = 'testProcess'"));
        }
    }

    public void testFailStartProcessInstanceFromOtherTenantWithLatestBinding() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_LATEST});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        try {
            this.createCaseInstance("testCase", TENANT_ONE);
            MultiTenancyProcessTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key 'testProcess'"));
        }
    }

    public void testFailStartProcessInstanceFromOtherTenantWithVersionBinding() {
        this.deploymentForTenant(TENANT_ONE, CMMN_VERSION_2, PROCESS);
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        try {
            this.createCaseInstance("testCaseVersion", TENANT_ONE);
            MultiTenancyProcessTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key = 'testProcess'"));
        }
    }

    public void testProcessRefTenantIdConstant() {
        this.deployment(new String[]{CMMN_TENANT_CONST});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.caseService.withCaseDefinitionByKey("testCase").create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(PROCESS_TASK_ID).singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testProcessRefTenantIdExpression() {
        this.deployment(new String[]{CMMN_TENANT_EXPR});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.caseService.withCaseDefinitionByKey("testCase").create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(PROCESS_TASK_ID).singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("testProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    protected void createCaseInstance(String caseDefinitionKey, String tenantId) {
        this.caseService.withCaseDefinitionByKey(caseDefinitionKey).caseDefinitionTenantId(tenantId).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(PROCESS_TASK_ID).tenantIdIn(new String[]{tenantId}).singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
    }
}

