/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import java.util.Arrays;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyJobSuspensionStateTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done();
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deploy(PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    @Test
    public void suspendAndActivateJobsForAllTenants() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void suspendJobForTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void suspendJobsForNonTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void activateJobsForTenant() {
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void activateJobsForNonTenant() {
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void suspendJobNoAuthenticatedTenants() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void suspendJobWithAuthenticatedTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void suspendJobDisabledTenantCheck() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeJobsWithoutTenantId().count(), (Matcher)CoreMatchers.is((Object)3L));
    }
}

