/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstanceBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyCaseInstanceCmdsTenantCheckTest {
    protected static final String VARIABLE_NAME = "myVar";
    protected static final String VARIABLE_VALUE = "myValue";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String CMMN_MODEL = "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn";
    protected static final String ACTIVITY_ID = "PI_HumanTask_1";
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected IdentityService identityService;
    protected CaseService caseService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected String caseInstanceId;
    protected String caseExecutionId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService = this.engineRule.getIdentityService();
        this.caseService = this.engineRule.getCaseService();
        this.historyService = this.engineRule.getHistoryService();
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.caseInstanceId = this.createCaseInstance(null);
        this.caseExecutionId = this.getCaseExecution().getId();
    }

    @Test
    public void manuallyStartCaseExecutionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the case execution");
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
    }

    @Test
    public void manuallyStartCaseExecutionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        CaseExecution caseExecution = this.getCaseExecution();
        Assert.assertThat((Object)caseExecution.isActive(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void manuallyStartCaseExecutionDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        CaseExecution caseExecution = this.getCaseExecution();
        Assert.assertThat((Object)caseExecution.isActive(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void disableCaseExecutionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the case execution");
        this.caseService.disableCaseExecution(this.caseExecutionId);
    }

    @Test
    public void disableCaseExecutionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        HistoricCaseActivityInstance historicCaseActivityInstance = this.getHistoricCaseActivityInstance();
        Assert.assertThat((Object)historicCaseActivityInstance, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)historicCaseActivityInstance.isDisabled(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void disableCaseExecutionDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        HistoricCaseActivityInstance historicCaseActivityInstance = this.getHistoricCaseActivityInstance();
        Assert.assertThat((Object)historicCaseActivityInstance, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)historicCaseActivityInstance.isDisabled(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void reenableCaseExecutionNoAuthenticatedTenants() {
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the case execution");
        this.caseService.reenableCaseExecution(this.caseExecutionId);
    }

    @Test
    public void reenableCaseExecutionWithAuthenticatedTenant() {
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.reenableCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        CaseExecution caseExecution = this.getCaseExecution();
        Assert.assertThat((Object)caseExecution.isEnabled(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void reenableCaseExecutionDisabledTenantCheck() {
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.reenableCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        CaseExecution caseExecution = this.getCaseExecution();
        Assert.assertThat((Object)caseExecution.isEnabled(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void completeCaseExecutionNoAuthenticatedTenants() {
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the case execution");
        this.caseService.completeCaseExecution(this.caseExecutionId);
    }

    @Test
    public void completeCaseExecutionWithAuthenticatedTenant() {
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.completeCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        HistoricCaseActivityInstance historicCaseActivityInstance = this.getHistoricCaseActivityInstance();
        Assert.assertThat((Object)historicCaseActivityInstance, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)historicCaseActivityInstance.isCompleted(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void completeCaseExecutionDisabledTenantCheck() {
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.completeCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        HistoricCaseActivityInstance historicCaseActivityInstance = this.getHistoricCaseActivityInstance();
        Assert.assertThat((Object)historicCaseActivityInstance, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)historicCaseActivityInstance.isCompleted(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void closeCaseInstanceNoAuthenticatedTenants() {
        this.caseService.completeCaseExecution(this.caseInstanceId);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the case execution");
        this.caseService.closeCaseInstance(this.caseInstanceId);
    }

    @Test
    public void closeCaseInstanceWithAuthenticatedTenant() {
        this.caseService.completeCaseExecution(this.caseInstanceId);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.closeCaseInstance(this.caseInstanceId);
        this.identityService.clearAuthentication();
        HistoricCaseInstance historicCaseInstance = this.getHistoricCaseInstance();
        Assert.assertThat((Object)historicCaseInstance, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)historicCaseInstance.isClosed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void closeCaseInstanceDisabledTenantCheck() {
        this.caseService.completeCaseExecution(this.caseInstanceId);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.closeCaseInstance(this.caseInstanceId);
        this.identityService.clearAuthentication();
        HistoricCaseInstance historicCaseInstance = this.getHistoricCaseInstance();
        Assert.assertThat((Object)historicCaseInstance, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)historicCaseInstance.isClosed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getVariablesNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the case execution");
        this.caseService.getVariables(this.caseExecutionId);
    }

    @Test
    public void getVariablesWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assert.assertThat((Object)variables, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat(variables.keySet(), (Matcher)CoreMatchers.hasItem((Object)VARIABLE_NAME));
    }

    @Test
    public void getVariablesDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assert.assertThat((Object)variables, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat(variables.keySet(), (Matcher)CoreMatchers.hasItem((Object)VARIABLE_NAME));
    }

    @Test
    public void getVariableNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the case execution");
        this.caseService.getVariable(this.caseExecutionId, VARIABLE_NAME);
    }

    @Test
    public void getVariableWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        String variableValue = (String)this.caseService.getVariable(this.caseExecutionId, VARIABLE_NAME);
        Assert.assertThat((Object)variableValue, (Matcher)CoreMatchers.is((Object)VARIABLE_VALUE));
    }

    @Test
    public void getVariableDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        String variableValue = (String)this.caseService.getVariable(this.caseExecutionId, VARIABLE_NAME);
        Assert.assertThat((Object)variableValue, (Matcher)CoreMatchers.is((Object)VARIABLE_VALUE));
    }

    @Test
    public void getVariableTypedNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the case execution");
        this.caseService.getVariableTyped(this.caseExecutionId, VARIABLE_NAME);
    }

    @Test
    public void getVariableTypedWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        StringValue variable = (StringValue)this.caseService.getVariableTyped(this.caseExecutionId, VARIABLE_NAME);
        Assert.assertThat((Object)variable.getValue(), (Matcher)CoreMatchers.is((Object)VARIABLE_VALUE));
    }

    @Test
    public void getVariableTypedDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        StringValue variable = (StringValue)this.caseService.getVariableTyped(this.caseExecutionId, VARIABLE_NAME);
        Assert.assertThat((Object)variable.getValue(), (Matcher)CoreMatchers.is((Object)VARIABLE_VALUE));
    }

    @Test
    public void removeVariablesNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the case execution");
        this.caseService.removeVariable(this.caseExecutionId, VARIABLE_NAME);
    }

    @Test
    public void removeVariablesWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.removeVariable(this.caseExecutionId, VARIABLE_NAME);
        this.identityService.clearAuthentication();
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assert.assertThat((Object)variables.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void removeVariablesDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.removeVariable(this.caseExecutionId, VARIABLE_NAME);
        this.identityService.clearAuthentication();
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assert.assertThat((Object)variables.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void setVariableNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the case execution");
        this.caseService.setVariable(this.caseExecutionId, "newVar", (Object)"newValue");
    }

    @Test
    public void setVariableWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.setVariable(this.caseExecutionId, "newVar", (Object)"newValue");
        this.identityService.clearAuthentication();
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assert.assertThat((Object)variables, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat(variables.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{VARIABLE_NAME, "newVar"}));
    }

    @Test
    public void setVariableDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.setVariable(this.caseExecutionId, "newVar", (Object)"newValue");
        this.identityService.clearAuthentication();
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assert.assertThat((Object)variables, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat(variables.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{VARIABLE_NAME, "newVar"}));
    }

    protected String createCaseInstance(String tenantId) {
        VariableMap variables = Variables.putValue((String)VARIABLE_NAME, (Object)VARIABLE_VALUE);
        CaseInstanceBuilder builder = this.caseService.withCaseDefinitionByKey("twoTaskCase").setVariables((Map)variables);
        if (tenantId == null) {
            return builder.create().getId();
        }
        return builder.caseDefinitionTenantId(tenantId).create().getId();
    }

    protected CaseExecution getCaseExecution() {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(ACTIVITY_ID).singleResult();
    }

    protected HistoricCaseActivityInstance getHistoricCaseActivityInstance() {
        return (HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId(ACTIVITY_ID).singleResult();
    }

    protected HistoricCaseInstance getHistoricCaseInstance() {
        return (HistoricCaseInstance)this.historyService.createHistoricCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
    }
}

