/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyJobCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "exceptionInJobExecution";
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected ProcessInstance processInstance;
    protected ManagementService managementService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected static final BpmnModelInstance BPMN_PROCESS = ((ServiceTaskBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"exceptionInJobExecution").startEvent().userTask("aUserTask").boundaryEvent("timerEvent").timerWithDuration("PT4H")).serviceTask().camundaExpression("${failing}")).endEvent().done();
    BpmnModelInstance BPMN_NO_FAIL_PROCESS = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"noFail").startEvent().userTask("aUserTask").boundaryEvent("timerEvent").timerWithDuration("PT4H")).endEvent().done();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void init() {
        this.managementService = this.engineRule.getManagementService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, this.BPMN_NO_FAIL_PROCESS);
        this.processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
    }

    @Test
    public void testSetJobRetriesWithAuthenticatedTenant() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.setJobRetries(timerJob.getId(), 5);
        Assert.assertEquals((long)5L, (long)((Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult()).getRetries());
    }

    @Test
    public void testSetJobRetriesWithNoAuthenticatedTenant() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the job '" + timerJob.getId() + "' because it belongs to no authenticated tenant.");
        this.managementService.setJobRetries(timerJob.getId(), 5);
    }

    @Test
    public void testSetJobRetriesWithDisabledTenantCheck() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.setJobRetries(timerJob.getId(), 5);
        Assert.assertEquals((long)5L, (long)((Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult()).getRetries());
    }

    @Test
    public void testSetJobRetriesDefinitionWithAuthenticatedTenant() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        String jobId = this.selectJobByProcessInstanceId(this.processInstance.getId()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        Assert.assertEquals((long)1L, (long)this.selectJobByProcessInstanceId(this.processInstance.getId()).getRetries());
    }

    @Test
    public void testSetJobRetriesDefinitionWithNoAuthenticatedTenant() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        String jobId = this.selectJobByProcessInstanceId(this.processInstance.getId()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process definition '" + jobDefinition.getProcessDefinitionId() + "' because it belongs to no authenticated tenant.");
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
    }

    @Test
    public void testSetJobRetriesDefinitionWithDisabledTenantCheck() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        String jobId = this.selectJobByProcessInstanceId(this.processInstance.getId()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        Assert.assertEquals((long)1L, (long)this.selectJobByProcessInstanceId(this.processInstance.getId()).getRetries());
    }

    @Test
    public void testSetJobDueDateWithAuthenticatedTenant() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().duedateLowerThan(new Date()).count());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -3);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.setJobDuedate(timerJob.getId(), cal.getTime());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().duedateLowerThan(new Date()).count());
    }

    @Test
    public void testSetJobDueDateWithNoAuthenticatedTenant() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the job '" + timerJob.getId() + "' because it belongs to no authenticated tenant.");
        this.managementService.setJobDuedate(timerJob.getId(), new Date());
    }

    @Test
    public void testSetJobDueDateWithDisabledTenantCheck() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -3);
        this.managementService.setJobDuedate(timerJob.getId(), cal.getTime());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().duedateLowerThan(new Date()).count());
    }

    @Test
    public void testSetJobPriorityWithAuthenticatedTenant() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.setJobPriority(timerJob.getId(), 5L);
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().priorityHigherThanOrEquals(5L).count());
    }

    @Test
    public void testSetJobPriorityWithNoAuthenticatedTenant() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the job '" + timerJob.getId() + "' because it belongs to no authenticated tenant.");
        this.managementService.setJobPriority(timerJob.getId(), 5L);
    }

    @Test
    public void testSetJobPriorityWithDisabledTenantCheck() {
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.setJobPriority(timerJob.getId(), 5L);
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().priorityHigherThanOrEquals(5L).count());
    }

    @Test
    public void testSetOverridingJobPriorityWithAuthenticatedTenant() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L);
        Assert.assertThat((Object)((JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult()).getOverridingJobPriority(), (Matcher)CoreMatchers.is((Object)1701L));
    }

    @Test
    public void testSetOverridingJobPriorityWithNoAuthenticatedTenant() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process definition '" + jobDefinition.getProcessDefinitionId() + "' because it belongs to no authenticated tenant.");
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L);
    }

    @Test
    public void testSetOverridingJobPriorityWithDisabledTenantCheck() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L);
        Assert.assertThat((Object)((JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult()).getOverridingJobPriority(), (Matcher)CoreMatchers.is((Object)1701L));
    }

    @Test
    public void testSetOverridingJobPriorityWithCascadeAndAuthenticatedTenant() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L, true);
        Assert.assertThat((Object)((JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult()).getOverridingJobPriority(), (Matcher)CoreMatchers.is((Object)1701L));
    }

    @Test
    public void testSetOverridingJobPriorityWithCascadeAndNoAuthenticatedTenant() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process definition '" + jobDefinition.getProcessDefinitionId() + "' because it belongs to no authenticated tenant.");
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L, true);
    }

    @Test
    public void testSetOverridingJobPriorityWithCascadeAndDisabledTenantCheck() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L, true);
        Assert.assertThat((Object)((JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult()).getOverridingJobPriority(), (Matcher)CoreMatchers.is((Object)1701L));
    }

    @Test
    public void testClearOverridingJobPriorityWithAuthenticatedTenant() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L);
        Assert.assertThat((Object)((JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult()).getOverridingJobPriority(), (Matcher)CoreMatchers.is((Object)1701L));
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        Assert.assertThat((Object)((JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult()).getOverridingJobPriority(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testClearOverridingJobPriorityWithNoAuthenticatedTenant() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L);
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process definition '" + jobDefinition.getProcessDefinitionId() + "' because it belongs to no authenticated tenant.");
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
    }

    @Test
    public void testClearOverridingJobPriorityWithDisabledTenantCheck() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().list().get(0);
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L);
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        Assert.assertThat((Object)((JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult()).getOverridingJobPriority(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetJobExceptionStackTraceWithAuthenticatedTenant() {
        String processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
        this.testRule.executeAvailableJobs();
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertThat((Object)this.managementService.getJobExceptionStacktrace(timerJobId), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetJobExceptionStackTraceWithNoAuthenticatedTenant() {
        String processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
        this.testRule.executeAvailableJobs();
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot read the job '" + timerJobId + "' because it belongs to no authenticated tenant.");
        this.managementService.getJobExceptionStacktrace(timerJobId);
    }

    @Test
    public void testGetJobExceptionStackTraceWithDisabledTenantCheck() {
        String processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
        this.testRule.executeAvailableJobs();
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.getJobExceptionStacktrace(timerJobId);
        Assert.assertThat((Object)this.managementService.getJobExceptionStacktrace(timerJobId), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testDeleteJobWithAuthenticatedTenant() {
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.deleteJob(timerJobId);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).count());
    }

    @Test
    public void testDeleteJobWithNoAuthenticatedTenant() {
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the job '" + timerJobId + "' because it belongs to no authenticated tenant.");
        this.managementService.deleteJob(timerJobId);
    }

    @Test
    public void testDeleteJobWithDisabledTenantCheck() {
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.deleteJob(timerJobId);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).count());
    }

    @Test
    public void testExecuteJobWithAuthenticatedTenant() {
        String noFailProcessInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey("noFail").getId();
        TaskQuery taskQuery = this.engineRule.getTaskService().createTaskQuery().processInstanceId(noFailProcessInstanceId);
        Assert.assertEquals((long)1L, (long)taskQuery.list().size());
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(noFailProcessInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.managementService.executeJob(timerJobId);
        Assert.assertEquals((long)0L, (long)taskQuery.list().size());
    }

    @Test
    public void testExecuteJobWithNoAuthenticatedTenant() {
        String noFailProcessInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey("noFail").getId();
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(noFailProcessInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the job '" + timerJobId + "' because it belongs to no authenticated tenant.");
        this.managementService.executeJob(timerJobId);
    }

    @Test
    public void testExecuteJobWithDisabledTenantCheck() {
        String noFailProcessInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey("noFail").getId();
        String timerJobId = ((Job)this.managementService.createJobQuery().processInstanceId(noFailProcessInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.managementService.executeJob(timerJobId);
        TaskQuery taskQuery = this.engineRule.getTaskService().createTaskQuery().processInstanceId(noFailProcessInstanceId);
        Assert.assertEquals((long)0L, (long)taskQuery.list().size());
    }

    protected Job selectJobByProcessInstanceId(String processInstanceId) {
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        return job;
    }
}

