/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.bpmn.multiinstance.DelegateEvent;
import org.camunda.bpm.engine.test.bpmn.multiinstance.DelegateExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ParallelGatewayBuilder;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationAddSubprocessTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testScopeUserTaskMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testConcurrentScopeUserTaskMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS_SUB_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child(null).concurrent().noScope().child("userTask1").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask1")).up().up().child(null).concurrent().noScope().child("userTask2").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask2")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUserTaskMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testConcurrentUserTaskMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("userTask1").concurrent().noScope().up().child("userTask2").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testConcurrentThreeUserTaskMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).getBuilderForElementById("fork", ParallelGatewayBuilder.class).userTask("userTask3").endEvent().done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS).getBuilderForElementById("fork", ParallelGatewayBuilder.class).userTask("userTask3").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask2").mapActivities("userTask2", "userTask3").mapActivities("userTask3", "userTask1").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("userTask1").concurrent().noScope().up().child("userTask2").concurrent().noScope().up().child("userTask3").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask3").getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).activity("userTask3", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)3L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testNestedScopesMigration1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.DOUBLE_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("subProcess", "outerSubProcess").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("outerSubProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).beginScope("innerSubProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testNestedScopesMigration2() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.DOUBLE_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("subProcess", "innerSubProcess").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("outerSubProcess").beginScope("innerSubProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMultipleInstancesOfScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.DOUBLE_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("subProcess", "outerSubProcess").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("subProcess")).startBeforeActivity("subProcess")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child(null).scope().child("userTask").scope().up().up().up().child(null).concurrent().noScope().child(null).scope().child("userTask").scope().done());
        ActivityInstance activityInstance = this.testHelper.snapshotBeforeMigration.getActivityTree();
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("outerSubProcess", activityInstance.getActivityInstances("subProcess")[0].getId()).beginScope("innerSubProcess").activity("userTask", activityInstance.getActivityInstances("subProcess")[0].getActivityInstances("userTask")[0].getId()).endScope().endScope().beginScope("outerSubProcess", activityInstance.getActivityInstances("subProcess")[1].getId()).beginScope("innerSubProcess").activity("userTask", activityInstance.getActivityInstances("subProcess")[1].getActivityInstances("userTask")[0].getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testChangeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask2").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("userTask1")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask2").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask1");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testChangeScopeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS_SUB_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask2").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("userTask1")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("userTask2").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask1");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testListenerInvocationForNewlyCreatedScope() {
        DelegateEvent.clearEvents();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaExecutionListenerClass("start", DelegateExecutionListener.class.getName()).done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        List<DelegateEvent> recordedEvents = DelegateEvent.getEvents();
        Assert.assertEquals((long)1L, (long)recordedEvents.size());
        DelegateEvent event = recordedEvents.get(0);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)event.getProcessDefinitionId());
        Assert.assertEquals((Object)"subProcess", (Object)event.getCurrentActivityId());
        DelegateEvent.clearEvents();
    }

    @Test
    public void testSkipListenerInvocationForNewlyCreatedScope() {
        DelegateEvent.clearEvents();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaExecutionListenerClass("start", DelegateExecutionListener.class.getName()).done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).skipCustomListeners().execute();
        List<DelegateEvent> recordedEvents = DelegateEvent.getEvents();
        Assert.assertEquals((long)0L, (long)recordedEvents.size());
        DelegateEvent.clearEvents();
    }

    @Test
    public void testIoMappingInvocationForNewlyCreatedScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaInputParameter("foo", "bar").done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        VariableInstance inputVariable = (VariableInstance)this.rule.getRuntimeService().createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)inputVariable);
        Assert.assertEquals((Object)"foo", (Object)inputVariable.getName());
        Assert.assertEquals((Object)"bar", (Object)inputVariable.getValue());
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        Assert.assertEquals((Object)activityInstance.getActivityInstances("subProcess")[0].getId(), (Object)inputVariable.getActivityInstanceId());
    }

    @Test
    public void testSkipIoMappingInvocationForNewlyCreatedScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaInputParameter("foo", "bar").done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).skipIoMappings().execute();
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createVariableInstanceQuery().count());
    }

    @Test
    public void testDeleteMigratedInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS_SUB_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        String processInstanceId = this.testHelper.snapshotBeforeMigration.getProcessInstanceId();
        this.rule.getRuntimeService().deleteProcessInstance(processInstanceId, null);
        this.testHelper.assertProcessEnded(processInstanceId);
    }

    @Test
    @Ignore
    public void testAddParentScopeToMultiInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((UserTask)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).getModelElementById("userTask")).builder().multiInstance().parallel()).camundaCollection("collectionVar")).camundaElementVariable("elementVar")).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((UserTask)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).getModelElementById("userTask")).builder().multiInstance().parallel()).camundaCollection("collectionVar")).camundaElementVariable("elementVar")).done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask#multiInstanceBody", "userTask#multiInstanceBody").mapActivities("userTask", "userTask").build();
        ArrayList<String> miElements = new ArrayList<String>();
        miElements.add("a");
        miElements.add("b");
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId(), (Map)Variables.createVariables().putValue("collectionVar", miElements));
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").beginMiBody("userTask").activity("userTask").activity("userTask").activity("userTask").done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        ArrayList<String> collectedElementsVars = new ArrayList<String>();
        for (Task migratedTask : migratedTasks) {
            collectedElementsVars.add((String)this.rule.getTaskService().getVariable(migratedTask.getId(), "elementVar"));
        }
        Assert.assertTrue((boolean)collectedElementsVars.contains("a"));
        Assert.assertTrue((boolean)collectedElementsVars.contains("b"));
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTwoScopes() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.DOUBLE_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("outerSubProcess").beginScope("innerSubProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTwoConcurrentScopes() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.DOUBLE_PARALLEL_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child(null).concurrent().noScope().child("userTask1").scope().up().up().child(null).concurrent().noScope().child("userTask2").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("outerSubProcess").beginScope("innerSubProcess1").activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).endScope().beginScope("innerSubProcess2").activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testCanMigrateParentScopeWayTooHigh() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.TRIPLE_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess1").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).child(null).scope().child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess1", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).beginScope("subProcess2").beginScope("subProcess3").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMoveConcurrentActivityIntoSiblingScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_TASK_AND_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask2").scope().up().up().child(null).concurrent().noScope().child("userTask1").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask2").getId()).endScope().beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("userTask1", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddScopeDoesNotBecomeAsync() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaAsyncBefore().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Assert.assertEquals((long)0L, (long)this.testHelper.snapshotAfterMigration.getJobs().size());
    }
}

