/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CallActivityModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationCallActivityTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Before
    public void deployOneTaskProcess() {
        this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "oneTaskProcess"));
    }

    @Before
    public void deployOneTaskCase() {
        this.testHelper.deploy("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn");
    }

    @Test
    public void testCallBpmnProcessSimpleMigration() {
        BpmnModelInstance model = CallActivityModels.oneBpmnCallActivityProcess("oneTaskProcess");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("callActivity").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("callActivity")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCallCmmnCaseSimpleMigration() {
        BpmnModelInstance model = CallActivityModels.oneCmmnCallActivityProcess("oneTaskCase");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("callActivity").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("callActivity")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        CaseExecution caseExecution = (CaseExecution)this.rule.getCaseService().createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.rule.getCaseService().withCaseExecution(caseExecution.getId()).manualStart();
        this.testHelper.completeTask("PI_HumanTask_1");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
        this.rule.getCaseService().withCaseExecution(caseExecution.getCaseInstanceId()).close();
        this.testHelper.assertCaseEnded(caseExecution.getCaseInstanceId());
    }

    @Test
    public void testCallBpmnProcessAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CallActivityModels.oneBpmnCallActivityProcess("oneTaskProcess"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CallActivityModels.subProcessBpmnCallActivityProcess("oneTaskProcess"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("callActivity").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("callActivity")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCallBpmnProcessParallelMultiInstance() {
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(CallActivityModels.oneBpmnCallActivityProcess("oneTaskProcess")).activityBuilder("callActivity").multiInstance().parallel()).cardinality("1")).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity#multiInstanceBody", "callActivity#multiInstanceBody").mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("callActivity#multiInstanceBody")).child("callActivity").concurrent().noScope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("callActivity")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginMiBody("callActivity").activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        this.testHelper.assertSuperExecutionOfProcessInstance(((ProcessInstance)this.rule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId(), this.testHelper.getSingleExecutionIdForActivityAfterMigration("callActivity"));
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCallCmmnCaseParallelMultiInstance() {
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(CallActivityModels.oneCmmnCallActivityProcess("oneTaskCase")).activityBuilder("callActivity").multiInstance().parallel()).cardinality("1")).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity#multiInstanceBody", "callActivity#multiInstanceBody").mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("callActivity#multiInstanceBody")).child("callActivity").concurrent().noScope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("callActivity")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginMiBody("callActivity").activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        this.testHelper.assertSuperExecutionOfCaseInstance(((CaseInstance)this.rule.getCaseService().createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult()).getId(), this.testHelper.getSingleExecutionIdForActivityAfterMigration("callActivity"));
        CaseExecution caseExecution = (CaseExecution)this.rule.getCaseService().createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.rule.getCaseService().withCaseExecution(caseExecution.getId()).manualStart();
        this.testHelper.completeTask("PI_HumanTask_1");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
        this.rule.getCaseService().withCaseExecution(caseExecution.getCaseInstanceId()).close();
        this.testHelper.assertCaseEnded(caseExecution.getCaseInstanceId());
    }

    @Test
    public void testCallBpmnProcessParallelMultiInstanceRemoveMiBody() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(CallActivityModels.oneBpmnCallActivityProcess("oneTaskProcess")).activityBuilder("callActivity").multiInstance().parallel()).cardinality("1")).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CallActivityModels.oneBpmnCallActivityProcess("oneTaskProcess"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("callActivity").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        this.testHelper.assertSuperExecutionOfProcessInstance(((ProcessInstance)this.rule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId(), this.testHelper.getSingleExecutionIdForActivityAfterMigration("callActivity"));
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCallCmmnCaseParallelMultiInstanceRemoveMiBody() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(CallActivityModels.oneCmmnCallActivityProcess("oneTaskCase")).activityBuilder("callActivity").multiInstance().parallel()).cardinality("1")).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CallActivityModels.oneCmmnCallActivityProcess("oneTaskCase"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("callActivity").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        this.testHelper.assertSuperExecutionOfCaseInstance(((CaseInstance)this.rule.getCaseService().createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult()).getId(), this.testHelper.getSingleExecutionIdForActivityAfterMigration("callActivity"));
        CaseExecution caseExecution = (CaseExecution)this.rule.getCaseService().createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.rule.getCaseService().withCaseExecution(caseExecution.getId()).manualStart();
        this.testHelper.completeTask("PI_HumanTask_1");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
        this.rule.getCaseService().withCaseExecution(caseExecution.getCaseInstanceId()).close();
        this.testHelper.assertCaseEnded(caseExecution.getCaseInstanceId());
    }

    @Test
    public void testCallBpmnProcessSequentialMultiInstanceRemoveMiBody() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(CallActivityModels.oneBpmnCallActivityProcess("oneTaskProcess")).activityBuilder("callActivity").multiInstance().sequential()).cardinality("1")).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CallActivityModels.oneBpmnCallActivityProcess("oneTaskProcess"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("callActivity").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        this.testHelper.assertSuperExecutionOfProcessInstance(((ProcessInstance)this.rule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId(), this.testHelper.getSingleExecutionIdForActivityAfterMigration("callActivity"));
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCallCmmnCaseSequentialMultiInstanceRemoveMiBody() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(CallActivityModels.oneCmmnCallActivityProcess("oneTaskCase")).activityBuilder("callActivity").multiInstance().sequential()).cardinality("1")).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CallActivityModels.oneCmmnCallActivityProcess("oneTaskCase"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("callActivity").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("callActivity", this.testHelper.getSingleActivityInstanceBeforeMigration("callActivity").getId()).done());
        this.testHelper.assertSuperExecutionOfCaseInstance(((CaseInstance)this.rule.getCaseService().createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult()).getId(), this.testHelper.getSingleExecutionIdForActivityAfterMigration("callActivity"));
        CaseExecution caseExecution = (CaseExecution)this.rule.getCaseService().createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.rule.getCaseService().withCaseExecution(caseExecution.getId()).manualStart();
        this.testHelper.completeTask("PI_HumanTask_1");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
        this.rule.getCaseService().withCaseExecution(caseExecution.getCaseInstanceId()).close();
        this.testHelper.assertCaseEnded(caseExecution.getCaseInstanceId());
    }

    @Test
    public void testCallBpmnProcessReconfigureCallActivity() {
        BpmnModelInstance model = CallActivityModels.oneBpmnCallActivityProcess("oneTaskProcess");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((CallActivityBuilder)ModifiableBpmnModelInstance.modify(model).callActivityBuilder("callActivity").calledElement("foo")).done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("callActivity", "callActivity").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        ProcessInstance calledInstance = (ProcessInstance)this.rule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").singleResult();
        Assert.assertNotNull((Object)calledInstance);
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }
}

