/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CompensationModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.MigratingProcessInstanceValidationReportAssert;
import org.camunda.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationCompensationTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testCannotMigrateActivityInstanceForCompensationThrowingEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("compensationEvent", "compensationEvent").mapActivities("compensationHandler", "compensationHandler").build();
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasActivityInstanceFailures("compensationEvent", "The type of the source activity is not supported for activity instance migration");
        }
    }

    @Test
    public void testCannotMigrateActivityInstanceForCancelEndEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.TRANSACTION_COMPENSATION_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.TRANSACTION_COMPENSATION_MODEL);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("transactionEndEvent", "transactionEndEvent").mapActivities("compensationHandler", "compensationHandler").build();
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasActivityInstanceFailures("transactionEndEvent", "The type of the source activity is not supported for activity instance migration");
        }
    }

    @Test
    public void testCannotMigrateActiveCompensationWithoutInstructionForThrowingEventCase1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("compensationHandler", "compensationHandler").build();
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasActivityInstanceFailures("compensationEvent", "There is no migration instruction for this instance's activity", "The type of the source activity is not supported for activity instance migration");
        }
    }

    @Test
    public void testCannotMigrateActiveCompensationWithoutInstructionForThrowingEventCase2() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_END_EVENT_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_END_EVENT_MODEL);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("compensationHandler", "compensationHandler").build();
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasActivityInstanceFailures("compensationEvent", "There is no migration instruction for this instance's activity", "The type of the source activity is not supported for activity instance migration");
        }
    }

    @Test
    public void testCannotMigrateWithoutMappingCompensationBoundaryEvents() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").build();
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasActivityInstanceFailures(sourceProcessDefinition.getId(), "Cannot migrate subscription for compensation handler 'compensationHandler'. There is no migration instruction for the compensation boundary event");
        }
    }

    @Test
    public void testCannotRemoveCompensationEventSubscriptions() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").build();
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasActivityInstanceFailures(sourceProcessDefinition.getId(), "Cannot migrate subscription for compensation handler 'compensationHandler'. There is no migration instruction for the compensation boundary event");
        }
    }

    @Test
    public void testCanRemoveCompensationBoundaryWithoutEventSubscriptions() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask1");
        Assert.assertEquals((long)0L, (long)this.testHelper.snapshotAfterMigration.getEventSubscriptions().size());
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCannotTriggerAddedCompensationForCompletedInstances() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)0L, (long)this.testHelper.snapshotAfterMigration.getEventSubscriptions().size());
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanTriggerAddedCompensationForActiveInstances() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask1").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.completeTask("userTask");
        Assert.assertEquals((long)1L, (long)this.rule.getRuntimeService().createEventSubscriptionQuery().count());
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanMigrateWithCompensationSubscriptionsInMigratingScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "compensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanMigrateWithCompensationSubscriptionsInMigratingScopeAssertActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").activity("compensationHandler").done());
    }

    @Test
    public void testCanMigrateWithCompensationSubscriptionsInMigratingScopeAssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
    }

    @Test
    public void testCanMigrateWithCompensationSubscriptionsInMigratingScopeChangeIds() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.ONE_COMPENSATION_TASK_MODEL).changeElementId("userTask1", "newUserTask1").changeElementId("compensationBoundary", "newCompensationBoundary").changeElementId("compensationHandler", "newCompensationHandler"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "newCompensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "newCompensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("newCompensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanMigrateWithCompensationEventScopeExecution() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("subProcess", "subProcess", null);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "compensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanMigrateWithCompensationEventScopeExecutionAssertActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").beginScope("subProcess").activity("compensationHandler").done());
    }

    @Test
    public void testCanMigrateWithCompensationEventScopeExecutionAssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        Execution eventScopeExecution = (Execution)this.rule.getRuntimeService().createExecutionQuery().activityId("subProcess").singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("subProcess").scope().eventScope().id(eventScopeExecution.getId()).done());
    }

    @Test
    public void testCanMigrateWithCompensationEventScopeExecutionChangeIds() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL).changeElementId("subProcess", "newSubProcess").changeElementId("userTask1", "newUserTask1").changeElementId("compensationBoundary", "newCompensationBoundary").changeElementId("compensationHandler", "newCompensationHandler"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("subProcess", "newSubProcess").mapActivities("compensationBoundary", "newCompensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("subProcess", "newSubProcess", null);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "newCompensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("newCompensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanMigrateWithCompensationEventScopeExecutionChangeIdsAssertActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL).changeElementId("subProcess", "newSubProcess").changeElementId("userTask1", "newUserTask1").changeElementId("compensationBoundary", "newCompensationBoundary").changeElementId("compensationHandler", "newCompensationHandler"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("subProcess", "newSubProcess").mapActivities("compensationBoundary", "newCompensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").beginScope("newSubProcess").activity("newCompensationHandler").done());
    }

    @Test
    public void testCanMigrateWithCompensationEventScopeExecutionChangeIdsAssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL).changeElementId("subProcess", "newSubProcess").changeElementId("userTask1", "newUserTask1").changeElementId("compensationBoundary", "newCompensationBoundary").changeElementId("compensationHandler", "newCompensationHandler"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("subProcess", "newSubProcess").mapActivities("compensationBoundary", "newCompensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        Execution eventScopeExecution = (Execution)this.rule.getRuntimeService().createExecutionQuery().activityId("subProcess").singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("newSubProcess").scope().eventScope().id(eventScopeExecution.getId()).done());
    }

    @Test
    public void testCanMigrateEventScopeVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Execution subProcessExecution = (Execution)this.rule.getRuntimeService().createExecutionQuery().activityId("userTask1").singleResult();
        this.rule.getRuntimeService().setVariableLocal(subProcessExecution.getId(), "foo", (Object)"bar");
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, beforeMigration.getExecutionId());
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanMigrateWithEventSubProcessHandler() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("subProcess", "subProcess").mapActivities("eventSubProcessStart", "eventSubProcessStart").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcess", "eventSubProcess", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanMigrateWithEventSubProcessHandlerAssertActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("subProcess", "subProcess").mapActivities("eventSubProcessStart", "eventSubProcessStart").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
    }

    @Test
    public void testCanMigrateWithEventSubProcessHandlerAssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("subProcess", "subProcess").mapActivities("eventSubProcessStart", "eventSubProcessStart").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        Execution eventScopeExecution = (Execution)this.rule.getRuntimeService().createExecutionQuery().activityId("subProcess").singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("subProcess").scope().eventScope().id(eventScopeExecution.getId()).done());
    }

    @Test
    public void testCanMigrateWithEventSubProcessHandlerChangeIds() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL).changeElementId("eventSubProcess", "newEventSubProcess"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").mapActivities("subProcess", "subProcess").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcess", "newEventSubProcess", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCanMigrateSiblingEventScopeExecutions() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.DOUBLE_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("subProcess", "outerSubProcess").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcess")).execute();
        List subProcessExecutions = this.rule.getRuntimeService().createExecutionQuery().activityId("userTask1").list();
        for (Execution subProcessExecution : subProcessExecutions) {
            this.rule.getRuntimeService().setVariableLocal(subProcessExecution.getId(), "var", (Object)subProcessExecution.getId());
        }
        this.testHelper.completeAnyTask("userTask1");
        this.testHelper.completeAnyTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeAnyTask("userTask2");
        List compensationTasks = this.rule.getTaskService().createTaskQuery().taskDefinitionKey("compensationHandler").list();
        Assert.assertEquals((long)2L, (long)compensationTasks.size());
        Object value1 = this.rule.getTaskService().getVariable(((Task)compensationTasks.get(0)).getId(), "var");
        Object value2 = this.rule.getTaskService().getVariable(((Task)compensationTasks.get(1)).getId(), "var");
        Assert.assertNotEquals((Object)value1, (Object)value2);
    }

    @Test
    public void testCannotMigrateWithoutCompensationStartEventCase1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasActivityInstanceFailures(sourceProcessDefinition.getId(), "Cannot migrate subscription for compensation handler 'eventSubProcess'. There is no migration instruction for the compensation start event");
        }
    }

    @Test
    public void testCannotMigrateWithoutCompensationStartEventCase2() {
        ModifiableBpmnModelInstance model = ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL).removeFlowNode("compensationBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask2", "userTask2").build();
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasProcessInstanceId(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).hasActivityInstanceFailures(sourceProcessDefinition.getId(), "Cannot migrate subscription for compensation handler 'eventSubProcess'. There is no migration instruction for the compensation start event");
        }
    }

    @Test
    public void testEventScopeHierarchyPreservation() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.DOUBLE_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.DOUBLE_SUBPROCESS_MODEL);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("outerSubProcess", "innerSubProcess").mapActivities("innerSubProcess", "outerSubProcess").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("innerSubProcess", "The closest mapped ancestor 'outerSubProcess' is mapped to scope 'innerSubProcess' which is not an ancestor of target scope 'outerSubProcess'");
        }
    }

    @Test
    public void testCompensationBoundaryHierarchyPreservation() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((SubProcessBuilder)ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL).addSubProcessTo("Process").id("addedSubProcess")).embeddedSubProcess().startEvent().endEvent().done());
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "addedSubProcess").mapActivities("compensationBoundary", "compensationBoundary").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("compensationBoundary", "The closest mapped ancestor 'subProcess' is mapped to scope 'addedSubProcess' which is not an ancestor of target scope 'compensationBoundary'");
        }
    }

    @Test
    public void testCannotMapCompensateStartEventWithoutMappingEventScopeCase1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("eventSubProcessStart", "The source activity's event scope (subProcess) must be mapped to the target activity's event scope (subProcess)");
        }
    }

    @Test
    public void testCannotMapCompensateStartEventWithoutMappingEventScopeCase2() {
        ModifiableBpmnModelInstance model = ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL).removeFlowNode("compensationBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("eventSubProcessStart", "The source activity's event scope (subProcess) must be mapped to the target activity's event scope (subProcess)");
        }
    }
}

