/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Date;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.EventSubProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationEventSubProcessTest {
    public static final String IN_EVENT_SUB_PROCESS_TASK = "inEventSubProcessTask";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMapUserTaskSiblingOfMessageEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.NESTED_EVENT_SUB_PROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.NESTED_EVENT_SUB_PROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.assertEventSubscriptionRemoved("eventSubProcessStart", "Message");
        this.testHelper.assertEventSubscriptionCreated("eventSubProcessStart", "Message");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfMessageEventSubProcessAndTriggerMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.NESTED_EVENT_SUB_PROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.NESTED_EVENT_SUB_PROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage("Message");
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfSignalEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").signal(SIGNAL_NAME)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.assertEventSubscriptionRemoved("eventStart", SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionCreated("eventStart", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfSignalEventSubProcessAndSendSignal() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").signal(SIGNAL_NAME)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(IN_EVENT_SUB_PROCESS_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfTimerEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").timerWithDate(TIMER_DATE)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.assertEventSubProcessTimerJobRemoved("eventStart");
        this.testHelper.assertEventSubProcessTimerJobCreated("eventStart");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfTimerEventSubProcessAndTriggerTimer() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").timerWithDate(TIMER_DATE)).userTask(IN_EVENT_SUB_PROCESS_TASK).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(IN_EVENT_SUB_PROCESS_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateActiveEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities("eventSubProcessTask", "eventSubProcessTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(processInstance.getId()).child("eventSubProcessTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("eventSubProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("eventSubProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("eventSubProcess").getId()).activity("eventSubProcessTask", this.testHelper.getSingleActivityInstanceBeforeMigration("eventSubProcessTask").getId()).done());
        this.testHelper.assertEventSubscriptionRemoved("eventSubProcessStart", "Message");
        this.testHelper.assertEventSubscriptionCreated("eventSubProcessStart", "Message");
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveEventSubProcessPreserveEventSubscription() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities("eventSubProcessTask", "eventSubProcessTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", "eventSubProcessStart", "Message");
    }

    @Test
    public void testMigrateActiveEventSubProcessToEmbeddedSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "subProcess").mapActivities("eventSubProcessTask", "userTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(processInstance.getId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("eventSubProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("eventSubProcess").getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("eventSubProcessTask").getId()).done());
        this.testHelper.assertEventSubscriptionRemoved("eventSubProcessStart", "Message");
        Assert.assertEquals((long)0L, (long)this.testHelper.snapshotAfterMigration.getEventSubscriptions().size());
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveEmbeddedSubProcessToEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "eventSubProcess").mapActivities("userTask", "eventSubProcessTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(processInstance.getId()).child("eventSubProcessTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("eventSubProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity("eventSubProcessTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.assertEventSubscriptionCreated("eventSubProcessStart", "Message");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveSignalEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities("eventSubProcessStart", "eventSubProcessStart").mapActivities("eventSubProcessTask", "eventSubProcessTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", "eventSubProcessStart", SIGNAL_NAME);
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveTimerEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities("eventSubProcessStart", "eventSubProcessStart").mapActivities("eventSubProcessTask", "eventSubProcessTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("eventSubProcessStart", "eventSubProcessStart", "timer-start-event-subprocess");
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveErrorEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.ERROR_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.ERROR_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities("eventSubProcessTask", "eventSubProcessTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveCompensationEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.COMPENSATE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.COMPENSATE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities("eventSubProcessTask", "eventSubProcessTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveEscalationEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.ESCALATION_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.ESCALATION_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities("eventSubProcessTask", "eventSubProcessTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateTaskAddEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "eventSubProcessTask").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("eventSubProcessTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("eventSubProcess").activity("eventSubProcessTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        this.testHelper.assertEventSubscriptionCreated("eventSubProcessStart", "Message");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubprocessMessageTrigger() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", "eventSubProcessStart", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubprocessTimerTrigger() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("eventSubProcessStart", "eventSubProcessStart", "timer-start-event-subprocess");
        Job timerJob = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(timerJob.getId());
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubprocessSignalTrigger() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", "eventSubProcessStart", SIGNAL_NAME);
        this.rule.getRuntimeService().signalEventReceived(SIGNAL_NAME);
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubprocessChangeStartEventType() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("eventSubProcessStart", "Events are not of the same type (signalStartEvent != startTimerEvent)");
        }
    }

    @Test
    public void testMigrateEventSubprocessTimerIncident() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Job timerTriggerJob = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        this.rule.getManagementService().setJobRetries(timerTriggerJob.getId(), 0);
        Incident incidentBeforeMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Incident incidentAfterMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentAfterMigration);
        Assert.assertEquals((Object)incidentBeforeMigration.getId(), (Object)incidentAfterMigration.getId());
        Assert.assertEquals((Object)timerTriggerJob.getId(), (Object)incidentAfterMigration.getConfiguration());
        Assert.assertEquals((Object)"eventSubProcessStart", (Object)incidentAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        this.rule.getManagementService().executeJob(timerTriggerJob.getId());
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateNonInterruptingEventSubprocessMessageTrigger() {
        BpmnModelInstance nonInterruptingModel = ((StartEventBuilder)ModifiableBpmnModelInstance.modify(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS).startEventBuilder("eventSubProcessStart").interrupting(false)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(nonInterruptingModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(nonInterruptingModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", "eventSubProcessStart", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        Assert.assertEquals((long)2L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testUpdateEventMessage() {
        BpmnModelInstance sourceProcess = EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS).renameMessage("Message", "newMessage");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", "Message", "eventSubProcessStart", "newMessage");
        this.rule.getRuntimeService().correlateMessage("newMessage");
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventSignal() {
        BpmnModelInstance sourceProcess = EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS).renameSignal(SIGNAL_NAME, "newSignal");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", SIGNAL_NAME, "eventSubProcessStart", "newSignal");
        this.rule.getRuntimeService().signalEventReceived("newSignal");
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventTimer() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        BpmnModelInstance sourceProcess = EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ((StartEventBuilder)ModifiableBpmnModelInstance.modify(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS).removeChildren("eventSubProcessStart").startEventBuilder("eventSubProcessStart").timerWithDuration("PT50M")).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusMinutes(50).toDate();
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "eventSubProcessStart", newDueDate);
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }
}

