/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.TransitionInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.AsyncProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.EventSubProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MultiInstanceProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.MigratingProcessInstanceValidationReportAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationTransitionInstancesTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).transition("userTask").done());
        this.testHelper.assertJobMigrated("userTask", "userTask", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstanceChangeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS).changeElementId("userTask", "userTaskReplacement"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTaskReplacement").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated("userTask", "userTaskReplacement", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTaskReplacement");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstanceConcurrent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(migrationPlan.getSourceProcessDefinitionId()).startBeforeActivity("userTask")).startBeforeActivity("userTask")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        TransitionInstance[] transitionInstances = this.testHelper.snapshotAfterMigration.getActivityTree().getTransitionInstances("userTask");
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").concurrent().noScope().id(transitionInstances[0].getExecutionId()).up().child("userTask").concurrent().noScope().id(transitionInstances[1].getExecutionId()).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).transition("userTask").transition("userTask").done());
        Assert.assertEquals((long)2L, (long)this.testHelper.snapshotAfterMigration.getJobs().size());
        for (Job job : this.testHelper.snapshotAfterMigration.getJobs()) {
            this.rule.getManagementService().executeJob(job.getId());
            this.testHelper.completeTask("userTask");
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncAfterTransitionInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("userTask1", "userTask1", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncAfterTransitionInstanceChangeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS).changeElementId("userTask1", "userTaskReplacement1").changeElementId("userTask2", "userTaskReplacement2"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTaskReplacement1").mapActivities("userTask2", "userTaskReplacement2").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("userTask1", "userTaskReplacement1", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTaskReplacement2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstanceRemoveIncomingFlow() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS).removeFlowNode("startEvent"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated("userTask", "userTask", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstanceAddIncomingFlow() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS).removeFlowNode("startEvent"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("userTask")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("userTask", "userTask", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncAfterTransitionInstanceRemoveOutgoingFlowCase1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS).removeFlowNode("endEvent").removeFlowNode("userTask2"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("userTask1", "userTask1", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncAfterTransitionInstanceRemoveOutgoingFlowCase2() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_SUBPROCESS_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("userTask1", "userTask1", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncAfterTransitionInstanceAddOutgoingFlowCase1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS).removeFlowNode("endEvent").removeFlowNode("userTask2"));
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("userTask1", "userTask1", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncAfterTransitionInstanceAddOutgoingFlowCase2() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS).activityBuilder("userTask1").userTask("userTask3").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("userTask1", "userTask1", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncAfterTransitionInstanceAddOutgoingFlowCase3() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS).changeElementId("flow1", "flow2").activityBuilder("userTask1").sequenceFlowId("flow3").userTask("userTask3").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("userTask1", "Transition instance is assigned to a sequence flow that cannot be matched in the target activity");
        }
    }

    @Test
    public void testMigrateAsyncAfterTransitionInstanceReplaceOutgoingFlow() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS).changeElementId("flow1", "flow2"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("userTask1", "userTask1", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTransitionInstanceJobProperties() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        Job jobBeforeMigration = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        this.rule.getManagementService().setJobPriority(jobBeforeMigration.getId(), 42L);
        this.rule.getManagementService().setJobRetries(jobBeforeMigration.getId(), 52);
        this.rule.getManagementService().suspendJobById(jobBeforeMigration.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        Assert.assertEquals((long)42L, (long)job.getPriority());
        Assert.assertEquals((long)52L, (long)job.getRetries());
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testMigrateAsyncBeforeStartEventTransitionInstanceCase1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_START_EVENT_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_START_EVENT_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("startEvent", "startEvent").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated("startEvent", "startEvent", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        Assert.assertEquals((String)"Replace this non-API assert with a proper test case that fails when the wrong atomic operation is used", (Object)"process-start", (Object)((JobEntity)job).getJobHandlerConfigurationRaw());
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeStartEventTransitionInstanceCase2() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_START_EVENT_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_START_EVENT_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("startEvent", "subProcessStart").build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("startEvent", "A transition instance that instantiates the process can only be migrated to a process-level flow node");
        }
    }

    @Test
    public void testMigrateAsyncBeforeStartEventTransitionInstanceCase3() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_START_EVENT_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_START_EVENT_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcessStart", "subProcessStart").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated("subProcessStart", "subProcessStart", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeStartEventTransitionInstanceCase4() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_START_EVENT_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_START_EVENT_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcessStart", "startEvent").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated("subProcessStart", "startEvent", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstanceAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").transition("userTask").done());
        this.testHelper.assertJobMigrated("userTask", "userTask", "async-continuation");
        Job job = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstanceConcurrentAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(migrationPlan.getSourceProcessDefinitionId()).startBeforeActivity("userTask")).startBeforeActivity("userTask")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("userTask").concurrent().noScope().up().child("userTask").concurrent().noScope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").transition("userTask").transition("userTask").done());
        Assert.assertEquals((long)2L, (long)this.testHelper.snapshotAfterMigration.getJobs().size());
        for (Job job : this.testHelper.snapshotAfterMigration.getJobs()) {
            this.rule.getManagementService().executeJob(job.getId());
            this.testHelper.completeTask("userTask");
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstanceWithIncident() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS).changeElementId("userTask", "newUserTask"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "newUserTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        Job job = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        this.rule.getManagementService().setJobRetries(job.getId(), 0);
        Incident incidentBeforeMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Incident incidentAfterMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentAfterMigration);
        Assert.assertEquals((Object)incidentBeforeMigration.getId(), (Object)incidentAfterMigration.getId());
        Assert.assertEquals((Object)job.getId(), (Object)incidentAfterMigration.getConfiguration());
        Assert.assertEquals((Object)"newUserTask", (Object)incidentAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        this.rule.getManagementService().executeJob(job.getId());
        this.testHelper.completeTask("newUserTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncBeforeInnerMultiInstance() {
        ModifiableBpmnModelInstance model = ModifiableBpmnModelInstance.modify(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS).asyncBeforeInnerMiActivity("userTask");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        List<Job> jobs = this.testHelper.snapshotAfterMigration.getJobs();
        Assert.assertEquals((long)3L, (long)jobs.size());
        this.testHelper.assertJobMigrated(jobs.get(0), "userTask");
        this.testHelper.assertJobMigrated(jobs.get(1), "userTask");
        this.testHelper.assertJobMigrated(jobs.get(2), "userTask");
        for (Job job : jobs) {
            this.rule.getManagementService().executeJob(job.getId());
        }
        this.testHelper.completeAnyTask("userTask");
        this.testHelper.completeAnyTask("userTask");
        this.testHelper.completeAnyTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateAsyncAfterInnerMultiInstance() {
        ModifiableBpmnModelInstance model = ModifiableBpmnModelInstance.modify(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS).asyncAfterInnerMiActivity("userTask");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        this.testHelper.completeAnyTask("userTask");
        this.testHelper.completeAnyTask("userTask");
        this.testHelper.completeAnyTask("userTask");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List<Job> jobs = this.testHelper.snapshotAfterMigration.getJobs();
        Assert.assertEquals((long)3L, (long)jobs.size());
        this.testHelper.assertJobMigrated(jobs.get(0), "userTask");
        this.testHelper.assertJobMigrated(jobs.get(1), "userTask");
        this.testHelper.assertJobMigrated(jobs.get(2), "userTask");
        for (Job job : jobs) {
            this.rule.getManagementService().executeJob(job.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testCannotMigrateAsyncBeforeTransitionInstanceToNonAsyncActivity() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("userTask", "Target activity is not asyncBefore");
        }
    }

    @Test
    public void testCannotMigrateAsyncAfterTransitionInstanceToNonAsyncActivity() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_AFTER_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("userTask1", "Target activity is not asyncAfter");
        }
    }

    @Test
    public void testCannotMigrateUnmappedTransitionInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("userTask", "There is no migration instruction for this instance's activity");
        }
    }

    @Test
    public void testCannotMigrateUnmappedTransitionInstanceAtNonLeafActivity() {
        BpmnModelInstance model = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaAsyncBefore(true).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("subProcess", "There is no migration instruction for this instance's activity");
        }
    }

    @Test
    public void testCannotMigrateUnmappedTransitionInstanceWithIncident() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        Job job = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        this.rule.getManagementService().setJobRetries(job.getId(), 0);
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("userTask", "There is no migration instruction for this instance's activity");
        }
    }

    @Test
    public void testMigrateAsyncBeforeTransitionInstanceToDifferentProcessKey() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS).changeElementId("Process", "newProcess"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated("userTask", "userTask", "async-continuation");
    }

    @Test
    public void testMigrateAsyncAfterCompensateEventSubProcessStartEvent() {
        BpmnModelInstance model = ModifiableBpmnModelInstance.modify(EventSubProcessModels.COMPENSATE_EVENT_SUBPROCESS_PROCESS).flowNodeBuilder("eventSubProcessStart").camundaAsyncAfter().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("eventSubProcess", "eventSubProcess").mapActivities("eventSubProcessStart", "eventSubProcessStart").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcess")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("eventSubProcessStart", "eventSubProcessStart", "async-continuation");
    }

    @Ignore
    @Test
    public void testMigrateAsyncAfterBoundaryEventWithChangedEventScope() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").message("Message")).camundaAsyncAfter()).userTask("afterBoundaryTask").endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).swapElementIds("userTask1", "userTask2");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("boundary", "boundary").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated("boundary", "boundary", "async-continuation");
    }
}

