/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.MigratingProcessInstanceValidationReportAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationUserTaskTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testUserTaskMigrationInProcessDefinitionScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        Task task = this.testHelper.snapshotBeforeMigration.getTaskForKey("userTask");
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertEquals((Object)task.getId(), (Object)migratedTask.getId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUserTaskMigrationInSubProcessScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        Task task = this.testHelper.snapshotBeforeMigration.getTaskForKey("userTask");
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertEquals((Object)task.getId(), (Object)migratedTask.getId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testConcurrentUserTaskMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask1").concurrent().noScope().up().child("userTask2").concurrent().noScope().done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testCannotMigrateWhenNotAllActivityInstancesAreMapped() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should not succeed because the userTask2 instance is not mapped");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasActivityInstanceFailures("userTask2", "There is no migration instruction for this instance's activity");
        }
    }

    @Test
    public void testCannotMigrateWhenNotAllTransitionInstancesAreMapped() {
        BpmnModelInstance model = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").camundaAsyncBefore().moveToActivity("userTask2").camundaAsyncBefore().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should not succeed because the userTask2 instance is not mapped");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("userTask2", "There is no migration instruction for this instance's activity");
        }
    }

    @Test
    public void testChangeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask2").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("userTask1")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask1");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateWithSubTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Task task = (Task)this.rule.getTaskService().createTaskQuery().singleResult();
        Task subTask = this.rule.getTaskService().newTask();
        subTask.setParentTaskId(task.getId());
        this.rule.getTaskService().saveTask(subTask);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Task subTaskAfterMigration = (Task)this.rule.getTaskService().createTaskQuery().taskId(subTask.getId()).singleResult();
        Assert.assertNull((Object)subTaskAfterMigration.getProcessDefinitionId());
        Assert.assertNull((Object)subTaskAfterMigration.getProcessInstanceId());
        this.rule.getTaskService().complete(subTask.getId());
        this.rule.getTaskService().complete(task.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
        if (!this.rule.getProcessEngineConfiguration().getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            this.rule.getHistoryService().deleteHistoricTaskInstance(subTaskAfterMigration.getId());
        }
    }
}

