/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.NativeTaskQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class TaskQueryTest
extends PluggableProcessEngineTestCase {
    private List<String> taskIds;
    protected static final double MAX_DOUBLE_VALUE = 1.0E125;

    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.createMembership("kermit", "management");
        this.identityService.createMembership("kermit", "accountancy");
        this.identityService.createMembership("fozzie", "management");
        this.taskIds = this.generateTestTasks();
    }

    public void tearDown() throws Exception {
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteUser("kermit");
        this.taskService.deleteTasks(this.taskIds, true);
    }

    public void tesBasicTaskPropertiesNotNull() {
        Task task = (Task)this.taskService.createTaskQuery().taskId(this.taskIds.get(0)).singleResult();
        TaskQueryTest.assertNotNull((Object)task.getDescription());
        TaskQueryTest.assertNotNull((Object)task.getId());
        TaskQueryTest.assertNotNull((Object)task.getName());
        TaskQueryTest.assertNotNull((Object)task.getCreateTime());
    }

    public void testQueryNoCriteria() {
        TaskQuery query = this.taskService.createTaskQuery();
        TaskQueryTest.assertEquals((long)12L, (long)query.count());
        TaskQueryTest.assertEquals((int)12, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByTaskId() {
        TaskQuery query = this.taskService.createTaskQuery().taskId(this.taskIds.get(0));
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidTaskId() {
        TaskQuery query = this.taskService.createTaskQuery().taskId("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidName() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskName(null).singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskNameLike("gonzo%");
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidNameLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("1");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskName(null).singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDescription() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescription("testTask description");
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidDescription() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescription("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskDescription(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDescriptionLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescriptionLike("%gonzo%");
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidDescriptionLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescriptionLike("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskDescriptionLike(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByPriority() {
        TaskQuery query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)2, (int)query.list().size());
        TaskQueryTest.assertEquals((long)2L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(100));
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(50));
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMaxPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)9, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMaxPriority(Integer.valueOf(3));
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(50)).taskMaxPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(30)).taskMaxPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(30)).taskPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(30)).taskPriority(Integer.valueOf(20)).taskMaxPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    public void testQueryByInvalidPriority() {
        try {
            this.taskService.createTaskQuery().taskPriority(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByAssignee() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssignee("gonzo");
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("kermit");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByAssigneeLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeLike("gonz%");
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("gonz");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByNullAssignee() {
        try {
            this.taskService.createTaskQuery().taskAssignee(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByUnassigned() {
        TaskQuery query = this.taskService.createTaskQuery().taskUnassigned();
        TaskQueryTest.assertEquals((long)10L, (long)query.count());
        TaskQueryTest.assertEquals((int)10, (int)query.list().size());
    }

    public void testQueryByCandidateUser() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateUser("kermit");
        TaskQueryTest.assertEquals((long)10L, (long)query.count());
        TaskQueryTest.assertEquals((int)10, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateUser("kermit").includeAssignedTasks();
        TaskQueryTest.assertEquals((long)12L, (long)query.count());
        TaskQueryTest.assertEquals((int)12, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateUser("fozzie");
        TaskQueryTest.assertEquals((long)2L, (long)query.count());
        TaskQueryTest.assertEquals((int)2, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateUser("fozzie").includeAssignedTasks();
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateUser("gonzo");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateUser("gonzo").includeAssignedTasks();
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
    }

    public void testQueryByNullCandidateUser() {
        try {
            this.taskService.createTaskQuery().taskCandidateUser(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByIncludeAssignedTasksWithMissingCandidateUserOrGroup() {
        try {
            this.taskService.createTaskQuery().includeAssignedTasks();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCandidateGroup() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroup("management");
        TaskQueryTest.assertEquals((long)2L, (long)query.count());
        TaskQueryTest.assertEquals((int)2, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateGroup("management").includeAssignedTasks();
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroup("accountancy");
        TaskQueryTest.assertEquals((long)2L, (long)query.count());
        TaskQueryTest.assertEquals((int)2, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroup("accountancy").includeAssignedTasks();
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroup("sales");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroup("sales").includeAssignedTasks();
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    public void testQueryByNullCandidateGroup() {
        try {
            this.taskService.createTaskQuery().taskCandidateGroup(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCandidateGroupIn() {
        List<String> groups = Arrays.asList("management", "accountancy");
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups);
        TaskQueryTest.assertEquals((long)4L, (long)query.count());
        TaskQueryTest.assertEquals((int)4, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).includeAssignedTasks();
        TaskQueryTest.assertEquals((long)5L, (long)query.count());
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
        groups = Arrays.asList("management", "accountancy", "sales", "unexising");
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups);
        TaskQueryTest.assertEquals((long)4L, (long)query.count());
        TaskQueryTest.assertEquals((int)4, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).includeAssignedTasks();
        TaskQueryTest.assertEquals((long)5L, (long)query.count());
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
    }

    public void testQueryByNullCandidateGroupIn() {
        try {
            this.taskService.createTaskQuery().taskCandidateGroupIn(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskCandidateGroupIn(new ArrayList()).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDelegationState() {
        TaskQuery query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)12L, (long)query.count());
        TaskQueryTest.assertEquals((int)12, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        String taskId = ((Task)this.taskService.createTaskQuery().taskAssignee("gonzo").singleResult()).getId();
        this.taskService.delegateTask(taskId, "kermit");
        query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        this.taskService.resolveTask(taskId);
        query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
    }

    public void testQueryCreatedOn() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date createTime = sdf.parse("01/01/2001 01:01:01.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedOn(createTime);
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
    }

    public void testQueryCreatedBefore() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date before = sdf.parse("03/02/2002 02:02:02.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedBefore(before);
        TaskQueryTest.assertEquals((long)7L, (long)query.count());
        TaskQueryTest.assertEquals((int)7, (int)query.list().size());
        before = sdf.parse("01/01/2001 01:01:01.000");
        query = this.taskService.createTaskQuery().taskCreatedBefore(before);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    public void testQueryCreatedAfter() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date after = sdf.parse("03/03/2003 03:03:03.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedAfter(after);
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        after = sdf.parse("05/05/2005 05:05:05.000");
        query = this.taskService.createTaskQuery().taskCreatedAfter(after);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    public void testCreateTimeCombinations() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date createTime = sdf.parse("01/01/2001 01:01:01.000");
        Date oneHourAgo = new Date(createTime.getTime() - 3600000L);
        Date oneHourLater = new Date(createTime.getTime() + 3600000L);
        TaskQueryTest.assertEquals((long)6L, (long)this.taskService.createTaskQuery().taskCreatedAfter(oneHourAgo).taskCreatedOn(createTime).taskCreatedBefore(oneHourLater).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCreatedAfter(oneHourLater).taskCreatedOn(createTime).taskCreatedBefore(oneHourAgo).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCreatedAfter(oneHourLater).taskCreatedOn(createTime).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCreatedOn(createTime).taskCreatedBefore(oneHourAgo).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    public void testTaskDefinitionKey() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = this.taskService.createTaskQuery().taskDefinitionKey("taskKey1").list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKey("unexistingKey").count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    public void testTaskDefinitionKeyLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("taskKey1%").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)2, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(1)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("%123").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("%Key12%").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKeyLike("%unexistingKey%").count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    public void testTaskDefinitionKeyIn() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{"taskKey1"}).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{"taskKey1", "taskKey123"}).orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)2, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(1)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{"taskKey1", "taskKey123", "unexistingKey"}).orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)2, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(1)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{"unexistingKey"}).count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
        count = this.taskService.createTaskQuery().taskDefinitionKey("unexistingKey").taskDefinitionKeyIn(new String[]{"taskKey1"}).count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment
    public void testTaskVariableValueEquals() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("unexistingVar", (Object)"value").count());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("booleanVar", (Object)false).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    public void testTaskVariableValueLike() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal%").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVal%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVar").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.taskService.createTaskQuery().taskVariableValueLike("stringVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    public void testTaskVariableValueCompare() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment
    public void testProcessVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nullVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("booleanVar", (Object)false).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("longVar", (Object)928374L).count());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)"theValue");
        this.taskService.setVariableLocal(task.getId(), "longVar", (Object)928374L);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).taskVariableValueEquals("taskVar", (Object)"theValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).taskVariableValueEquals("longVar", (Object)928374L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    public void testProcessVariableValueLike() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal%").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVal%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVar").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.taskService.createTaskQuery().processVariableValueLike("stringVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    public void testProcessVariableValueCompare() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueNumberComparison() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("var", (Object)Variables.numberValue((Number)123)).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("var", (Object)Variables.numberValue((Number)123)).count());
        TaskQueryTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("var", (Object)Variables.numberValue((Number)123)).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("var", (Object)Variables.numberValue((Number)123)).count());
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("var", (Object)Variables.numberValue((Number)123)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        TaskQueryTest.assertEquals((int)8, (int)tasks.size());
        this.taskService.setVariableLocal(((Task)tasks.get(0)).getId(), "var", (Object)123L);
        this.taskService.setVariableLocal(((Task)tasks.get(1)).getId(), "var", (Object)12345L);
        this.taskService.setVariableLocal(((Task)tasks.get(2)).getId(), "var", (Object)123);
        this.taskService.setVariableLocal(((Task)tasks.get(3)).getId(), "var", (Object)123.0);
        this.taskService.setVariableLocal(((Task)tasks.get(4)).getId(), "var", (Object)123);
        this.taskService.setVariableLocal(((Task)tasks.get(5)).getId(), "var", null);
        this.taskService.setVariableLocal(((Task)tasks.get(6)).getId(), "var", (Object)Variables.longValue(null));
        this.taskService.setVariableLocal(((Task)tasks.get(7)).getId(), "var", (Object)"123");
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        TaskQueryTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testVariableEqualsNumberMax() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 1.0E125));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Long.MAX_VALUE));
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)1.0E125)).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)Long.MAX_VALUE)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testVariableEqualsNumberLongValueOverflow() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 1.0E125));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Long.MAX_VALUE));
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)1.0E125)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testVariableEqualsNumberNonIntegerDoubleShouldNotMatchInteger() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)42).putValue("var2", (Object)52.4));
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)42.4)).count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 42.4));
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)52)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionId() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionId(processInstance.getProcessDefinitionId()).list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionId("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionKey() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionKey("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionKeyIn() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"oneTaskProcess"}).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"theTask", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"oneTaskProcess", "taskDefinitionKeyProcess"}).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        HashSet<String> keysFound = new HashSet<String>();
        for (Task task : tasks) {
            keysFound.add(task.getTaskDefinitionKey());
        }
        TaskQueryTest.assertTrue((boolean)keysFound.contains("taskKey123"));
        TaskQueryTest.assertTrue((boolean)keysFound.contains("theTask"));
        TaskQueryTest.assertTrue((boolean)keysFound.contains("taskKey1"));
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"oneTaskProcess", "NonExistingKey"}).orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"theTask", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"NonExistingKey"}).count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
        count = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"oneTaskProcess"}).processDefinitionKey("NonExistingKey").count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionName() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionName("The One Task Process").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionName("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionNameLike() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionNameLike("The One Task%").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionNameLike("The One Task").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionNameLike("The Other Task%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessInstanceBusinessKey() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processDefinitionName("The One Task Process").processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKey("NON-EXISTING").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessInstanceBusinessKeyIn() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-2");
        List tasks = this.taskService.createTaskQuery().processInstanceBusinessKeyIn(new String[]{"BUSINESS-KEY-1"}).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"theTask", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = this.taskService.createTaskQuery().processInstanceBusinessKeyIn(new String[]{"BUSINESS-KEY-1", "BUSINESS-KEY-2"}).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            TaskQueryTest.assertEquals((String)"theTask", (String)task.getTaskDefinitionKey());
        }
        Task task = (Task)this.taskService.createTaskQuery().processInstanceBusinessKeyIn(new String[]{"BUSINESS-KEY-1", "NON-EXISTING-KEY"}).singleResult();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((String)"theTask", (String)task.getTaskDefinitionKey());
        long count = this.taskService.createTaskQuery().processInstanceBusinessKeyIn(new String[]{"BUSINESS-KEY-1"}).processInstanceBusinessKey("NON-EXISTING-KEY").count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessInstanceBusinessKeyLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processDefinitionName("The One Task Process").processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUSINESS-KEY%").list().size());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUSINESS-KEY").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUZINESS-KEY%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueDate() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setDueDate(dueDate);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueDate(dueDate).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueDate(otherDate.getTime()).count());
        Calendar priorDate = Calendar.getInstance();
        priorDate.setTime(dueDate);
        priorDate.roll(1, -1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(priorDate.getTime()).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueBefore(otherDate.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueBefore() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Calendar dueDateCal = Calendar.getInstance();
        task.setDueDate(dueDateCal.getTime());
        this.taskService.saveTask(task);
        Calendar oneHourAgo = Calendar.getInstance();
        oneHourAgo.setTime(dueDateCal.getTime());
        oneHourAgo.add(10, -1);
        Calendar oneHourLater = Calendar.getInstance();
        oneHourLater.setTime(dueDateCal.getTime());
        oneHourLater.add(10, 1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueBefore(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourAgo.getTime()).count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(null);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourAgo.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueAfter() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Calendar dueDateCal = Calendar.getInstance();
        task.setDueDate(dueDateCal.getTime());
        this.taskService.saveTask(task);
        Calendar oneHourAgo = Calendar.getInstance();
        oneHourAgo.setTime(dueDateCal.getTime());
        oneHourAgo.add(10, -1);
        Calendar oneHourLater = Calendar.getInstance();
        oneHourLater.setTime(dueDateCal.getTime());
        oneHourLater.add(10, 1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater.getTime()).count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(null);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueDateCombinations() throws ParseException {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setDueDate(dueDate);
        this.taskService.saveTask(task);
        Date oneHourAgo = new Date(dueDate.getTime() - 3600000L);
        Date oneHourLater = new Date(dueDate.getTime() + 3600000L);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo).dueDate(dueDate).dueBefore(oneHourLater).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater).dueDate(dueDate).dueBefore(oneHourAgo).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater).dueDate(dueDate).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueDate(dueDate).dueBefore(oneHourAgo).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testFollowUpDate() throws Exception {
        Calendar otherDate = Calendar.getInstance();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).followUpBeforeOrNotExistent(otherDate.getTime()).count());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date followUpDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setFollowUpDate(followUpDate);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((Object)followUpDate, (Object)((Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpDate(followUpDate).count());
        otherDate.setTime(followUpDate);
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpBefore(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).followUpBeforeOrNotExistent(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpAfter(otherDate.getTime()).count());
        otherDate.add(1, -2);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpAfter(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpBefore(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).followUpBeforeOrNotExistent(otherDate.getTime()).count());
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testFollowUpDateCombinations() throws ParseException {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setFollowUpDate(dueDate);
        this.taskService.saveTask(task);
        Date oneHourAgo = new Date(dueDate.getTime() - 3600000L);
        Date oneHourLater = new Date(dueDate.getTime() + 3600000L);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpAfter(oneHourAgo).followUpDate(dueDate).followUpBefore(oneHourLater).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpAfter(oneHourLater).followUpDate(dueDate).followUpBefore(oneHourAgo).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpAfter(oneHourLater).followUpDate(dueDate).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(dueDate).followUpBefore(oneHourAgo).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByActivityInstanceId() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)processInstance;
        String activityInstanceId = execution.getActivityInstanceId();
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId}).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByMultipleActivityInstanceIds() throws Exception {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance1 instanceof ExecutionEntity));
        ExecutionEntity execution1 = (ExecutionEntity)processInstance1;
        String activityInstanceId1 = execution1.getActivityInstanceId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance2 instanceof ExecutionEntity));
        ExecutionEntity execution2 = (ExecutionEntity)processInstance2;
        String activityInstanceId2 = execution2.getActivityInstanceId();
        List result1 = this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId1}).list();
        TaskQueryTest.assertEquals((int)1, (int)result1.size());
        TaskQueryTest.assertEquals((String)processInstance1.getId(), (String)((Task)result1.get(0)).getProcessInstanceId());
        List result2 = this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId2}).list();
        TaskQueryTest.assertEquals((int)1, (int)result2.size());
        TaskQueryTest.assertEquals((String)processInstance2.getId(), (String)((Task)result2.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((int)2, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId1, activityInstanceId2}).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByInvalidActivityInstanceId() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertEquals((int)0, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{"anInvalidActivityInstanceId"}).list().size());
    }

    public void testQueryPaging() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateUser("kermit");
        TaskQueryTest.assertEquals((int)10, (int)query.listPage(0, Integer.MAX_VALUE).size());
        TaskQueryTest.assertEquals((long)10L, (long)query.count());
        TaskQueryTest.assertEquals((int)10, (int)query.list().size());
        TaskQueryTest.assertEquals((int)2, (int)query.listPage(0, 2).size());
        TaskQueryTest.assertEquals((int)2, (int)query.listPage(2, 2).size());
        TaskQueryTest.assertEquals((int)3, (int)query.listPage(4, 3).size());
        TaskQueryTest.assertEquals((int)1, (int)query.listPage(9, 3).size());
        TaskQueryTest.assertEquals((int)1, (int)query.listPage(9, 1).size());
        TaskQueryTest.assertEquals((int)0, (int)query.listPage(-1, -1).size());
        TaskQueryTest.assertEquals((int)0, (int)query.listPage(10, 2).size());
        TaskQueryTest.assertEquals((int)10, (int)query.listPage(0, 15).size());
    }

    public void testQuerySorting() {
        int expectedCount = 12;
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery(), expectedCount, TestOrderingUtil.taskById());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskId().asc(), expectedCount, TestOrderingUtil.taskById());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskName().asc(), expectedCount, TestOrderingUtil.taskByName());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskPriority().asc(), expectedCount, TestOrderingUtil.taskByPriority());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskAssignee().asc(), expectedCount, TestOrderingUtil.taskByAssignee());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskDescription().asc(), expectedCount, TestOrderingUtil.taskByDescription());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByProcessInstanceId().asc(), expectedCount, TestOrderingUtil.taskByProcessInstanceId());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByExecutionId().asc(), expectedCount, TestOrderingUtil.taskByExecutionId());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskCreateTime().asc(), expectedCount, TestOrderingUtil.taskByCreateTime());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByDueDate().asc(), expectedCount, TestOrderingUtil.taskByDueDate());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByFollowUpDate().asc(), expectedCount, TestOrderingUtil.taskByFollowUpDate());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByCaseInstanceId().asc(), expectedCount, TestOrderingUtil.taskByCaseInstanceId());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByCaseExecutionId().asc(), expectedCount, TestOrderingUtil.taskByCaseExecutionId());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskById()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskName().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByName()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskPriority().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByPriority()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskAssignee().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByAssignee()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskDescription().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByDescription()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByProcessInstanceId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByProcessInstanceId()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByExecutionId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByExecutionId()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskCreateTime().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByCreateTime()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByDueDate().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByDueDate()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByFollowUpDate().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByFollowUpDate()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByCaseInstanceId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByCaseInstanceId()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByCaseExecutionId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByCaseExecutionId()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskId().taskName("testTask").asc(), 6, TestOrderingUtil.taskById());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskId().taskName("testTask").desc(), 6, TestOrderingUtil.inverted(TestOrderingUtil.taskById()));
    }

    public void testQuerySortingByNameShouldBeCaseInsensitive() {
        Task task = this.taskService.newTask("caseSensitiveTestTask");
        task.setName("CaseSensitiveTestTask");
        this.taskService.saveTask(task);
        Filter filter = this.filterService.newTaskFilter("taskNameOrdering");
        this.filterService.saveFilter(filter);
        List<String> sortedNames = this.getTaskNamesFromTasks(this.taskService.createTaskQuery().list());
        Collections.sort(sortedNames, String.CASE_INSENSITIVE_ORDER);
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().orderByTaskNameCaseInsensitive().asc();
        List<String> ascNames = this.getTaskNamesFromTasks(taskQuery.list());
        TaskQueryTest.assertEquals(sortedNames, ascNames);
        ascNames = this.getTaskNamesFromTasks(this.filterService.list(filter.getId(), (Query)taskQuery));
        TaskQueryTest.assertEquals(sortedNames, ascNames);
        Collections.reverse(sortedNames);
        taskQuery = (TaskQuery)this.taskService.createTaskQuery().orderByTaskNameCaseInsensitive().desc();
        List<String> descNames = this.getTaskNamesFromTasks(taskQuery.list());
        TaskQueryTest.assertEquals(sortedNames, descNames);
        descNames = this.getTaskNamesFromTasks(this.filterService.list(filter.getId(), (Query)taskQuery));
        TaskQueryTest.assertEquals(sortedNames, descNames);
        this.taskService.deleteTask(task.getId(), true);
        this.filterService.deleteFilter(filter.getId());
    }

    public void testQueryOrderByTaskName() {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        TaskQueryTest.assertEquals((int)12, (int)tasks.size());
        List<String> taskNames = this.getTaskNamesFromTasks(tasks);
        TaskQueryTest.assertEquals((String)"accountancy description", (String)taskNames.get(0));
        TaskQueryTest.assertEquals((String)"accountancy description", (String)taskNames.get(1));
        TaskQueryTest.assertEquals((String)"gonzoTask", (String)taskNames.get(2));
        TaskQueryTest.assertEquals((String)"managementAndAccountancyTask", (String)taskNames.get(3));
        TaskQueryTest.assertEquals((String)"managementTask", (String)taskNames.get(4));
        TaskQueryTest.assertEquals((String)"managementTask", (String)taskNames.get(5));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(6));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(7));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(8));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(9));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(10));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(11));
        tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list();
        TaskQueryTest.assertEquals((int)12, (int)tasks.size());
        taskNames = this.getTaskNamesFromTasks(tasks);
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(0));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(1));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(2));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(3));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(4));
        TaskQueryTest.assertEquals((String)"testTask", (String)taskNames.get(5));
        TaskQueryTest.assertEquals((String)"managementTask", (String)taskNames.get(6));
        TaskQueryTest.assertEquals((String)"managementTask", (String)taskNames.get(7));
        TaskQueryTest.assertEquals((String)"managementAndAccountancyTask", (String)taskNames.get(8));
        TaskQueryTest.assertEquals((String)"gonzoTask", (String)taskNames.get(9));
        TaskQueryTest.assertEquals((String)"accountancy description", (String)taskNames.get(10));
        TaskQueryTest.assertEquals((String)"accountancy description", (String)taskNames.get(11));
    }

    public List<String> getTaskNamesFromTasks(List<Task> tasks) {
        ArrayList<String> names = new ArrayList<String>();
        for (Task task : tasks) {
            names.add(task.getName());
        }
        return names;
    }

    public void testNativeQuery() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        TaskQueryTest.assertEquals((String)(tablePrefix + "ACT_RU_TASK"), (String)this.managementService.getTableName(Task.class));
        TaskQueryTest.assertEquals((String)(tablePrefix + "ACT_RU_TASK"), (String)this.managementService.getTableName(TaskEntity.class));
        TaskQueryTest.assertEquals((int)12, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).list().size());
        TaskQueryTest.assertEquals((long)12L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class))).count());
        TaskQueryTest.assertEquals((long)144L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + tablePrefix + "ACT_RU_TASK T1, " + tablePrefix + "ACT_RU_TASK T2")).count());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T1, " + this.managementService.getTableName(VariableInstanceEntity.class) + " V1 WHERE V1.TASK_ID_ = T1.ID_")).count());
        List tasks = ((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT T1.* FROM " + this.managementService.getTableName(Task.class) + " T1, " + this.managementService.getTableName(VariableInstanceEntity.class) + " V1 WHERE V1.TASK_ID_ = T1.ID_")).list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"gonzoTask", (String)((Task)tasks.get(0)).getName());
        TaskQueryTest.assertEquals((int)12, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT DISTINCT T1.* FROM " + tablePrefix + "ACT_RU_TASK T1")).list().size());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = 'gonzoTask'")).count());
        TaskQueryTest.assertEquals((int)1, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = 'gonzoTask'")).list().size());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = #{taskName}")).parameter("taskName", (Object)"gonzoTask")).count());
    }

    public void testNativeQueryPaging() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        TaskQueryTest.assertEquals((String)(tablePrefix + "ACT_RU_TASK"), (String)this.managementService.getTableName(Task.class));
        TaskQueryTest.assertEquals((String)(tablePrefix + "ACT_RU_TASK"), (String)this.managementService.getTableName(TaskEntity.class));
        TaskQueryTest.assertEquals((int)5, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).listPage(0, 5).size());
        TaskQueryTest.assertEquals((int)2, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).listPage(10, 12).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionKey() {
        String caseDefinitionKey = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getKey();
        this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionKey(caseDefinitionKey);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionKey() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKey(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionName() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        String caseDefinitionId = caseDefinition.getId();
        String caseDefinitionName = caseDefinition.getName();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionName(caseDefinitionName);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionName() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionName(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionNameLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionNameLike("One T%");
        this.verifyQueryResults(query, 1);
        query.caseDefinitionNameLike("%Task Case");
        this.verifyQueryResults(query, 1);
        query.caseDefinitionNameLike("%Task%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionNameLike() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionNameLike("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionNameLike(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceId() {
        String caseDefinitionId = this.getCaseDefinitionId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceId(caseInstanceId);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testQueryByCaseInstanceIdHierarchy.cmmn", "org/camunda/bpm/engine/test/api/task/TaskQueryTest.testQueryByCaseInstanceIdHierarchy.bpmn20.xml"})
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceId(caseInstanceId);
        this.verifyQueryResults(query, 2);
        for (Task task : query.list()) {
            TaskQueryTest.assertEquals((String)caseInstanceId, (String)task.getCaseInstanceId());
            this.taskService.complete(task.getId());
        }
        this.verifyQueryResults(query, 1);
        TaskQueryTest.assertEquals((String)caseInstanceId, (String)((Task)query.singleResult()).getCaseInstanceId());
        this.taskService.complete(((Task)query.singleResult()).getId());
        this.verifyQueryResults(query, 0);
    }

    public void testQueryByInvalidCaseInstanceId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceBusinessKey() {
        String caseDefinitionId = this.getCaseDefinitionId();
        String businessKey = "aBusinessKey";
        this.caseService.withCaseDefinition(caseDefinitionId).businessKey(businessKey).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKey(businessKey);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseInstanceBusinessKey() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKey(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceBusinessKeyLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        String businessKey = "aBusinessKey";
        this.caseService.withCaseDefinition(caseDefinitionId).businessKey(businessKey).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKeyLike("aBus%");
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKeyLike("%sinessKey");
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKeyLike("%sines%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseInstanceBusinessKeyLike() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKeyLike("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKeyLike(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionId() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String humanTaskExecutionId = this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseExecutionId(humanTaskExecutionId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseExecutionId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseExecutionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseExecutionId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueEquals("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueEquals("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByFileCaseInstanceVariableValueEquals() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueEquals(variableName, (Object)fileValue).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Variables of type File cannot be used to query"));
        }
    }

    protected void startDefaultCaseWithVariable(Object variableValue, String variableName) {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.createCaseWithVariable(caseDefinitionId, variableValue, variableName);
        this.startDefaultCaseExecutionManually();
    }

    protected String getCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        return caseDefinitionId;
    }

    protected void createCaseWithVariable(String caseDefinitionId, Object variableValue, String variableName) {
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable(variableName, variableValue).create();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        this.startDefaultCaseExecutionManually();
        Date before = new Date(now.getTime() - 100000L);
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByFileCaseInstanceVariableValueNotEquals() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotEquals(variableName, (Object)fileValue).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Variables of type File cannot be used to query"));
        }
    }

    protected FileValue createDefaultFileValue() {
        FileValue fileValue = (FileValue)Variables.fileValue((String)"tst.txt").file("somebytes".getBytes()).create();
        return fileValue;
    }

    protected String startDefaultCaseExecutionManually() {
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        return humanTaskExecutionId;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aBooleanValue", (Object)false).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByFileCaseInstanceVariableValueGreaterThan() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan(variableName, (Object)fileValue).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Variables of type File cannot be used to query"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aBooleanValue", (Object)false).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueGreaterThanOrEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThanOrEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByFileCaseInstanceVariableValueGreaterThanOrEqual() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals(variableName, (Object)fileValue).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Variables of type File cannot be used to query"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aBooleanValue", (Object)false).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByFileCaseInstanceVariableValueLessThan() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan(variableName, (Object)fileValue).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Variables of type File cannot be used to query"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aBooleanValue", (Object)false).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueLessThanOrEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThanOrEquals("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByFileCaseInstanceVariableValueLessThanOrEqual() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals(variableName, (Object)fileValue).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Variables of type File cannot be used to query"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLike("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 1);
    }

    @Deployment
    public void testQueryByVariableInParallelBranch() throws Exception {
        this.runtimeService.startProcessInstanceByKey("parallelGateway");
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        this.runtimeService.setVariableLocal(task1Execution.getId(), "var", (Object)12345L);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "var", (Object)12345);
        TaskQueryTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)12345).count());
        TaskQueryTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)12345L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByProcessVariables() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "bValue"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "cValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "aValue"));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).desc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        List unorderedTasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)unorderedTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testLocalExecutionVariable.bpmn20.xml"})
    public void testQueryResultOrderingByExecutionVariables() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("parallelGateway", Collections.singletonMap("var", "aValue"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("parallelGateway", Collections.singletonMap("var", "bValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("parallelGateway", Collections.singletonMap("var", "cValue"));
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.runtimeService.setVariableLocal(task1.getExecutionId(), "var", (Object)"cValue");
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.runtimeService.setVariableLocal(task2.getExecutionId(), "var", (Object)"bValue");
        Task task3 = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        this.runtimeService.setVariableLocal(task3.getExecutionId(), "var", (Object)"aValue");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("parallelGateway").orderByExecutionVariable("var", (ValueType)ValueType.STRING).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByTaskVariables() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "aValue"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "bValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "cValue"));
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.taskService.setVariableLocal(task1.getId(), "var", (Object)"cValue");
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.taskService.setVariableLocal(task2.getId(), "var", (Object)"bValue");
        Task task3 = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        this.taskService.setVariableLocal(task3.getId(), "var", (Object)"aValue");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByTaskVariable("var", (ValueType)ValueType.STRING).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryResultOrderingByCaseInstanceVariables() {
        CaseInstance instance1 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "cValue"));
        CaseInstance instance2 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "aValue"));
        CaseInstance instance3 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "bValue"));
        List caseExecutions = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").list();
        for (CaseExecution caseExecution : caseExecutions) {
            this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
        }
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().caseDefinitionKey("oneTaskCase").orderByCaseInstanceVariable("var", (ValueType)ValueType.STRING).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(0)).getCaseInstanceId());
        TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(1)).getCaseInstanceId());
        TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(2)).getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryResultOrderingByCaseExecutionVariables() {
        CaseInstance instance1 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "cValue"));
        CaseInstance instance2 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "aValue"));
        CaseInstance instance3 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "bValue"));
        CaseExecution caseExecution1 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").caseInstanceId(instance1.getId()).singleResult();
        this.caseService.withCaseExecution(caseExecution1.getId()).setVariableLocal("var", (Object)"aValue").manualStart();
        CaseExecution caseExecution2 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").caseInstanceId(instance2.getId()).singleResult();
        this.caseService.withCaseExecution(caseExecution2.getId()).setVariableLocal("var", (Object)"bValue").manualStart();
        CaseExecution caseExecution3 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").caseInstanceId(instance3.getId()).singleResult();
        this.caseService.withCaseExecution(caseExecution3.getId()).setVariableLocal("var", (Object)"cValue").manualStart();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().caseDefinitionKey("oneTaskCase").orderByCaseExecutionVariable("var", (ValueType)ValueType.STRING).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(0)).getCaseInstanceId());
        TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(1)).getCaseInstanceId());
        TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(2)).getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByVariablesWithNullValues() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "bValue"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "cValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "aValue"));
        ProcessInstance instance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Task firstTask = (Task)tasks.get(0);
        if (firstTask.getProcessInstanceId().equals(instance4.getId())) {
            TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(3)).getProcessInstanceId());
        } else {
            TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance4.getId(), (String)((Task)tasks.get(3)).getProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByVariablesWithMixedTypes() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 42));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "cValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "aValue"));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Task firstTask = (Task)tasks.get(0);
        if (firstTask.getProcessInstanceId().equals(instance1.getId())) {
            TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        } else {
            TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByStringVariableWithMixedCase() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "a"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "B"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "c"));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByVariablesOfAllPrimitiveTypes() {
        ProcessInstance booleanInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", true));
        ProcessInstance shortInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)16));
        ProcessInstance longInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 500L));
        ProcessInstance intInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 400));
        ProcessInstance stringInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "300"));
        ProcessInstance dateInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", new Date(1000L)));
        ProcessInstance doubleInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 42.5));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.BOOLEAN).asc()).list();
        this.verifyFirstOrLastTask(tasks, booleanInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.SHORT).asc()).list();
        this.verifyFirstOrLastTask(tasks, shortInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.LONG).asc()).list();
        this.verifyFirstOrLastTask(tasks, longInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        this.verifyFirstOrLastTask(tasks, intInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        this.verifyFirstOrLastTask(tasks, stringInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.DATE).asc()).list();
        this.verifyFirstOrLastTask(tasks, dateInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.DOUBLE).asc()).list();
        this.verifyFirstOrLastTask(tasks, doubleInstance);
    }

    public void testQueryByUnsupportedValueTypes() {
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.BYTES);
            TaskQueryTest.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot order by variables of type byte", e.getMessage());
        }
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.NULL);
            TaskQueryTest.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot order by variables of type null", e.getMessage());
        }
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.NUMBER);
            TaskQueryTest.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot order by variables of type number", e.getMessage());
        }
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.OBJECT);
            TaskQueryTest.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot order by variables of type object", e.getMessage());
        }
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.FILE);
            TaskQueryTest.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot order by variables of type file", e.getMessage());
        }
    }

    protected void verifyFirstOrLastTask(List<Task> tasks, ProcessInstance belongingProcessInstance) {
        if (tasks.size() == 0) {
            TaskQueryTest.fail((String)"no tasks given");
        }
        int numTasks = tasks.size();
        boolean matches = tasks.get(0).getProcessInstanceId().equals(belongingProcessInstance.getId());
        matches = matches || tasks.get(numTasks - 1).getProcessInstanceId().equals(belongingProcessInstance.getId());
        TaskQueryTest.assertTrue((String)("neither first nor last task belong to process instance " + belongingProcessInstance.getId()), (boolean)matches);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByVariablesWithMixedTypesAndSameColumn() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 42));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 800));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 500L));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        Task firstTask = (Task)tasks.get(0);
        if (firstTask.getProcessInstanceId().equals(instance3.getId())) {
            TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        } else {
            TaskQueryTest.assertEquals((String)instance1.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance2.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
            TaskQueryTest.assertEquals((String)instance3.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByTwoVariables() {
        ProcessInstance bInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"b").putValue("var2", (Object)14));
        ProcessInstance bInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"b").putValue("var2", (Object)30));
        ProcessInstance cInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"c").putValue("var2", (Object)50));
        ProcessInstance cInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"c").putValue("var2", (Object)30));
        ProcessInstance aInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a").putValue("var2", (Object)14));
        ProcessInstance aInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a").putValue("var2", (Object)50));
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).desc()).orderByProcessVariable("var2", (ValueType)ValueType.INTEGER).asc()).list();
        TaskQueryTest.assertEquals((int)6, (int)tasks.size());
        TaskQueryTest.assertEquals((String)cInstance2.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)cInstance1.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)bInstance1.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)bInstance2.getId(), (String)((Task)tasks.get(3)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)aInstance1.getId(), (String)((Task)tasks.get(4)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)aInstance2.getId(), (String)((Task)tasks.get(5)).getProcessInstanceId());
        tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var2", (ValueType)ValueType.INTEGER).desc()).orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        TaskQueryTest.assertEquals((int)6, (int)tasks.size());
        TaskQueryTest.assertEquals((String)aInstance2.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)cInstance1.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)bInstance2.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)cInstance2.getId(), (String)((Task)tasks.get(3)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)aInstance1.getId(), (String)((Task)tasks.get(4)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)bInstance1.getId(), (String)((Task)tasks.get(5)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryResultOrderingByVariablesWithSecondaryOrderingByProcessInstanceId() {
        ProcessInstance bInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"b"));
        ProcessInstance bInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"b"));
        ProcessInstance cInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"c"));
        ProcessInstance cInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"c"));
        ProcessInstance aInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a"));
        ProcessInstance aInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a"));
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).orderByProcessInstanceId().asc()).list();
        TaskQueryTest.assertEquals((int)6, (int)tasks.size());
        this.verifyTasksSortedByProcessInstanceId(Arrays.asList(aInstance1, aInstance2), tasks.subList(0, 2));
        this.verifyTasksSortedByProcessInstanceId(Arrays.asList(bInstance1, bInstance2), tasks.subList(2, 4));
        this.verifyTasksSortedByProcessInstanceId(Arrays.asList(cInstance1, cInstance2), tasks.subList(4, 6));
    }

    public void testQueryResultOrderingWithInvalidParameters() {
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable(null, (ValueType)ValueType.STRING).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", null).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByExecutionVariable(null, (ValueType)ValueType.STRING).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByExecutionVariable("var", null).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByTaskVariable(null, (ValueType)ValueType.STRING).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByTaskVariable("var", null).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByCaseInstanceVariable(null, (ValueType)ValueType.STRING).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByCaseInstanceVariable("var", null).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByCaseExecutionVariable(null, (ValueType)ValueType.STRING).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByCaseExecutionVariable("var", null).asc()).list();
            TaskQueryTest.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    protected void verifyTasksSortedByProcessInstanceId(List<ProcessInstance> expectedProcessInstances, List<Task> actualTasks) {
        TaskQueryTest.assertEquals((int)expectedProcessInstances.size(), (int)actualTasks.size());
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>(expectedProcessInstances);
        Collections.sort(instances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance p1, ProcessInstance p2) {
                return p1.getId().compareTo(p2.getId());
            }
        });
        for (int i = 0; i < instances.size(); ++i) {
            TaskQueryTest.assertEquals((String)((ProcessInstance)instances.get(i)).getId(), (String)actualTasks.get(i).getProcessInstanceId());
        }
    }

    private void verifyQueryResults(TaskQuery query, int countExpected) {
        TaskQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        TaskQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            TaskQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            TaskQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(TaskQuery query) {
        try {
            query.singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/oneTaskWithFormKeyProcess.bpmn20.xml"})
    public void testInitializeFormKeys() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).initializeFormKeys().singleResult();
        TaskQueryTest.assertEquals((String)"exampleFormKey", (String)task.getFormKey());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        try {
            task.getFormKey();
            TaskQueryTest.fail((String)"exception expected.");
        }
        catch (BadUserRequestException e) {
            TaskQueryTest.assertEquals((String)"ENGINE-03052 The form key is not initialized. You must call initializeFormKeys() on the task query before you can retrieve the form key.", (String)e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryOrderByProcessVariableInteger() {
        ProcessInstance instance500 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)500));
        ProcessInstance instance1000 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)1000));
        ProcessInstance instance250 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)250));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance250.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance500.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance1000.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).desc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)instance1000.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance500.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        TaskQueryTest.assertEquals((String)instance250.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryOrderByTaskVariableInteger() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task500 = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.taskService.setVariableLocal(task500.getId(), "var", (Object)500);
        Task task250 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.taskService.setVariableLocal(task250.getId(), "var", (Object)250);
        Task task1000 = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        this.taskService.setVariableLocal(task1000.getId(), "var", (Object)1000);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByTaskVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)task250.getId(), (String)((Task)tasks.get(0)).getId());
        TaskQueryTest.assertEquals((String)task500.getId(), (String)((Task)tasks.get(1)).getId());
        TaskQueryTest.assertEquals((String)task1000.getId(), (String)((Task)tasks.get(2)).getId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).desc()).list();
        TaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQueryTest.assertEquals((String)task1000.getId(), (String)((Task)tasks.get(0)).getId());
        TaskQueryTest.assertEquals((String)task500.getId(), (String)((Task)tasks.get(1)).getId());
        TaskQueryTest.assertEquals((String)task250.getId(), (String)((Task)tasks.get(2)).getId());
    }

    public void testQueryByParentTaskId() {
        String parentTaskId = "parentTask";
        Task parent = this.taskService.newTask(parentTaskId);
        this.taskService.saveTask(parent);
        Task sub1 = this.taskService.newTask("subTask1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("subTask2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        TaskQuery query = this.taskService.createTaskQuery().taskParentTaskId(parentTaskId);
        this.verifyQueryResults(query, 2);
        this.taskService.deleteTask(parentTaskId, true);
    }

    public void testExtendTaskQueryList_ProcessDefinitionKeyIn() {
        String processDefinitionKey = "invoice";
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{processDefinitionKey});
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        TaskQuery result = ((TaskQueryImpl)query).extend(extendingQuery);
        String[] processDefinitionKeys = ((TaskQueryImpl)result).getProcessDefinitionKeys();
        TaskQueryTest.assertEquals((int)1, (int)processDefinitionKeys.length);
        TaskQueryTest.assertEquals((String)processDefinitionKey, (String)processDefinitionKeys[0]);
    }

    public void testExtendingTaskQueryList_ProcessDefinitionKeyIn() {
        String processDefinitionKey = "invoice";
        TaskQuery query = this.taskService.createTaskQuery();
        TaskQuery extendingQuery = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{processDefinitionKey});
        TaskQuery result = ((TaskQueryImpl)query).extend(extendingQuery);
        String[] processDefinitionKeys = ((TaskQueryImpl)result).getProcessDefinitionKeys();
        TaskQueryTest.assertEquals((int)1, (int)processDefinitionKeys.length);
        TaskQueryTest.assertEquals((String)processDefinitionKey, (String)processDefinitionKeys[0]);
    }

    public void testExtendTaskQueryList_TaskDefinitionKeyIn() {
        String taskDefinitionKey = "assigneApprover";
        TaskQuery query = this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{taskDefinitionKey});
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        TaskQuery result = ((TaskQueryImpl)query).extend(extendingQuery);
        String[] key = ((TaskQueryImpl)result).getKeys();
        TaskQueryTest.assertEquals((int)1, (int)key.length);
        TaskQueryTest.assertEquals((String)taskDefinitionKey, (String)key[0]);
    }

    public void testExtendingTaskQueryList_TaskDefinitionKeyIn() {
        String taskDefinitionKey = "assigneApprover";
        TaskQuery query = this.taskService.createTaskQuery();
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{taskDefinitionKey});
        TaskQuery result = ((TaskQueryImpl)query).extend(extendingQuery);
        String[] key = ((TaskQueryImpl)result).getKeys();
        TaskQueryTest.assertEquals((int)1, (int)key.length);
        TaskQueryTest.assertEquals((String)taskDefinitionKey, (String)key[0]);
    }

    private List<String> generateTestTasks() throws Exception {
        int i;
        ArrayList<String> ids = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        ClockUtil.setCurrentTime((Date)sdf.parse("01/01/2001 01:01:01.000"));
        for (int i2 = 0; i2 < 6; ++i2) {
            Task task = this.taskService.newTask();
            task.setName("testTask");
            task.setDescription("testTask description");
            task.setPriority(3);
            this.taskService.saveTask(task);
            ids.add(task.getId());
            this.taskService.addCandidateUser(task.getId(), "kermit");
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("02/02/2002 02:02:02.000"));
        Task task = this.taskService.newTask();
        task.setName("gonzoTask");
        task.setDescription("gonzo description");
        task.setPriority(4);
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "gonzo");
        this.taskService.setVariable(task.getId(), "testVar", (Object)"someVariable");
        this.taskService.addCandidateUser(task.getId(), "kermit");
        this.taskService.addCandidateUser(task.getId(), "gonzo");
        ids.add(task.getId());
        ClockUtil.setCurrentTime((Date)sdf.parse("03/03/2003 03:03:03.000"));
        for (i = 0; i < 2; ++i) {
            task = this.taskService.newTask();
            task.setName("managementTask");
            task.setPriority(10);
            this.taskService.saveTask(task);
            this.taskService.addCandidateGroup(task.getId(), "management");
            ids.add(task.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("04/04/2004 04:04:04.000"));
        for (i = 0; i < 2; ++i) {
            task = this.taskService.newTask();
            task.setName("accountancyTask");
            task.setName("accountancy description");
            this.taskService.saveTask(task);
            this.taskService.addCandidateGroup(task.getId(), "accountancy");
            ids.add(task.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("05/05/2005 05:05:05.000"));
        task = this.taskService.newTask();
        task.setName("managementAndAccountancyTask");
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "fozzie");
        this.taskService.addCandidateGroup(task.getId(), "management");
        this.taskService.addCandidateGroup(task.getId(), "accountancy");
        ids.add(task.getId());
        return ids;
    }
}

