/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.end;

import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class EndEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testConcurrentEndOfSameProcess() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskWithDelay");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        EndEventTest.assertNotNull((Object)task);
        TaskCompleter taskCompleter1 = new TaskCompleter(task.getId());
        TaskCompleter taskCompleter2 = new TaskCompleter(task.getId());
        EndEventTest.assertFalse((boolean)taskCompleter1.isSucceeded());
        EndEventTest.assertFalse((boolean)taskCompleter2.isSucceeded());
        taskCompleter1.start();
        taskCompleter2.start();
        taskCompleter1.join();
        taskCompleter2.join();
        int successCount = 0;
        if (taskCompleter1.isSucceeded()) {
            ++successCount;
        }
        if (taskCompleter2.isSucceeded()) {
            ++successCount;
        }
        EndEventTest.assertEquals((String)"(Only) one thread should have been able to successfully end the process", (int)1, (int)successCount);
        this.assertProcessEnded(processInstance.getId());
    }

    class TaskCompleter
    extends Thread {
        protected String taskId;
        protected boolean succeeded;

        public TaskCompleter(String taskId) {
            this.taskId = taskId;
        }

        public boolean isSucceeded() {
            return this.succeeded;
        }

        @Override
        public void run() {
            try {
                EndEventTest.this.taskService.complete(this.taskId);
                this.succeeded = true;
            }
            catch (OptimisticLockingException optimisticLockingException) {
                // empty catch block
            }
        }
    }
}

