/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;

public class HistoricProcessInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricDataCreatedForProcessExecution() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2010);
        calendar.set(2, 8);
        calendar.set(5, 30);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date noon = calendar.getTime();
        ClockUtil.setCurrentTime((Date)noon);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getId(), (String)historicProcessInstance.getId());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getBusinessKey(), (String)historicProcessInstance.getBusinessKey());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)historicProcessInstance.getProcessDefinitionId());
        HistoricProcessInstanceTest.assertEquals((Object)noon, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getDurationInMillis());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getCaseInstanceId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoricProcessInstanceTest.assertEquals((int)1, (int)tasks.size());
        Date twentyFiveSecsAfterNoon = new Date(noon.getTime() + 25000L);
        ClockUtil.setCurrentTime((Date)twentyFiveSecsAfterNoon);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getId(), (String)historicProcessInstance.getId());
        HistoricProcessInstanceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)historicProcessInstance.getProcessDefinitionId());
        HistoricProcessInstanceTest.assertEquals((Object)noon, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertEquals((Object)twentyFiveSecsAfterNoon, (Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertEquals((Object)new Long(25000L), (Object)historicProcessInstance.getDurationInMillis());
        HistoricProcessInstanceTest.assertTrue((((HistoricProcessInstanceEventEntity)historicProcessInstance).getDurationRaw() >= 25000L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getCaseInstanceId());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().unfinished().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testLongRunningHistoricDataCreatedForProcessExecution() {
        long ONE_YEAR = 1471228928L;
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        Date now = cal.getTime();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertEquals((Object)now, (Object)historicProcessInstance.getStartTime());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        HistoricProcessInstanceTest.assertEquals((int)1, (int)tasks.size());
        cal.add(1, 1);
        Date oneYearLater = cal.getTime();
        ClockUtil.setCurrentTime((Date)oneYearLater);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertEquals((Object)now, (Object)historicProcessInstance.getStartTime());
        HistoricProcessInstanceTest.assertEquals((Object)oneYearLater, (Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertTrue((historicProcessInstance.getDurationInMillis() >= 1471228928L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertTrue((((HistoricProcessInstanceEventEntity)historicProcessInstance).getDurationRaw() >= 1471228928L ? 1 : 0) != 0);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceHistoryCreated() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HistoricProcessInstanceTest.assertNotNull((Object)processInstance);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceStartDate() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceFinishDateUnfinished() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceFinishDateFinished() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(date).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceDelete() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertEquals((String)"cancel", (String)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment
    public void testHistoricProcessInstanceDeleteAsync() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failing");
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertEquals((String)"cancel", (String)historicProcessInstance.getDeleteReason());
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryWithIncidents() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("Process_1");
        this.executeAvailableJobs();
        this.runtimeService.startProcessInstanceByKey("Process_1");
        HistoricProcessInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        HistoricProcessInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricProcessInstanceQuery().list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().withIncidents().list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%").count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%").list().size());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown message%").count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown message%").list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incidentTrigger1}. Cause: Cannot resolve identifier 'incidentTrigger1'").count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incidentTrigger1}. Cause: Cannot resolve identifier 'incidentTrigger1'").list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incidentTrigger2}. Cause: Cannot resolve identifier 'incidentTrigger2'").count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incidentTrigger2}. Cause: Cannot resolve identifier 'incidentTrigger2'").list().size());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown message").count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown message").list().size());
    }

    public void testHistoricProcessInstanceQueryWithIncidentMessageNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().incidentMessage(null).count();
            HistoricProcessInstanceTest.fail((String)"incidentMessage with null value is not allowed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testHistoricProcessInstanceQueryWithIncidentMessageLikeNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike(null).count();
            HistoricProcessInstanceTest.fail((String)"incidentMessageLike with null value is not allowed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQuery() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "businessKey123");
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourFromNow.getTime()).startedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey("businessKey123").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("business%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("%sinessKey123").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("%siness%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionName("The One Task Process").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("The One Task%").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("%One Task Process").count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("%One Task%").count());
        ArrayList<String> exludeIds = new ArrayList<String>();
        exludeIds.add("unexistingProcessDefinition");
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(exludeIds).count());
        exludeIds.add("oneTaskProcess");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").processDefinitionKeyNotIn(exludeIds).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(exludeIds).count());
        try {
            this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(Arrays.asList(""));
            HistoricProcessInstanceTest.fail((String)"Exception expected");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).finishedBefore(hourAgo.getTime()).count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%").count());
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: #{failing}. Cause: Cannot resolve identifier 'failing'").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceSorting() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().asc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().desc()).list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().asc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().desc()).count());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().desc()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceSubProcess() {
        ProcessInstance superPi = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest");
        ProcessInstance subPi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superPi.getProcessInstanceId()).singleResult();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().subProcessInstanceId(subPi.getProcessInstanceId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)historicProcessInstance.getId(), (String)superPi.getId());
    }

    public void testInvalidSorting() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().asc();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().desc();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().list();
            HistoricProcessInstanceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteReason() {
        if (!"none".equals(this.processEngineConfiguration.getHistory())) {
            String deleteReason = "some delete reason";
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            this.runtimeService.deleteProcessInstance(pi.getId(), "some delete reason");
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
            HistoricProcessInstanceTest.assertEquals((String)"some delete reason", (String)hpi.getDeleteReason());
        }
    }

    @Deployment
    public void testLongProcessDefinitionKey() {
        String PROCESS_DEFINITION_KEY = "myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome";
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome").singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)hpi);
        this.assertProcessEnded(hpi.getId());
        HistoricProcessInstance hpi2 = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome").singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)hpi2);
        this.assertProcessEnded(hpi2.getId());
        HistoricProcessInstanceTest.assertEquals((String)hpi.getId(), (String)hpi2.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.bpmn20.xml"})
    public void testQueryByCaseInstanceId() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)historicProcessInstance.getCaseInstanceId());
        String taskId = ((Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult()).getId();
        this.taskService.complete(taskId);
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)historicProcessInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceIdHierarchy-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceIdHierarchy-sub.bpmn20.xml"})
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        HistoricProcessInstanceTest.assertEquals((long)2L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)2, (int)query.list().size());
        for (HistoricProcessInstance hpi : query.list()) {
            HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)hpi.getCaseInstanceId());
        }
        String taskId = ((Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult()).getId();
        this.taskService.complete(taskId);
        HistoricProcessInstanceTest.assertEquals((long)2L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)2, (int)query.list().size());
        for (HistoricProcessInstance hpi : query.list()) {
            HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)hpi.getCaseInstanceId());
        }
    }

    public void testQueryByInvalidCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId("invalid");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testBusinessKey.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testBusinessKey.bpmn20.xml"})
    public void testBusinessKey() {
        String businessKey = "aBusinessKey";
        this.caseService.withCaseDefinitionByKey("case").businessKey(businessKey).create().getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.processInstanceBusinessKey(businessKey);
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)businessKey, (String)historicProcessInstance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-sub.bpmn20.xml"})
    public void testStartActivityId() {
        this.runtimeService.startProcessInstanceByKey("super");
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        HistoricProcessInstanceTest.assertEquals((String)"theSubStart", (String)hpi.getStartActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testAsyncStartActivityId-sub.bpmn20.xml"})
    public void testAsyncStartActivityId() {
        this.runtimeService.startProcessInstanceByKey("super");
        this.executeAvailableJobs();
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        HistoricProcessInstanceTest.assertEquals((String)"theSubStart", (String)hpi.getStartActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartByKeyWithCaseInstanceId() {
        String caseInstanceId = "aCaseInstanceId";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId).getId();
        HistoricProcessInstance firstInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)firstInstance);
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)firstInstance.getCaseInstanceId());
        processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId, null).getId();
        HistoricProcessInstance secondInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)secondInstance);
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)secondInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartByIdWithCaseInstanceId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId();
        String caseInstanceId = "aCaseInstanceId";
        String processInstanceId = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId).getId();
        HistoricProcessInstance firstInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)firstInstance);
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)firstInstance.getCaseInstanceId());
        processInstanceId = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId, null).getId();
        HistoricProcessInstance secondInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)secondInstance);
        HistoricProcessInstanceTest.assertEquals((String)caseInstanceId, (String)secondInstance.getCaseInstanceId());
    }

    @Deployment
    public void testEndTimeAndEndActivity() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask2").singleResult()).getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.taskService.complete(taskId);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndActivityId());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndActivityId());
        HistoricProcessInstanceTest.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryBySuperCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(processTaskId);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().superCaseInstanceId(superCaseInstanceId);
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstance subProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)subProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)superCaseInstanceId, (String)subProcessInstance.getSuperCaseInstanceId());
        HistoricProcessInstanceTest.assertNull((Object)subProcessInstance.getSuperProcessInstanceId());
    }

    public void testQueryByInvalidSuperCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.superCaseInstanceId("invalid");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySubCaseInstanceId() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId).singleResult()).getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        HistoricProcessInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricProcessInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstance superProcessInstance = (HistoricProcessInstance)query.singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)superProcessInstance);
        HistoricProcessInstanceTest.assertEquals((String)superProcessInstanceId, (String)superProcessInstance.getId());
        HistoricProcessInstanceTest.assertNull((Object)superProcessInstance.getSuperCaseInstanceId());
        HistoricProcessInstanceTest.assertNull((Object)superProcessInstance.getSuperProcessInstanceId());
    }

    public void testQueryByInvalidSubCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.subCaseInstanceId("invalid");
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricProcessInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricProcessInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSuperCaseInstanceIdProperty() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(processTaskId);
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)instance);
        HistoricProcessInstanceTest.assertEquals((String)superCaseInstanceId, (String)instance.getSuperCaseInstanceId());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)instance);
        HistoricProcessInstanceTest.assertEquals((String)superCaseInstanceId, (String)instance.getSuperCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionKeyProperty() {
        String key = "oneTaskProcess";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNotNull((Object)instance.getProcessDefinitionKey());
        HistoricProcessInstanceTest.assertEquals((String)key, (String)instance.getProcessDefinitionKey());
    }

    @Deployment
    public void FAILING_testProcessInstanceShouldBeActive() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getEndTime());
        HistoricProcessInstanceTest.assertNull((Object)historicProcessInstance.getDurationInMillis());
    }
}

