/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.AcquireJobsCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;

public class ControllableJobExecutor
extends JobExecutor {
    protected ConcurrencyTestCase.ThreadControl acquisitionThreadControl;
    protected ConcurrencyTestCase.ThreadControl executionThreadControl;
    protected boolean syncOnShutdown = true;

    public ControllableJobExecutor() {
        this.acquireJobsRunnable = new RecordingAcquireJobsRunnable(this);
        this.jobAcquisitionThread = new Thread((Runnable)this.acquireJobsRunnable);
        this.acquisitionThreadControl = new ConcurrencyTestCase.ThreadControl(this.jobAcquisitionThread);
        this.executionThreadControl = new ConcurrencyTestCase.ThreadControl(this.jobAcquisitionThread);
        this.acquireJobsCmdFactory = new ControllableJobAcquisitionCommandFactory();
    }

    public ControllableJobExecutor(ProcessEngineImpl processEngine) {
        this();
        this.processEngines.add(processEngine);
    }

    public ControllableJobExecutor proceedAndWaitOnShutdown(boolean syncOnShutdown) {
        this.syncOnShutdown = syncOnShutdown;
        return this;
    }

    protected void ensureInitialization() {
    }

    public ConcurrencyTestCase.ThreadControl getAcquisitionThreadControl() {
        return this.acquisitionThreadControl;
    }

    public ConcurrencyTestCase.ThreadControl getExecutionThreadControl() {
        return this.executionThreadControl;
    }

    protected void startExecutingJobs() {
        this.jobAcquisitionThread.start();
    }

    protected void stopExecutingJobs() {
        if (this.syncOnShutdown) {
            this.acquisitionThreadControl.waitUntilDone(true);
        }
    }

    public RecordingAcquireJobsRunnable getAcquireJobsRunnable() {
        return (RecordingAcquireJobsRunnable)super.getAcquireJobsRunnable();
    }

    public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        this.getExecuteJobsRunnable(jobIds, processEngine).run();
    }

    public class ControllableAcquisitionCommand
    extends ConcurrencyTestCase.ControllableCommand<AcquiredJobs> {
        protected int numJobsToAcquire;

        public ControllableAcquisitionCommand(ConcurrencyTestCase.ThreadControl threadControl, int numJobsToAcquire) {
            super(threadControl);
            this.numJobsToAcquire = numJobsToAcquire;
        }

        public AcquiredJobs execute(CommandContext commandContext) {
            this.monitor.sync();
            AcquiredJobs acquiredJobs = new AcquireJobsCmd((JobExecutor)ControllableJobExecutor.this, this.numJobsToAcquire).execute(commandContext);
            this.monitor.sync();
            return acquiredJobs;
        }
    }

    public class ControllableJobAcquisitionCommandFactory
    implements AcquireJobsCommandFactory {
        public Command<AcquiredJobs> getCommand(int numJobsToAcquire) {
            return new ControllableAcquisitionCommand(ControllableJobExecutor.this.acquisitionThreadControl, numJobsToAcquire);
        }
    }
}

