/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class SignalEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    protected EventSubscriptionDeclaration signalDefinition;

    public SignalEndEventActivityBehavior(EventSubscriptionDeclaration signalDefinition) {
        this.signalDefinition = signalDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        List<SignalEventSubscriptionEntity> signalEventSubscriptions = this.findSignalEventSubscriptions(this.signalDefinition.getEventName(), execution.getTenantId());
        for (SignalEventSubscriptionEntity signalEventSubscription : signalEventSubscriptions) {
            signalEventSubscription.eventReceived(null, this.signalDefinition.isAsync());
        }
        this.leave(execution);
    }

    protected List<SignalEventSubscriptionEntity> findSignalEventSubscriptions(String signalName, String tenantId) {
        EventSubscriptionManager eventSubscriptionManager = Context.getCommandContext().getEventSubscriptionManager();
        if (tenantId != null) {
            return eventSubscriptionManager.findSignalEventSubscriptionsByEventNameAndTenantIdIncludeWithoutTenantId(signalName, tenantId);
        }
        return eventSubscriptionManager.findSignalEventSubscriptionsByEventNameAndTenantId(signalName, null);
    }

    public EventSubscriptionDeclaration getSignalDefinition() {
        return this.signalDefinition;
    }

    public void setSignalDefinition(EventSubscriptionDeclaration signalDefinition) {
        this.signalDefinition = signalDefinition;
    }
}

