/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;

public class ExternalTaskQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String WORKER_ID = "aWorkerId";
    protected static final String TOPIC_NAME = "externalTaskTopic";

    protected void setUp() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
    }

    protected void tearDown() throws Exception {
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSingleResult() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskQueryTest.assertNotNull((Object)externalTask.getId());
        ExternalTaskQueryTest.assertEquals((String)processInstance.getId(), (String)externalTask.getProcessInstanceId());
        ExternalTaskQueryTest.assertEquals((String)"externalTask", (String)externalTask.getActivityId());
        ExternalTaskQueryTest.assertNotNull((Object)externalTask.getActivityInstanceId());
        ExternalTaskQueryTest.assertNotNull((Object)externalTask.getExecutionId());
        ExternalTaskQueryTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)externalTask.getProcessDefinitionId());
        ExternalTaskQueryTest.assertEquals((String)"oneExternalTaskProcess", (String)externalTask.getProcessDefinitionKey());
        ExternalTaskQueryTest.assertEquals((String)TOPIC_NAME, (String)externalTask.getTopicName());
        ExternalTaskQueryTest.assertNull((Object)externalTask.getWorkerId());
        ExternalTaskQueryTest.assertNull((Object)externalTask.getLockExpirationTime());
        ExternalTaskQueryTest.assertFalse((boolean)externalTask.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testList() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        ExternalTaskQueryTest.assertEquals((int)5, (int)this.externalTaskService.createExternalTaskQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCount() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        ExternalTaskQueryTest.assertEquals((long)5L, (long)this.externalTaskService.createExternalTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryByLockState() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        this.lockInstances(TOPIC_NAME, 10000L, 3, WORKER_ID);
        List lockedTasks = this.externalTaskService.createExternalTaskQuery().locked().list();
        List nonLockedTasks = this.externalTaskService.createExternalTaskQuery().notLocked().list();
        ExternalTaskQueryTest.assertEquals((int)3, (int)lockedTasks.size());
        for (ExternalTask task : lockedTasks) {
            ExternalTaskQueryTest.assertNotNull((Object)task.getLockExpirationTime());
        }
        ExternalTaskQueryTest.assertEquals((int)2, (int)nonLockedTasks.size());
        for (ExternalTask task : nonLockedTasks) {
            ExternalTaskQueryTest.assertNull((Object)task.getLockExpirationTime());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryByProcessDefinitionId() {
        org.camunda.bpm.engine.repository.Deployment secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml").deploy();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.startInstancesById(((ProcessDefinition)processDefinitions.get(0)).getId(), 3);
        this.startInstancesById(((ProcessDefinition)processDefinitions.get(1)).getId(), 2);
        List definition1Tasks = this.externalTaskService.createExternalTaskQuery().processDefinitionId(((ProcessDefinition)processDefinitions.get(0)).getId()).list();
        List definition2Tasks = this.externalTaskService.createExternalTaskQuery().processDefinitionId(((ProcessDefinition)processDefinitions.get(1)).getId()).list();
        ExternalTaskQueryTest.assertEquals((int)3, (int)definition1Tasks.size());
        for (ExternalTask task : definition1Tasks) {
            ExternalTaskQueryTest.assertEquals((String)((ProcessDefinition)processDefinitions.get(0)).getId(), (String)task.getProcessDefinitionId());
        }
        ExternalTaskQueryTest.assertEquals((int)2, (int)definition2Tasks.size());
        for (ExternalTask task : definition2Tasks) {
            ExternalTaskQueryTest.assertEquals((String)((ProcessDefinition)processDefinitions.get(1)).getId(), (String)task.getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(secondDeployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testQueryByActivityId() {
        this.startInstancesByKey("parallelExternalTaskProcess", 3);
        List tasks = this.externalTaskService.createExternalTaskQuery().activityId("externalTask2").list();
        ExternalTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskQueryTest.assertEquals((String)"externalTask2", (String)task.getActivityId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testQueryByTopicName() {
        this.startInstancesByKey("parallelExternalTaskProcess", 3);
        List topic1Tasks = this.externalTaskService.createExternalTaskQuery().topicName("topic1").list();
        ExternalTaskQueryTest.assertEquals((int)3, (int)topic1Tasks.size());
        for (ExternalTask task : topic1Tasks) {
            ExternalTaskQueryTest.assertEquals((String)"topic1", (String)task.getTopicName());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceId() {
        List<ProcessInstance> processInstances = this.startInstancesByKey("oneExternalTaskProcess", 3);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstances.get(0).getId()).singleResult();
        ExternalTaskQueryTest.assertNotNull((Object)task);
        ExternalTaskQueryTest.assertEquals((String)processInstances.get(0).getId(), (String)task.getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionId() {
        List<ProcessInstance> processInstances = this.startInstancesByKey("oneExternalTaskProcess", 3);
        ProcessInstance firstInstance = processInstances.get(0);
        ActivityInstance externalTaskActivityInstance = this.runtimeService.getActivityInstance(firstInstance.getId()).getActivityInstances("externalTask")[0];
        String executionId = externalTaskActivityInstance.getExecutionIds()[0];
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().executionId(executionId).singleResult();
        ExternalTaskQueryTest.assertNotNull((Object)externalTask);
        ExternalTaskQueryTest.assertEquals((String)executionId, (String)externalTask.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryByWorkerId() {
        this.startInstancesByKey("oneExternalTaskProcess", 10);
        this.lockInstances(TOPIC_NAME, 10000L, 3, "worker1");
        this.lockInstances(TOPIC_NAME, 10000L, 4, "worker2");
        List tasks = this.externalTaskService.createExternalTaskQuery().workerId("worker1").list();
        ExternalTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskQueryTest.assertEquals((String)"worker1", (String)task.getWorkerId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryByLockExpirationTime() {
        this.startInstancesByKey("oneExternalTaskProcess", 10);
        this.lockInstances(TOPIC_NAME, 5000L, 3, WORKER_ID);
        this.lockInstances(TOPIC_NAME, 10000L, 4, WORKER_ID);
        Date lockDate = new Date(ClockUtil.getCurrentTime().getTime() + 7000L);
        List lockedExpirationBeforeTasks = this.externalTaskService.createExternalTaskQuery().lockExpirationBefore(lockDate).list();
        List lockedExpirationAfterTasks = this.externalTaskService.createExternalTaskQuery().lockExpirationAfter(lockDate).list();
        ExternalTaskQueryTest.assertEquals((int)3, (int)lockedExpirationBeforeTasks.size());
        for (ExternalTask task : lockedExpirationBeforeTasks) {
            ExternalTaskQueryTest.assertNotNull((Object)task.getLockExpirationTime());
            ExternalTaskQueryTest.assertTrue((task.getLockExpirationTime().getTime() < lockDate.getTime() ? 1 : 0) != 0);
        }
        ExternalTaskQueryTest.assertEquals((int)4, (int)lockedExpirationAfterTasks.size());
        for (ExternalTask task : lockedExpirationAfterTasks) {
            ExternalTaskQueryTest.assertNotNull((Object)task.getLockExpirationTime());
            ExternalTaskQueryTest.assertTrue((task.getLockExpirationTime().getTime() > lockDate.getTime() ? 1 : 0) != 0);
        }
    }

    public void testQueryWithNullValues() {
        try {
            this.externalTaskService.createExternalTaskQuery().externalTaskId(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("externalTaskId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().activityId(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("activityId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().executionId(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("executionId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().lockExpirationAfter(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("lockExpirationAfter is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().lockExpirationBefore(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("lockExpirationBefore is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processDefinitionId(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("processDefinitionId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processInstanceId(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("processInstanceId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().topicName(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("topicName is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().workerId(null).list();
            ExternalTaskQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testQuerySorting() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        this.startInstancesByKey("twoExternalTaskProcess", 5);
        this.lockInstances(TOPIC_NAME, 5000L, 5, WORKER_ID);
        this.lockInstances(TOPIC_NAME, 10000L, 5, WORKER_ID);
        List tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderById().asc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskById());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessInstanceId().asc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskByProcessInstanceId());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessDefinitionId().asc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskByProcessDefinitionId());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessDefinitionKey().asc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskByProcessDefinitionKey());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByLockExpirationTime().asc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskByLockExpirationTime());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderById().desc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskById()));
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessInstanceId().desc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByProcessInstanceId()));
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessDefinitionId().desc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByProcessDefinitionId()));
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessDefinitionKey().desc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByProcessDefinitionKey()));
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByLockExpirationTime().desc()).list();
        ExternalTaskQueryTest.assertEquals((int)10, (int)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByLockExpirationTime()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryBySuspensionState() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        this.suspendInstances(3);
        List suspendedTasks = this.externalTaskService.createExternalTaskQuery().suspended().list();
        List activeTasks = this.externalTaskService.createExternalTaskQuery().active().list();
        ExternalTaskQueryTest.assertEquals((int)3, (int)suspendedTasks.size());
        for (ExternalTask task : suspendedTasks) {
            ExternalTaskQueryTest.assertTrue((boolean)task.isSuspended());
        }
        ExternalTaskQueryTest.assertEquals((int)2, (int)activeTasks.size());
        for (ExternalTask task : activeTasks) {
            ExternalTaskQueryTest.assertFalse((boolean)task.isSuspended());
            ExternalTaskQueryTest.assertFalse((boolean)suspendedTasks.contains(task));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryByRetries() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        List<LockedExternalTask> tasks = this.lockInstances(TOPIC_NAME, 10000L, 3, WORKER_ID);
        this.failInstances(tasks.subList(0, 2), "error", 0, 5000L);
        this.failInstances(tasks.subList(2, 3), "error", 4, 5000L);
        List tasksWithRetries = this.externalTaskService.createExternalTaskQuery().withRetriesLeft().list();
        List tasksWithoutRetries = this.externalTaskService.createExternalTaskQuery().noRetriesLeft().list();
        ExternalTaskQueryTest.assertEquals((int)3, (int)tasksWithRetries.size());
        for (ExternalTask task : tasksWithRetries) {
            ExternalTaskQueryTest.assertTrue((task.getRetries() == null || task.getRetries() > 0 ? 1 : 0) != 0);
        }
        ExternalTaskQueryTest.assertEquals((int)2, (int)tasksWithoutRetries.size());
        for (ExternalTask task : tasksWithoutRetries) {
            ExternalTaskQueryTest.assertTrue((task.getRetries() == 0 ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testQueryById() {
        List<ProcessInstance> processInstances = this.startInstancesByKey("oneExternalTaskProcess", 2);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        ProcessInstance firstInstance = processInstances.get(0);
        ExternalTask firstTask = (ExternalTask)tasks.get(0);
        if (!firstTask.getProcessInstanceId().equals(firstInstance.getId())) {
            firstTask = (ExternalTask)tasks.get(1);
        }
        ExternalTask resultTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().externalTaskId(firstTask.getId()).singleResult();
        ExternalTaskQueryTest.assertEquals((String)firstTask.getId(), (String)resultTask.getId());
    }

    protected List<ProcessInstance> startInstancesByKey(String processDefinitionKey, int number) {
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < number; ++i) {
            processInstances.add(this.runtimeService.startProcessInstanceByKey(processDefinitionKey));
        }
        return processInstances;
    }

    protected List<ProcessInstance> startInstancesById(String processDefinitionId, int number) {
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < number; ++i) {
            processInstances.add(this.runtimeService.startProcessInstanceById(processDefinitionId));
        }
        return processInstances;
    }

    protected void suspendInstances(int number) {
        List processInstances = this.runtimeService.createProcessInstanceQuery().listPage(0, number);
        for (ProcessInstance processInstance : processInstances) {
            this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        }
    }

    protected List<LockedExternalTask> lockInstances(String topic, long duration, int number, String workerId) {
        return this.externalTaskService.fetchAndLock(number, workerId).topic(topic, duration).execute();
    }

    protected void failInstances(List<LockedExternalTask> tasks, String errorMessage, int retries, long retryTimeout) {
        for (LockedExternalTask task : tasks) {
            this.externalTaskService.handleFailure(task.getId(), task.getWorkerId(), errorMessage, retries, retryTimeout);
        }
    }
}

