/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.FormFieldValidationConstraint;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.form.type.EnumFormType;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidationException;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidatorException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class FormDataTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testGetFormFieldBasicProperties() {
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testGetFormFieldBasicProperties");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        List formFields = taskFormData.getFormFields();
        FormField formField1 = (FormField)formFields.get(0);
        FormDataTest.assertNotNull((Object)formField1);
        FormDataTest.assertEquals((String)formField1.getId(), (String)"formField1");
        FormDataTest.assertEquals((String)formField1.getLabel(), (String)"Form Field 1");
        FormDataTest.assertEquals((String)"string", (String)formField1.getTypeName());
        FormDataTest.assertNotNull((Object)formField1.getType());
        FormField formField2 = (FormField)formFields.get(1);
        FormDataTest.assertNotNull((Object)formField2);
        FormDataTest.assertEquals((String)formField2.getId(), (String)"formField2");
        FormDataTest.assertEquals((String)formField2.getLabel(), (String)"Form Field 2");
        FormDataTest.assertEquals((String)"boolean", (String)formField2.getTypeName());
        FormDataTest.assertNotNull((Object)formField1.getType());
    }

    @Deployment
    public void testGetFormFieldBuiltInTypes() {
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testGetFormFieldBuiltInTypes");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        List formFields = taskFormData.getFormFields();
        FormField stringField = (FormField)formFields.get(0);
        FormDataTest.assertNotNull((Object)stringField);
        FormDataTest.assertEquals((String)"string", (String)stringField.getTypeName());
        FormDataTest.assertNotNull((Object)stringField.getType());
        FormDataTest.assertEquals((Object)"someString", (Object)stringField.getDefaultValue());
        FormField longField = (FormField)formFields.get(1);
        FormDataTest.assertNotNull((Object)longField);
        FormDataTest.assertEquals((String)"long", (String)longField.getTypeName());
        FormDataTest.assertNotNull((Object)longField.getType());
        FormDataTest.assertEquals((Object)1L, (Object)longField.getDefaultValue());
        FormField booleanField = (FormField)formFields.get(2);
        FormDataTest.assertNotNull((Object)booleanField);
        FormDataTest.assertEquals((String)"boolean", (String)booleanField.getTypeName());
        FormDataTest.assertNotNull((Object)booleanField.getType());
        FormDataTest.assertEquals((Object)true, (Object)booleanField.getDefaultValue());
        FormField dateField = (FormField)formFields.get(3);
        FormDataTest.assertNotNull((Object)dateField);
        FormDataTest.assertEquals((String)"date", (String)dateField.getTypeName());
        FormDataTest.assertNotNull((Object)dateField.getType());
        Date dateValue = (Date)dateField.getDefaultValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateValue);
        FormDataTest.assertEquals((int)10, (int)calendar.get(5));
        FormDataTest.assertEquals((int)0, (int)calendar.get(2));
        FormDataTest.assertEquals((int)2013, (int)calendar.get(1));
        FormField enumField = (FormField)formFields.get(4);
        FormDataTest.assertNotNull((Object)enumField);
        FormDataTest.assertEquals((String)"enum", (String)enumField.getTypeName());
        FormDataTest.assertNotNull((Object)enumField.getType());
        EnumFormType enumFormType = (EnumFormType)enumField.getType();
        Map values = enumFormType.getValues();
        FormDataTest.assertEquals((String)"A", (String)((String)values.get("a")));
        FormDataTest.assertEquals((String)"B", (String)((String)values.get("b")));
        FormDataTest.assertEquals((String)"C", (String)((String)values.get("c")));
    }

    @Deployment
    public void testGetFormFieldProperties() {
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testGetFormFieldProperties");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        List formFields = taskFormData.getFormFields();
        FormField stringField = (FormField)formFields.get(0);
        Map properties = stringField.getProperties();
        FormDataTest.assertEquals((String)"property1", (String)((String)properties.get("p1")));
        FormDataTest.assertEquals((String)"property2", (String)((String)properties.get("p2")));
    }

    @Deployment
    public void testGetFormFieldValidationConstraints() {
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testGetFormFieldValidationConstraints");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        List formFields = taskFormData.getFormFields();
        FormField field1 = (FormField)formFields.get(0);
        List validationConstraints = field1.getValidationConstraints();
        FormFieldValidationConstraint constraint1 = (FormFieldValidationConstraint)validationConstraints.get(0);
        FormDataTest.assertEquals((String)"maxlength", (String)constraint1.getName());
        FormDataTest.assertEquals((Object)"10", (Object)constraint1.getConfiguration());
        FormFieldValidationConstraint constraint2 = (FormFieldValidationConstraint)validationConstraints.get(1);
        FormDataTest.assertEquals((String)"minlength", (String)constraint2.getName());
        FormDataTest.assertEquals((Object)"5", (Object)constraint2.getConfiguration());
    }

    @Deployment
    public void testFormFieldSubmit() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("FormDataTest.testFormFieldSubmit");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, Object> formValues = new HashMap<String, Object>();
        formValues.put("stringField", "12345");
        formValues.put("longField", 9L);
        formValues.put("customField", "validValue");
        this.formService.submitTaskForm(task.getId(), formValues);
        FormDataTest.assertEquals(formValues, (Object)this.runtimeService.getVariables(processInstance.getId()));
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test complete");
        this.runtimeService.startProcessInstanceByKey("FormDataTest.testFormFieldSubmit");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        formValues = new HashMap();
        formValues.put("stringField", "1234");
        formValues.put("longField", 9L);
        formValues.put("customField", "validValue");
        try {
            this.formService.submitTaskForm(task.getId(), formValues);
            FormDataTest.fail();
        }
        catch (FormFieldValidatorException e) {
            FormDataTest.assertEquals((String)e.getName(), (String)"minlength");
        }
        formValues = new HashMap();
        formValues.put("customFieldWithValidationDetails", "C");
        try {
            this.formService.submitTaskForm(task.getId(), formValues);
            FormDataTest.fail();
        }
        catch (FormFieldValidatorException e) {
            FormDataTest.assertEquals((String)e.getName(), (String)"validator");
            FormDataTest.assertEquals((String)e.getId(), (String)"customFieldWithValidationDetails");
            FormDataTest.assertTrue((boolean)(e.getCause() instanceof FormFieldValidationException));
            FormFieldValidationException exception = (FormFieldValidationException)e.getCause();
            FormDataTest.assertEquals((Object)exception.getDetail(), (Object)"EXPIRED");
        }
    }

    @Deployment
    public void failTestDateFormProperty() {
        HashMap variables = new HashMap(1);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("date-form-property-test", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.formService.getTaskFormData(task.getId());
    }
}

