/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn;

import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.test.api.multitenancy.listener.AssertingCaseExecutionListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyDelegateCaseExecutionTest
extends PluggableProcessEngineTestCase {
    protected static final String HUMAN_TASK_CMMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/HumanTaskCaseExecutionListener.cmmn";
    protected static final String CASE_TASK_CMMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/CaseTaskCaseExecutionListener.cmmn";
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn";
    protected static final String TENANT_ID = "tenant1";

    public void testSingleExecution() {
        this.deploymentForTenant(TENANT_ID, new String[]{HUMAN_TASK_CMMN_FILE});
        AssertingCaseExecutionListener.addAsserts(MultiTenancyDelegateCaseExecutionTest.hasTenantId(TENANT_ID));
        this.startCaseInstance("case");
    }

    public void testCallCaseTask() {
        this.deploymentForTenant(TENANT_ID, new String[]{CMMN_FILE});
        this.deployment(new String[]{CASE_TASK_CMMN_FILE});
        AssertingCaseExecutionListener.addAsserts(MultiTenancyDelegateCaseExecutionTest.hasTenantId(TENANT_ID));
        this.startCaseInstance("oneCaseTaskCase");
    }

    protected void startCaseInstance(String caseDefinitionKey) {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(caseDefinitionKey).latestVersion().singleResult();
        this.caseService.createCaseInstanceById(caseDefinition.getId());
    }

    protected void tearDown() throws Exception {
        AssertingCaseExecutionListener.clear();
        super.tearDown();
    }

    protected static AssertingCaseExecutionListener.DelegateCaseExecutionAsserter hasTenantId(final String expectedTenantId) {
        return new AssertingCaseExecutionListener.DelegateCaseExecutionAsserter(){

            @Override
            public void doAssert(DelegateCaseExecution execution) {
                Assert.assertThat((Object)execution.getTenantId(), (Matcher)CoreMatchers.is((Object)expectedTenantId));
            }
        };
    }
}

