/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyCaseDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String CASE_DEFINITION_KEY = "Case_1";
    protected static final String CMMN = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deployment(new String[]{CMMN});
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN});
    }

    public void testQueryNoTenantIdSet() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testQueryByTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByDefinitionsWithoutTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeCaseDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeCaseDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeCaseDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testQueryByKey() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByLatestNoTenantIdSet() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, CaseDefinition> caseDefinitionsForTenant = this.getCaseDefinitionsForTenant(query.list());
        Assert.assertThat((Object)caseDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)caseDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)caseDefinitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        Assert.assertThat((Object)caseDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)caseDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        caseDefinition = (CaseDefinition)query.singleResult();
        Assert.assertThat((Object)caseDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)caseDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithTenantIds() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Map<String, CaseDefinition> caseDefinitionsForTenant = this.getCaseDefinitionsForTenant(query.list());
        Assert.assertThat((Object)caseDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)caseDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testQueryByLatestWithoutTenantId() {
        this.deployment(new String[]{CMMN});
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        CaseDefinition cDefinition = (CaseDefinition)query.singleResult();
        Assert.assertThat((Object)cDefinition.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)cDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    public void testQueryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.deployment(new String[]{CMMN});
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN});
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeCaseDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, CaseDefinition> caseDefinitionsForTenant = this.getCaseDefinitionsForTenant(query.list());
        Assert.assertThat((Object)caseDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)caseDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)caseDefinitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    public void testQueryByNonExistingTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{null});
            MultiTenancyCaseDefinitionQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List caseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)caseDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List caseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)caseDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((CaseDefinition)caseDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeCaseDefinitionsWithoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected Map<String, CaseDefinition> getCaseDefinitionsForTenant(List<CaseDefinition> definitions) {
        HashMap<String, CaseDefinition> definitionsForTenant = new HashMap<String, CaseDefinition>();
        for (CaseDefinition definition : definitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }
}

