/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricIdentityLinkLogQueryTest {
    private static final String GROUP_1 = "Group1";
    private static final String USER_1 = "User1";
    private static String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected static final String A_USER_ID = "aUserId";
    protected static final String TENANT_1 = "tenant1";
    protected static final String TENANT_2 = "tenant2";
    protected static final String TENANT_3 = "tenant3";

    @Before
    public void init() {
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        BpmnModelInstance oneTaskProcess = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("task").camundaCandidateUsers(A_USER_ID)).endEvent().done();
        this.testRule.deployForTenant(TENANT_1, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_2, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_3, oneTaskProcess);
    }

    @Test
    public void addandDeleteHistoricIdentityLinkForSingleTenant() {
        this.startProcessInstanceForTenant(TENANT_1);
        HistoricIdentityLinkLog historicIdentityLink = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        this.taskService.deleteCandidateUser(historicIdentityLink.getTaskId(), A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.tenantIdIn(new String[]{TENANT_1}).count(), (long)2L);
    }

    @Test
    public void historicIdentityLinkForMultipleTenant() {
        this.startProcessInstanceForTenant(TENANT_1);
        HistoricIdentityLinkLog historicIdentityLink = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assert.assertEquals((Object)historicIdentityLink.getTenantId(), (Object)TENANT_1);
        this.startProcessInstanceForTenant(TENANT_2);
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)2L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.tenantIdIn(new String[]{TENANT_1}).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.tenantIdIn(new String[]{TENANT_2}).count(), (long)1L);
    }

    @Test
    public void addAndRemoveHistoricIdentityLinksForProcessDefinitionWithTenantId() throws Exception {
        String resourceName = "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml";
        this.testRule.deployForTenant(TENANT_1, resourceName);
        this.testRule.deployForTenant(TENANT_2, resourceName);
        ProcessDefinition processDefinition1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list().get(0);
        ProcessDefinition processDefinition2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list().get(1);
        Assert.assertNotNull((Object)processDefinition1);
        Assert.assertNotNull((Object)processDefinition2);
        this.testTenantsByProcessDefinition(processDefinition1.getId());
        this.testTenantsByProcessDefinition(processDefinition2.getId());
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)8L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.tenantIdIn(new String[]{TENANT_1}).count(), (long)4L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.tenantIdIn(new String[]{TENANT_2}).count(), (long)4L);
    }

    public void testTenantsByProcessDefinition(String processDefinitionId) {
        this.repositoryService.addCandidateStarterGroup(processDefinitionId, GROUP_1);
        this.repositoryService.addCandidateStarterUser(processDefinitionId, USER_1);
        this.repositoryService.deleteCandidateStarterGroup(processDefinitionId, GROUP_1);
        this.repositoryService.deleteCandidateStarterUser(processDefinitionId, USER_1);
    }

    @Test
    public void identityLinksForProcessDefinitionWithTenantId() throws Exception {
        String resourceName = "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml";
        this.testRule.deployForTenant(TENANT_1, resourceName);
        this.testRule.deployForTenant(TENANT_2, resourceName);
        ProcessDefinition processDefinition1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list().get(0);
        Assert.assertNotNull((Object)processDefinition1);
        this.repositoryService.addCandidateStarterGroup(processDefinition1.getId(), GROUP_1);
        this.repositoryService.addCandidateStarterUser(processDefinition1.getId(), USER_1);
        ProcessDefinition processDefinition2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list().get(1);
        Assert.assertNotNull((Object)processDefinition2);
        this.repositoryService.addCandidateStarterGroup(processDefinition2.getId(), GROUP_1);
        this.repositoryService.addCandidateStarterUser(processDefinition2.getId(), USER_1);
        List identityLinks = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition1.getId());
        Assert.assertEquals((long)identityLinks.size(), (long)2L);
        Assert.assertEquals((Object)((IdentityLink)identityLinks.get(0)).getTenantId(), (Object)TENANT_1);
        Assert.assertEquals((Object)((IdentityLink)identityLinks.get(1)).getTenantId(), (Object)TENANT_1);
        identityLinks = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition2.getId());
        Assert.assertEquals((long)identityLinks.size(), (long)2L);
        Assert.assertEquals((Object)((IdentityLink)identityLinks.get(0)).getTenantId(), (Object)TENANT_2);
        Assert.assertEquals((Object)((IdentityLink)identityLinks.get(1)).getTenantId(), (Object)TENANT_2);
    }

    @Test
    public void singleQueryForMultipleTenant() {
        this.startProcessInstanceForTenant(TENANT_1);
        this.startProcessInstanceForTenant(TENANT_2);
        this.startProcessInstanceForTenant(TENANT_3);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.tenantIdIn(new String[]{TENANT_1, TENANT_2}).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.tenantIdIn(new String[]{TENANT_2, TENANT_3}).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.tenantIdIn(new String[]{TENANT_1, TENANT_2, TENANT_3}).count(), (long)3L);
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant) {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(tenant).execute();
    }
}

