/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMessageEventReceivedCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance MESSAGE_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"messageCatch").startEvent().intermediateCatchEvent().message("message")).userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").execute();
        Execution execution = (Execution)this.engineRule.getRuntimeService().createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").singleResult();
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRuntimeService().messageEventReceived("message", execution.getId());
        this.engineRule.getIdentityService().clearAuthentication();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").execute();
        Execution execution = (Execution)this.engineRule.getRuntimeService().createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").singleResult();
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRuntimeService().messageEventReceived("message", execution.getId());
        this.engineRule.getIdentityService().clearAuthentication();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        Execution execution = (Execution)this.engineRule.getRuntimeService().createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.engineRule.getRuntimeService().messageEventReceived("message", execution.getId());
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failToCorrelateReceivedMessageToIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        Execution execution = (Execution)this.engineRule.getRuntimeService().createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance");
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRuntimeService().messageEventReceived("message", execution.getId());
    }
}

