/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository.diagram;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.bpmn.diagram.ProcessDiagramLayoutFactory;
import org.camunda.bpm.engine.repository.DiagramLayout;
import org.camunda.bpm.engine.repository.DiagramNode;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProcessDiagramRetrievalTest {
    private static final boolean OVERWRITE_EXPECTED_HTML_FILES = false;
    @Rule
    public ProcessEngineRule activitiRule = new ProvidedProcessEngineRule();
    private final String xmlFileName;
    private final String imageFileName;
    private final String highlightedActivityId;
    private RepositoryService repositoryService;
    private String deploymentId;
    private ProcessDefinitionQuery processDefinitionQuery;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"testStartEventWithNegativeCoordinates", ".bpmn", ".png", "sid-61D1FC47-8031-4834-A9B4-84158E73F7B9"}, {"testStartAndEndEventWithNegativeCoordinates", ".bpmn", ".png", "sid-61D1FC47-8031-4834-A9B4-84158E73F7B9"}, {"testProcessWithTask", ".bpmn", ".png", "sid-1E142B16-AFAF-429E-A441-D1232CFBD560"}, {"testProcessFromCamundaFoxDesigner", ".bpmn", ".png", "UserTask_1"}, {"testProcessFromCamundaFoxDesigner", ".bpmn", ".jpg", "UserTask_1"}, {"testProcessFromActivitiDesigner", ".bpmn20.xml", ".png", "Send_rejection_notification_via_email__3"}, {"testSequenceFlowOutOfBounds", ".bpmn", ".png", "sid-61D1FC47-8031-4834-A9B4-84158E73F7B9"}, {"testProcessFromAdonis", ".bpmn", ".png", "_16615"}, {"testProcessFromIboPrometheus", ".bpmn", ".png", "ibo-5784efbe-35ac-44bc-bcbe-4c18a2f23d5d"}, {"testProcessFromIboPrometheus", ".bpmn", ".jpg", "ibo-5784efbe-35ac-44bc-bcbe-4c18a2f23d5d"}, {"testInvoiceProcessCamundaFoxDesigner", ".bpmn20.xml", ".jpg", "Rechnung_freigeben_125"}, {"testInvoiceProcessSignavio", ".bpmn", ".png", "Freigebenden_zuordnen_143"}, {"testInvoiceProcessFromBusinessProcessIncubator", ".bpmn", ".png", "Rechnung_kl_ren_148"}, {"testProcessFromYaoqiang", ".bpmn", ".png", "_3"});
    }

    public ProcessDiagramRetrievalTest(String modelName, String xmlFileExtension, String imageFileExtension, String highlightedActivityId) {
        this.xmlFileName = modelName + xmlFileExtension;
        this.imageFileName = modelName + imageFileExtension;
        this.highlightedActivityId = highlightedActivityId;
    }

    @Before
    public void setup() {
        this.repositoryService = this.activitiRule.getRepositoryService();
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/diagram/" + this.xmlFileName).addClasspathResource("org/camunda/bpm/engine/test/api/repository/diagram/" + this.imageFileName).deploy().getId();
        this.processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
    }

    @After
    public void teardown() {
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    @Test
    public void testGetProcessModel() throws Exception {
        if (1L == this.processDefinitionQuery.count()) {
            ProcessDefinition processDefinition = (ProcessDefinition)this.processDefinitionQuery.singleResult();
            FileInputStream expectedStream = new FileInputStream("src/test/resources/org/camunda/bpm/engine/test/api/repository/diagram/" + this.xmlFileName);
            InputStream actualStream = this.repositoryService.getProcessModel(processDefinition.getId());
            Assert.assertTrue((boolean)ProcessDiagramRetrievalTest.isEqual(expectedStream, actualStream));
        }
    }

    @Test
    public void testGetProcessDiagram() throws Exception {
        if (1L == this.processDefinitionQuery.count()) {
            ProcessDefinition processDefinition = (ProcessDefinition)this.processDefinitionQuery.singleResult();
            FileInputStream expectedStream = new FileInputStream("src/test/resources/org/camunda/bpm/engine/test/api/repository/diagram/" + this.imageFileName);
            InputStream actualStream = this.repositoryService.getProcessDiagram(processDefinition.getId());
            Assert.assertTrue((boolean)ProcessDiagramRetrievalTest.isEqual(expectedStream, actualStream));
        }
    }

    @Test
    public void testGetProcessDiagramLayout() throws Exception {
        DiagramLayout processDiagramLayout;
        if (1L == this.processDefinitionQuery.count()) {
            ProcessDefinition processDefinition = (ProcessDefinition)this.processDefinitionQuery.singleResult();
            Assert.assertNotNull((Object)processDefinition);
            processDiagramLayout = this.repositoryService.getProcessDiagramLayout(processDefinition.getId());
        } else {
            FileInputStream bpmnXmlStream = new FileInputStream("src/test/resources/org/camunda/bpm/engine/test/api/repository/diagram/" + this.xmlFileName);
            FileInputStream imageStream = new FileInputStream("src/test/resources/org/camunda/bpm/engine/test/api/repository/diagram/" + this.imageFileName);
            Assert.assertNotNull((Object)bpmnXmlStream);
            Assert.assertNotNull((Object)imageStream);
            processDiagramLayout = new ProcessDiagramLayoutFactory().getProcessDiagramLayout((InputStream)bpmnXmlStream, (InputStream)imageStream);
        }
        this.assertLayoutCorrect(processDiagramLayout);
    }

    private void assertLayoutCorrect(DiagramLayout processDiagramLayout) throws IOException {
        String html = ProcessDiagramRetrievalTest.generateHtmlCode(this.imageFileName, processDiagramLayout, this.highlightedActivityId);
        File htmlFile = new File("src/test/resources/org/camunda/bpm/engine/test/api/repository/diagram/" + this.imageFileName + ".html");
        Assert.assertEquals((Object)FileUtils.readFileToString((File)htmlFile).replace("\r", ""), (Object)html);
    }

    private static String generateHtmlCode(String imageUrl, DiagramLayout processDiagramLayout, String highlightedActivityId) {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>\n");
        html.append("  <head>\n");
        html.append("    <style type=\"text/css\"><!--\n");
        html.append("      .BPMNElement {\n");
        html.append("        position: absolute;\n");
        html.append("        border: 2px dashed lightBlue;\n");
        html.append("        border-radius: 5px; -moz-border-radius: 5px;\n");
        html.append("      }\n");
        if (highlightedActivityId != null && highlightedActivityId.length() > 0) {
            html.append("      #" + highlightedActivityId + " {border: 2px solid red;}\n");
        }
        html.append("    --></style>");
        html.append("  </head>\n");
        html.append("  <body>\n");
        html.append("    <div style=\"position: relative\">\n");
        html.append("      <img src=\"" + imageUrl + "\" />\n");
        ArrayList nodes = new ArrayList(processDiagramLayout.getNodes());
        Collections.sort(nodes, new DiagramNodeComparator());
        for (DiagramNode node : nodes) {
            html.append("      <div");
            html.append(" class=\"BPMNElement\"");
            html.append(" id=\"" + node.getId() + "\"");
            html.append(" style=\"");
            html.append(" left: " + (int)(node.getX() - 2.0) + "px;");
            html.append(" top: " + (int)(node.getY() - 2.0) + "px;");
            html.append(" width: " + node.getWidth().intValue() + "px;");
            html.append(" height: " + node.getHeight().intValue() + "px;\"></div>\n");
        }
        html.append("    </div>\n");
        html.append("  </body>\n");
        html.append("</html>");
        return html.toString();
    }

    private static boolean isEqual(InputStream stream1, InputStream stream2) throws IOException {
        ReadableByteChannel channel1 = Channels.newChannel(stream1);
        ReadableByteChannel channel2 = Channels.newChannel(stream2);
        ByteBuffer buffer1 = ByteBuffer.allocateDirect(1024);
        ByteBuffer buffer2 = ByteBuffer.allocateDirect(1024);
        try {
            while (true) {
                int bytesReadFromStream1 = channel1.read(buffer1);
                int bytesReadFromStream2 = channel2.read(buffer2);
                if (bytesReadFromStream1 == -1 || bytesReadFromStream2 == -1) {
                    boolean bl = bytesReadFromStream1 == bytesReadFromStream2;
                    return bl;
                }
                buffer1.flip();
                buffer2.flip();
                for (int i = 0; i < Math.min(bytesReadFromStream1, bytesReadFromStream2); ++i) {
                    if (buffer1.get() == buffer2.get()) continue;
                    boolean bl = false;
                    return bl;
                }
                buffer1.compact();
                buffer2.compact();
            }
        }
        finally {
            if (stream1 != null) {
                stream1.close();
            }
            if (stream2 != null) {
                stream2.close();
            }
        }
    }

    private static void writeToFile(InputStream is, File file) throws Exception {
        int c;
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        while ((c = is.read()) != -1) {
            out.writeByte(c);
        }
        is.close();
        out.close();
    }

    public static class DiagramNodeComparator
    implements Comparator<DiagramNode> {
        @Override
        public int compare(DiagramNode o1, DiagramNode o2) {
            if (o1.getId() == null) {
                return 0;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

