/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricFormField;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;

public class AsyncStartEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testAsyncStartEvent() {
        this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((String)"The user task should not have been reached yet", (Object)task);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        this.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        Assert.assertNotNull((String)"The user task should have been reached", (Object)task);
    }

    @Deployment
    public void testAsyncStartEventListeners() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Assert.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
        this.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventHistory() {
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
            HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
            Assert.assertNotNull((Object)historicInstance);
            Assert.assertNotNull((Object)historicInstance.getStartTime());
            HistoricActivityInstance historicStartEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().singleResult();
            Assert.assertNull((Object)historicStartEvent);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventVariableHistory() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("asyncStartEvent", variables).getId();
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)variableFoo);
        AsyncStartEventTest.assertEquals((String)"foo", (String)variableFoo.getName());
        AsyncStartEventTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            AsyncStartEventTest.assertNotNull((Object)variable);
            AsyncStartEventTest.assertEquals((String)"foo", (String)variable.getName());
            AsyncStartEventTest.assertEquals((Object)"bar", (Object)variable.getValue());
            AsyncStartEventTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                String startEventId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                AsyncStartEventTest.assertEquals((String)startEventId, (String)historicDetail.getActivityInstanceId());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("startEvent").done());
    }

    @Deployment
    public void testMultipleAsyncStartEvents() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        AsyncStartEventTest.assertEquals((String)"taskAfterMessageStartEvent", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testMultipleAsyncStartEvents.bpmn20.xml"})
    public void testMultipleAsyncStartEventsVariableHistory() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)variableFoo);
        AsyncStartEventTest.assertEquals((String)"foo", (String)variableFoo.getName());
        AsyncStartEventTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getId();
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            AsyncStartEventTest.assertNotNull((Object)variable);
            AsyncStartEventTest.assertEquals((String)"foo", (String)variable.getName());
            AsyncStartEventTest.assertEquals((Object)"bar", (Object)variable.getValue());
            AsyncStartEventTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("messageStartEvent").singleResult()).getId();
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                AsyncStartEventTest.assertEquals((String)theStartActivityInstanceId, (String)historicDetail.getActivityInstanceId());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testCallActivity-super.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testCallActivity-sub.bpmn20.xml"})
    public void testCallActivity() {
        this.runtimeService.startProcessInstanceByKey("super");
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        AsyncStartEventTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        AsyncStartEventTest.assertEquals((String)"theSubStart", (String)((ExecutionEntity)pi).getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testSubmitForm() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("asyncStartEvent").singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("foo", "bar");
        this.formService.submitStartForm(processDefinitionId, properties);
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)variableFoo);
        AsyncStartEventTest.assertEquals((String)"foo", (String)variableFoo.getName());
        AsyncStartEventTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getId();
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            AsyncStartEventTest.assertNotNull((Object)variable);
            AsyncStartEventTest.assertEquals((String)"foo", (String)variable.getName());
            AsyncStartEventTest.assertEquals((Object)"bar", (Object)variable.getValue());
            AsyncStartEventTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
                HistoricFormField historicFormUpdate = (HistoricFormField)this.historyService.createHistoricDetailQuery().formFields().singleResult();
                AsyncStartEventTest.assertNotNull((Object)historicFormUpdate);
                AsyncStartEventTest.assertEquals((Object)"bar", (Object)historicFormUpdate.getFieldValue());
                HistoricVariableUpdate historicVariableUpdate = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().singleResult();
                AsyncStartEventTest.assertNotNull((Object)historicVariableUpdate);
                AsyncStartEventTest.assertEquals((String)theStartActivityInstanceId, (String)historicVariableUpdate.getActivityInstanceId());
                AsyncStartEventTest.assertEquals((Object)"bar", (Object)historicVariableUpdate.getValue());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void FAILING_testSubmitFormHistoricUpdates() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("asyncStartEvent").singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("foo", "bar");
        this.formService.submitStartForm(processDefinitionId, properties);
        this.executeAvailableJobs();
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
            HistoricDetail historicFormUpdate = (HistoricDetail)this.historyService.createHistoricDetailQuery().formFields().singleResult();
            AsyncStartEventTest.assertNotNull((Object)historicFormUpdate);
            AsyncStartEventTest.assertEquals((String)theStartActivityInstanceId, (String)historicFormUpdate.getActivityInstanceId());
        }
    }

    @Deployment
    public void testAsyncSubProcessStartEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNull((String)"The subprocess user task should not have been reached yet", (Object)task);
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("StartEvent_2").count());
        this.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("StartEvent_2").count());
        AsyncStartEventTest.assertNotNull((String)"The subprocess user task should have been reached", (Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncSubProcessStartEvent.bpmn"})
    public void testAsyncSubProcessStartEventActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("SubProcess_1").transition("StartEvent_2").done());
    }

    public void testAsyncStartEventWithChangedVariable() {
        this.deployment(new BpmnModelInstance[]{((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done()});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.putValue((String)"var", (Object)"foo"));
        this.runtimeService.setVariable(processInstance.getId(), "var", (Object)"bar");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstance.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            AsyncStartEventTest.assertEquals((long)query.count(), (long)1L);
            HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
            AsyncStartEventTest.assertEquals((Object)variable.getValue(), (Object)"bar");
            AsyncStartEventTest.assertNotNull((Object)variable.getActivityInstanceId());
        }
    }

    public void testAsyncStartEventWithAddedVariable() {
        this.deployment(new BpmnModelInstance[]{((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done()});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.putValue((String)"var1", (Object)"foo"));
        this.runtimeService.setVariable(processInstance.getId(), "var2", (Object)"bar");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstance.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            AsyncStartEventTest.assertEquals((long)query.count(), (long)2L);
            HistoricVariableInstance firstVariable = (HistoricVariableInstance)query.variableName("var1").singleResult();
            AsyncStartEventTest.assertNotNull((Object)firstVariable);
            AsyncStartEventTest.assertEquals((Object)firstVariable.getValue(), (Object)"foo");
            AsyncStartEventTest.assertNotNull((Object)firstVariable.getActivityInstanceId());
            HistoricVariableInstance secondVariable = (HistoricVariableInstance)query.variableName("var2").singleResult();
            AsyncStartEventTest.assertNotNull((Object)secondVariable);
            AsyncStartEventTest.assertEquals((Object)secondVariable.getValue(), (Object)"bar");
            AsyncStartEventTest.assertNotNull((Object)secondVariable.getActivityInstanceId());
        }
    }
}

