/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.compensate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.compensate.ReadLocalVariableListener;
import org.camunda.bpm.engine.test.bpmn.event.compensate.SetLocalVariableListener;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.BookFlightService;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.CancelFlightService;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.GetVariablesDelegate;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.SetVariablesDelegate;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;

public class CompensateEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCompensateSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateSubprocessInsideSubprocess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("throw compensation");
        this.completeTask("Cancel Hotel");
        this.completeTask("Cancel Flight");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensateParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Task singleResult = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(singleResult.getId());
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateParallelSubprocessCompHandlerWaitstate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        List compensationHandlerTasks = this.taskService.createTaskQuery().taskDefinitionKey("undoBookHotel").list();
        CompensateEventTest.assertEquals((int)5, (int)compensationHandlerTasks.size());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        List compensationHandlerInstances = this.getInstancesForActivityId(rootActivityInstance, "undoBookHotel");
        CompensateEventTest.assertEquals((int)5, (int)compensationHandlerInstances.size());
        for (Task task : compensationHandlerTasks) {
            this.taskService.complete(task.getId());
        }
        Task singleResult = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(singleResult.getId());
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensateParallelSubprocessCompHandlerWaitstate.bpmn20.xml"})
    public void testDeleteParallelSubprocessCompHandlerWaitstate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        List compensationHandlerTasks = this.taskService.createTaskQuery().taskDefinitionKey("undoBookHotel").list();
        CompensateEventTest.assertEquals((int)5, (int)compensationHandlerTasks.size());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateMiSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateActivityRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        CompensateEventTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateSubprocessWithBoundaryEvent() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompensateEventTest.assertNotNull((Object)compensationTask);
        CompensateEventTest.assertEquals((String)"undoSubprocess", (String)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        this.runtimeService.signal(instance.getId());
        this.assertProcessEnded(instance.getId());
    }

    @Deployment
    public void testCompensateActivityInSubprocess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Task scopeTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(scopeTask.getId());
        this.runtimeService.signal(instance.getId());
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompensateEventTest.assertNotNull((Object)compensationTask);
        CompensateEventTest.assertEquals((String)"undoScopeTask", (String)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        this.runtimeService.signal(instance.getId());
        this.assertProcessEnded(instance.getId());
    }

    @Deployment
    public void testCompensateActivityInConcurrentSubprocess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Task scopeTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("scopeTask").singleResult();
        this.taskService.complete(scopeTask.getId());
        Task outerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("outerTask").singleResult();
        this.taskService.complete(outerTask.getId());
        this.runtimeService.signal(instance.getId());
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompensateEventTest.assertNotNull((Object)compensationTask);
        CompensateEventTest.assertEquals((String)"undoScopeTask", (String)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        this.runtimeService.signal(instance.getId());
        this.assertProcessEnded(instance.getId());
    }

    @Deployment
    public void testCompensateConcurrentMiActivity() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTasks("Book Hotel", 4);
        this.completeTaskWithVariable("Request Vacation", "accept", false);
        CompensateEventTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskName("Cancel Hotel").count());
        this.completeTask("Book Hotel");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensateConcurrentMiSubprocess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTasks("Book Hotel", 4);
        this.completeTaskWithVariable("Request Vacation", "accept", false);
        CompensateEventTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskName("Cancel Hotel").count());
        this.completeTask("Book Hotel");
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensateActivityRefMiActivity() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTasks("Book Hotel", 5);
        this.completeTaskWithVariable("Request Vacation", "accept", false);
        CompensateEventTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        this.completeTasks("Cancel Hotel", 5);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensateActivityRefMiSubprocess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTasks("Book Hotel", 5);
        this.completeTaskWithVariable("Request Vacation", "accept", false);
        CompensateEventTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        this.completeTasks("Cancel Hotel", 5);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCallActivityCompensationHandler.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/compensate/CompensationHandler.bpmn20.xml"})
    public void testCallActivityCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
        CompensateEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)6L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        }
    }

    @Deployment
    public void testCompensateMiSubprocessVariableSnapshots() {
        List<String> hotels = Arrays.asList("Rupert", "Vogsphere", "Milliways", "Taunton", "Ysolldins");
        SetVariablesDelegate.setValues(hotels);
        this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        CompensateEventTest.assertTrue((boolean)GetVariablesDelegate.values.containsAll(hotels));
    }

    @Deployment
    public void testCompensateMiSubprocessWithCompensationEventSubprocessVariableSnapshots() {
        List<String> hotels = Arrays.asList("Rupert", "Vogsphere", "Milliways", "Taunton", "Ysolldins");
        SetVariablesDelegate.setValues(hotels);
        this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        CompensateEventTest.assertTrue((boolean)GetVariablesDelegate.values.containsAll(hotels));
    }

    @Deployment
    public void FAILING_testCompensateMiSubprocessVariableSnapshotOfElementVariable() {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        List<String> flights = Arrays.asList("STS-14", "STS-28");
        variables.put("flights", flights);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess", variables);
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)flights.size(), (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
        }
        CompensateEventTest.assertEquals(flights, BookFlightService.bookedFlights);
        CompensateEventTest.assertEquals(flights, CancelFlightService.canceledFlights);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationTriggeredByEventSubProcessActivityRef.bpmn20.xml"})
    public void testCompensateActivityRefTriggeredByEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((String)"undoBookHotel", (String)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationTriggeredByEventSubProcessInSubProcessActivityRef.bpmn20.xml"})
    public void testCompensateActivityRefTriggeredByEventSubprocessInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((String)"undoBookHotel", (String)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationInEventSubProcessActivityRef.bpmn20.xml"})
    public void testCompensateActivityRefInEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookSecondHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((String)"undoBookSecondHotel", (String)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationInEventSubProcess.bpmn20.xml"})
    public void testCompensateInEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookSecondHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((String)"undoBookSecondHotel", (String)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookFlight");
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookHotel");
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
        }
    }

    @Deployment
    public void testExecutionListeners() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("start", 0);
        variables.put("end", 0);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        int started = (Integer)this.runtimeService.getVariable(processInstance.getId(), "start");
        CompensateEventTest.assertEquals((int)5, (int)started);
        int ended = (Integer)this.runtimeService.getVariable(processInstance.getId(), "end");
        CompensateEventTest.assertEquals((int)5, (int)ended);
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            long finishedCount = this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").finished().count();
            CompensateEventTest.assertEquals((long)5L, (long)finishedCount);
        }
    }

    @Deployment
    public void testActivityInstanceTreeWithoutEventScope() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task").done());
    }

    @Deployment
    public void testConcurrentExecutionsAndPendingCompensation() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult()).getId();
        this.taskService.complete(taskId);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().up().child("subProcess").eventScope().scope().up().done());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult()).getId();
        this.taskService.complete(taskId);
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().child("subProcess").eventScope().scope().up().done());
        tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task2").done());
        taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult()).getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensationEndEventWithScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
            CompensateEventTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
        }
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensationEndEventWithActivityRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
        }
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.activityWithCompensationEndEvent.bpmn20.xml"})
    public void testActivityInstanceTreeForCompensationEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("end").activity("undoBookHotel").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.compensationMiActivity.bpmn20.xml"})
    public void testActivityInstanceTreeForMiActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("end").beginMiBody("bookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensateParallelSubprocessCompHandlerWaitstate.bpmn20.xml"})
    public void testActivityInstanceTreeForParallelMiActivityInSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("parallelTask").activity("throwCompensate").beginScope("scope").beginMiBody("bookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.compensationMiSubprocess.bpmn20.xml"})
    public void testActivityInstanceTreeForMiSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.completeTasks("Book Hotel", 5);
        this.completeTask("throwCompensation");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwingCompensation").beginMiBody("scope").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").done());
    }

    @Deployment
    public void FAILING_testActivityInstanceTreeForMiSubProcessDefaultHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.completeTasks("Book Hotel", 5);
        this.completeTask("throwCompensation");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwingCompensation").beginMiBody("scope").beginScope("scope").activity("undoBookHotel").endScope().beginScope("scope").activity("undoBookHotel").endScope().beginScope("scope").activity("undoBookHotel").endScope().beginScope("scope").activity("undoBookHotel").endScope().beginScope("scope").activity("undoBookHotel").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.activityWithCompensationEndEvent.bpmn20.xml"})
    public void testCancelProcessInstanceWithActiveCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationEventSubProcess.bpmn20.xml"})
    public void testCompensationEventSubProcessWithScope() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("bookingProcess").getId();
        this.completeTask("Book Flight");
        this.completeTask("Book Hotel");
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        CompensateEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.completeTask("Cancel Flight");
        CompensateEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.completeTask("Cancel Hotel");
        this.completeTask("Update Customer Record");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensationEventSubProcessWithActivityRef() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("bookingProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        CompensateEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.completeTask("Cancel Hotel");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationEventSubProcess.bpmn20.xml"})
    public void testActivityInstanceTreeForCompensationEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("bookingProcess");
        this.completeTask("Book Flight");
        this.completeTask("Book Hotel");
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwCompensation").beginScope("booking-subprocess").activity("cancelFlight").beginScope("compensationSubProcess").activity("compensateFlight").done());
    }

    @Deployment
    public void testCompensateMiSubprocessWithCompensationEventSubProcess() {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        variables.put("flights", Arrays.asList("STS-14", "STS-28"));
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("bookingProcess", variables).getId();
        this.completeTask("Book Flight");
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("Book Hotel");
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        this.completeTasks("Cancel Flight", 2);
        this.completeTasks("Cancel Hotel", 2);
        this.completeTasks("Update Customer Record", 2);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensateParallelMiSubprocessWithCompensationEventSubProcess() {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        variables.put("flights", Arrays.asList("STS-14", "STS-28"));
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("bookingProcess", variables).getId();
        this.completeTasks("Book Flight", 2);
        this.completeTasks("Book Hotel", 2);
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        this.completeTasks("Cancel Flight", 2);
        this.completeTasks("Cancel Hotel", 2);
        this.completeTasks("Update Customer Record", 2);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensationEventSubprocessWithoutBoundaryEvents() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("throw compensation");
        this.completeTask("Cancel Flight");
        this.completeTask("Cancel Hotel");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensationEventSubprocessReThrowCompensationEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("throw compensation");
        this.completeTask("Cancel Hotel");
        this.completeTask("Cancel Flight");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCompensationEventSubprocessConsumeCompensationEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("throw compensation");
        this.completeTask("Cancel Hotel");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testSubprocessCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandler");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        Task subProcessTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompensateEventTest.assertNotNull((Object)subProcessTask);
        CompensateEventTest.assertEquals((String)"subProcessTask", (String)subProcessTask.getTaskDefinitionKey());
        this.taskService.complete(subProcessTask.getId());
        Task afterCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompensateEventTest.assertNotNull((Object)afterCompensationTask);
        CompensateEventTest.assertEquals((String)"beforeEnd", (String)afterCompensationTask.getTaskDefinitionKey());
        this.taskService.complete(afterCompensationTask.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testSubprocessCompensationHandler.bpmn20.xml"})
    public void testSubprocessCompensationHandlerActivityInstanceTree() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandler");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwCompensate").beginScope("compensationHandler").activity("subProcessTask").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testSubprocessCompensationHandler.bpmn20.xml"})
    public void testSubprocessCompensationHandlerDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandler");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void FAILING_testSubprocessCompensationHandlerWithEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandlerWithEventSubprocess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        this.runtimeService.correlateMessage("Message");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CompensateEventTest.assertNotNull((Object)task);
        CompensateEventTest.assertEquals((String)"eventSubProcessTask", (String)task.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testSubprocessCompensationHandlerWithEventSubprocess.bpmn20.xml"})
    public void FAILING_testSubprocessCompensationHandlerWithEventSubprocessActivityInstanceTree() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandlerWithEventSubprocess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        this.runtimeService.correlateMessage("Message");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwCompensate").beginScope("compensationHandler").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
    }

    @Deployment
    public void FAILING_testReceiveTaskCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveTaskCompensationHandler");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        CompensateEventTest.assertNotNull((Object)eventSubscription);
        CompensateEventTest.assertEquals((String)"message", (String)eventSubscription.getEventType());
        this.runtimeService.correlateMessage("Message");
        Task afterCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompensateEventTest.assertNotNull((Object)afterCompensationTask);
        CompensateEventTest.assertEquals((String)"beforeEnd", (String)afterCompensationTask.getTaskDefinitionKey());
        this.taskService.complete(afterCompensationTask.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testConcurrentScopeCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentScopeCompensation");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("beforeCompensationTask").singleResult();
        Task concurrentTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("concurrentTask").singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("compensateScope1Task");
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((Object)1, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("compensateScope2Task");
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((Object)1, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
        }
        this.taskService.complete(concurrentTask.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testLocalVariablesInEndExecutionListener() {
        SetLocalVariableListener setListener = new SetLocalVariableListener("foo", "bar");
        ReadLocalVariableListener readListener = new ReadLocalVariableListener("foo");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("setListener", (Object)setListener).putValue("readListener", (Object)readListener));
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        readListener = (ReadLocalVariableListener)this.runtimeService.getVariable(processInstance.getId(), "readListener");
        Assert.assertEquals((long)1L, (long)readListener.getVariableEvents().size());
        ReadLocalVariableListener.VariableEvent event = readListener.getVariableEvents().get(0);
        Assert.assertEquals((Object)"foo", (Object)event.getVariableName());
        Assert.assertEquals((Object)"bar", (Object)event.getVariableValue());
    }

    private void completeTask(String taskName) {
        this.completeTasks(taskName, 1);
    }

    private void completeTasks(String taskName, int times) {
        List tasks = this.taskService.createTaskQuery().taskName(taskName).list();
        CompensateEventTest.assertTrue((String)("Actual there are " + tasks.size() + " open tasks with name '" + taskName + "'. Expected at least " + times), (times <= tasks.size() ? 1 : 0) != 0);
        Iterator taskIterator = tasks.iterator();
        for (int i = 0; i < times; ++i) {
            Task task = (Task)taskIterator.next();
            this.taskService.complete(task.getId());
        }
    }

    private void completeTaskWithVariable(String taskName, String variable, Object value) {
        Task task = (Task)this.taskService.createTaskQuery().taskName(taskName).singleResult();
        CompensateEventTest.assertNotNull((String)("No open task with name '" + taskName + "'"), (Object)task);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (variable != null) {
            variables.put(variable, value);
        }
        this.taskService.complete(task.getId(), variables);
    }
}

