/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.error;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.error.BpmnErrorBean;
import org.camunda.bpm.engine.test.bpmn.event.error.ThrowErrorDelegate;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class BoundaryErrorEventTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.identityService.setAuthenticatedUserId("kermit");
    }

    protected void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        super.tearDown();
    }

    @Deployment
    public void testCatchErrorOnEmbeddedSubprocess() {
        this.runtimeService.startProcessInstanceByKey("boundaryErrorOnEmbeddedSubprocess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"subprocessTask", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"task after catching the error", (String)task.getName());
    }

    public void testThrowErrorWithoutErrorCode() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testThrowErrorWithoutErrorCode.bpmn20.xml").deploy();
            BoundaryErrorEventTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("'errorCode' is mandatory on errors referenced by throwing error event definitions", re.getMessage());
        }
    }

    public void testThrowErrorWithEmptyErrorCode() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testThrowErrorWithEmptyErrorCode.bpmn20.xml").deploy();
            BoundaryErrorEventTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("'errorCode' is mandatory on errors referenced by throwing error event definitions", re.getMessage());
        }
    }

    @Deployment
    public void testCatchErrorOnEmbeddedSubprocessWithEmptyErrorCode() {
        this.testCatchErrorOnEmbeddedSubprocess();
    }

    @Deployment
    public void testCatchErrorOnEmbeddedSubprocessWithoutErrorCode() {
        this.testCatchErrorOnEmbeddedSubprocess();
    }

    @Deployment
    public void testCatchErrorOfInnerSubprocessOnOuterSubprocess() {
        this.runtimeService.startProcessInstanceByKey("boundaryErrorTest");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryErrorEventTest.assertEquals((int)2, (int)tasks.size());
        BoundaryErrorEventTest.assertEquals((String)"Inner subprocess task 1", (String)((Task)tasks.get(0)).getName());
        BoundaryErrorEventTest.assertEquals((String)"Inner subprocess task 2", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = this.taskService.createTaskQuery().list();
        Task taskAfterError = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"task outside subprocess", (String)taskAfterError.getName());
    }

    @Deployment
    public void testCatchErrorInConcurrentEmbeddedSubprocesses() {
        this.assertErrorCaughtInConcurrentEmbeddedSubprocesses("boundaryEventTestConcurrentSubprocesses");
    }

    @Deployment
    public void testCatchErrorInConcurrentEmbeddedSubprocessesThrownByScriptTask() {
        this.assertErrorCaughtInConcurrentEmbeddedSubprocesses("catchErrorInConcurrentEmbeddedSubprocessesThrownByScriptTask");
    }

    private void assertErrorCaughtInConcurrentEmbeddedSubprocesses(String processDefinitionKey) {
        String procId = this.runtimeService.startProcessInstanceByKey(processDefinitionKey).getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryErrorEventTest.assertEquals((int)2, (int)tasks.size());
        BoundaryErrorEventTest.assertEquals((String)"task A", (String)((Task)tasks.get(0)).getName());
        BoundaryErrorEventTest.assertEquals((String)"task B", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"task D", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
        procId = this.runtimeService.startProcessInstanceByKey(processDefinitionKey).getId();
        tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryErrorEventTest.assertEquals((int)2, (int)tasks.size());
        BoundaryErrorEventTest.assertEquals((String)"task A", (String)((Task)tasks.get(0)).getName());
        BoundaryErrorEventTest.assertEquals((String)"task B", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryErrorEventTest.assertEquals((int)2, (int)tasks.size());
        BoundaryErrorEventTest.assertEquals((String)"task A", (String)((Task)tasks.get(0)).getName());
        BoundaryErrorEventTest.assertEquals((String)"task C", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"task A", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"task D", (String)task.getName());
    }

    @Deployment
    public void testDeeplyNestedErrorThrown() {
        String procId = this.runtimeService.startProcessInstanceByKey("deeplyNestedErrorThrown").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Nested task", (String)task.getName());
        this.taskService.complete(task.getId(), CollectionUtil.singletonMap((String)"input", (Object)1));
        this.assertProcessEnded(procId);
        procId = this.runtimeService.startProcessInstanceByKey("deeplyNestedErrorThrown").getId();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Nested task", (String)task.getName());
        this.taskService.complete(task.getId(), CollectionUtil.singletonMap((String)"input", (Object)2));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"task after catch", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testDeeplyNestedErrorThrownOnlyAutomaticSteps() {
        HistoricProcessInstance hip;
        String procId = this.runtimeService.startProcessInstanceByKey("deeplyNestedErrorThrown", CollectionUtil.singletonMap((String)"input", (Object)1)).getId();
        this.assertProcessEnded(procId);
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            hip = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procId).singleResult();
            BoundaryErrorEventTest.assertEquals((String)"processEnd1", (String)hip.getEndActivityId());
        }
        procId = this.runtimeService.startProcessInstanceByKey("deeplyNestedErrorThrown", CollectionUtil.singletonMap((String)"input", (Object)1)).getId();
        this.assertProcessEnded(procId);
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            hip = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procId).singleResult();
            BoundaryErrorEventTest.assertEquals((String)"processEnd1", (String)hip.getEndActivityId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    public void testCatchErrorOnCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnCallActivity").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Escalated Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    public void FAILING_testCatchErrorOnCallActivityShouldEndCalledProcessProperly() {
        this.runtimeService.startProcessInstanceByKey("catchErrorOnCallActivity").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Escalated Task", (String)task.getName());
        HistoricProcessInstance historicSubProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("simpleSubProcess").singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)historicSubProcessInstance);
        BoundaryErrorEventTest.assertNull((Object)historicSubProcessInstance.getDeleteReason());
        BoundaryErrorEventTest.assertEquals((String)"theEnd", (String)historicSubProcessInstance.getEndActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    public void testUncaughtError() {
        this.runtimeService.startProcessInstanceByKey("simpleSubProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        try {
            this.taskService.complete(task.getId());
        }
        catch (BpmnError e) {
            this.assertTextPresent("No catching boundary event found for error with errorCode 'myError', neither in same process nor in parent process", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testUncaughtErrorOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    public void testUncaughtErrorOnCallActivity() {
        this.runtimeService.startProcessInstanceByKey("uncaughtErrorOnCallActivity");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        try {
            this.taskService.complete(task.getId());
        }
        catch (BpmnError e) {
            this.assertTextPresent("No catching boundary event found for error with errorCode 'myError', neither in same process nor in parent process", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByCallActivityOnSubprocess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    public void testCatchErrorThrownByCallActivityOnSubprocess() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnSubprocess").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Escalated Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByCallActivityOnCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess2ndLevel.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    public void testCatchErrorThrownByCallActivityOnCallActivity() throws InterruptedException {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnCallActivity2ndLevel").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Escalated Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testCatchErrorOnParallelMultiInstance() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnParallelMi").getId();
        List tasks = this.taskService.createTaskQuery().list();
        BoundaryErrorEventTest.assertEquals((int)5, (int)tasks.size());
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("throwError", false);
        this.taskService.complete(((Task)tasks.get(2)).getId(), vars);
        this.taskService.complete(((Task)tasks.get(3)).getId(), vars);
        vars.put("throwError", true);
        this.taskService.complete(((Task)tasks.get(1)).getId(), vars);
        BoundaryErrorEventTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testCatchErrorOnSequentialMultiInstance() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnSequentialMi").getId();
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("throwError", false);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId(), vars);
        vars.put("throwError", true);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId(), vars);
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testCatchErrorThrownBySignallableActivityBehaviour() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownBySignallableActivityBehaviour").getId();
        BoundaryErrorEventTest.assertNotNull((String)"Didn't get a process id from runtime service", (Object)procId);
        ActivityInstance processActivityInstance = this.runtimeService.getActivityInstance(procId);
        ActivityInstance serviceTask = processActivityInstance.getChildActivityInstances()[0];
        BoundaryErrorEventTest.assertEquals((String)"Expected the service task to be active after starting the process", (String)"serviceTask", (String)serviceTask.getActivityId());
        this.runtimeService.signal(serviceTask.getExecutionIds()[0]);
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByJavaDelegateOnServiceTask() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnServiceTask").getId();
        this.assertThatErrorHasBeenCaught(procId);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("exceptionType", true);
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnServiceTask", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByJavaDelegateOnServiceTaskNotCancelActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnServiceTaskNotCancelActiviti").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByJavaDelegateOnServiceTaskWithErrorCode() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnServiceTaskWithErrorCode").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByJavaDelegateOnEmbeddedSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("exceptionType", true);
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnEmbeddedSubProcess", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByJavaDelegateOnEmbeddedSubProcessInduction() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnEmbeddedSubProcessInduction").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    public void testCatchErrorThrownByJavaDelegateOnCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnCallActivity-parent").getId();
        this.assertThatErrorHasBeenCaught(procId);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("exceptionType", true);
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnCallActivity-parent", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    public void testUncaughtErrorThrownByJavaDelegateOnServiceTask() {
        try {
            this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnCallActivity-child");
        }
        catch (BpmnError e) {
            this.assertTextPresent("No catching boundary event found for error with errorCode '23', neither in same process nor in parent process", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchExceptionThrownByExecuteOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwException()).getId();
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)userTask);
        BoundaryErrorEventTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchErrorThrownByExecuteOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwError()).getId();
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)userTask);
        BoundaryErrorEventTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchExceptionThrownBySignalMethodOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)userTask);
        BoundaryErrorEventTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment
    public void testCatchExceptionExpressionThrownByFollowUpTask() {
        try {
            Map<String, Object> vars = ThrowErrorDelegate.throwException();
            this.runtimeService.startProcessInstanceByKey("testProcess", vars).getId();
            BoundaryErrorEventTest.fail((String)"should fail and not catch the error on the first task");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        BoundaryErrorEventTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Deployment
    public void testCatchExceptionClassDelegateThrownByFollowUpTask() {
        try {
            Map<String, Object> vars = ThrowErrorDelegate.throwException();
            this.runtimeService.startProcessInstanceByKey("testProcess", vars).getId();
            BoundaryErrorEventTest.fail((String)"should fail");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        BoundaryErrorEventTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Deployment
    public void testCatchExceptionExpressionThrownByFollowUpScopeTask() {
        try {
            Map<String, Object> vars = ThrowErrorDelegate.throwException();
            this.runtimeService.startProcessInstanceByKey("testProcess", vars).getId();
            BoundaryErrorEventTest.fail((String)"should fail and not catch the error on the first task");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        BoundaryErrorEventTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchErrorThrownBySignalOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)userTask);
        BoundaryErrorEventTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    public void testCatchExceptionThrownByExecuteOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwException());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)userTask);
        BoundaryErrorEventTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    public void testCatchErrorThrownByExecuteOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwError());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)userTask);
        BoundaryErrorEventTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    public void testCatchExceptionThrownBySignalMethodOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)userTask);
        BoundaryErrorEventTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    public void testCatchErrorThrownBySignalOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        BoundaryErrorEventTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)userTask);
        BoundaryErrorEventTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testUncaughtErrorThrownByJavaDelegateOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    public void testUncaughtErrorThrownByJavaDelegateOnCallActivity() {
        try {
            this.runtimeService.startProcessInstanceByKey("uncaughtErrorThrownByJavaDelegateOnCallActivity-parent");
        }
        catch (BpmnError e) {
            this.assertTextPresent("No catching boundary event found for error with errorCode '23', neither in same process nor in parent process", e.getMessage());
        }
    }

    @Deployment
    public void testCatchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskSequential() {
        HashMap<String, Constable> variables = new HashMap<String, Constable>();
        variables.put("executionsBeforeError", Integer.valueOf(2));
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskSequential", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
        variables.put("executionsBeforeError", Integer.valueOf(2));
        variables.put("exceptionType", Boolean.valueOf(true));
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskSequential", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskParallel() {
        HashMap<String, Constable> variables = new HashMap<String, Constable>();
        variables.put("executionsBeforeError", Integer.valueOf(2));
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskParallel", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
        variables.put("executionsBeforeError", Integer.valueOf(2));
        variables.put("exceptionType", Boolean.valueOf(true));
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskParallel", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    public void testErrorThrownByJavaDelegateNotCaughtByOtherEventType() {
        String procId = this.runtimeService.startProcessInstanceByKey("testErrorThrownByJavaDelegateNotCaughtByOtherEventType").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    private void assertThatErrorHasBeenCaught(String procId) {
        BoundaryErrorEventTest.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Escalated Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    private void assertThatExceptionHasBeenCaught(String procId) {
        BoundaryErrorEventTest.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Escalated Exception Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testConcurrentExecutionsInterruptedOnDestroyScope() {
        this.runtimeService.startProcessInstanceByKey("process");
    }

    @Deployment
    public void testCatchErrorThrownByExpressionOnServiceTask() {
        HashMap<String, BpmnErrorBean> variables = new HashMap<String, BpmnErrorBean>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchErrorThrownByExpressionOnServiceTask", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByDelegateExpressionOnServiceTask() {
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchErrorThrownByDelegateExpressionOnServiceTask", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
        variables.put("exceptionType", Boolean.valueOf(true));
        procId = this.runtimeService.startProcessInstanceByKey("testCatchErrorThrownByDelegateExpressionOnServiceTask", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByJavaDelegateProvidedByDelegateExpressionOnServiceTask() {
        HashMap<String, BpmnErrorBean> variables = new HashMap<String, BpmnErrorBean>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchErrorThrownByJavaDelegateProvidedByDelegateExpressionOnServiceTask", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchExceptionThrownByExpressionOnServiceTask() {
        HashMap<String, BpmnErrorBean> variables = new HashMap<String, BpmnErrorBean>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchExceptionThrownByExpressionOnServiceTask", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchExceptionThrownByScriptTask() {
        HashMap variables = new HashMap();
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchExceptionThrownByScriptTask", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchSpecializedExceptionThrownByDelegate() {
        HashMap<String, BpmnErrorBean> variables = new HashMap<String, BpmnErrorBean>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchSpecializedExceptionThrownByDelegate", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    public void testUncaughtRuntimeException() {
        try {
            this.runtimeService.startProcessInstanceByKey("testUncaughtRuntimeException");
            BoundaryErrorEventTest.fail((String)"error should not be caught");
        }
        catch (RuntimeException e) {
            BoundaryErrorEventTest.assertEquals((String)"This should not be caught!", (String)e.getMessage());
        }
    }

    @Deployment
    public void testUncaughtBusinessExceptionWrongErrorCode() {
        try {
            this.runtimeService.startProcessInstanceByKey("testUncaughtBusinessExceptionWrongErrorCode");
            BoundaryErrorEventTest.fail((String)"error should not be caught");
        }
        catch (RuntimeException e) {
            BoundaryErrorEventTest.assertEquals((String)"couldn't execute activity <serviceTask id=\"serviceTask\" ...>: Business Exception", (String)e.getMessage());
        }
    }

    @Deployment
    public void testCatchErrorOnSubprocessThrownByNonInterruptingEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        EventSubscription messageSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        this.runtimeService.messageEventReceived("message", messageSubscription.getExecutionId());
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("afterBoundaryTask").singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)taskExecution);
        Task task = (Task)this.taskService.createTaskQuery().executionId(taskExecution.getId()).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)task);
    }

    @Deployment
    public void testCatchErrorOnSubprocessThrownByInterruptingEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        EventSubscription messageSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        this.runtimeService.messageEventReceived("message", messageSubscription.getExecutionId());
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("afterBoundaryTask").singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)taskExecution);
        Task task = (Task)this.taskService.createTaskQuery().executionId(taskExecution.getId()).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)task);
    }

    @Deployment
    public void testCatchErrorOnSubprocessThrownByNestedEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        EventSubscription messageSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        this.runtimeService.messageEventReceived("outerMessage", messageSubscription.getExecutionId());
        messageSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        this.runtimeService.messageEventReceived("innerMessage", messageSubscription.getExecutionId());
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("afterBoundaryTask").singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)taskExecution);
        Task task = (Task)this.taskService.createTaskQuery().executionId(taskExecution.getId()).singleResult();
        BoundaryErrorEventTest.assertNotNull((Object)task);
    }

    @Deployment
    public void testCatchErrorOnSubprocessSetsErrorCodeVariable() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorVariable";
        String errorCode = "error2";
        this.checkErrorCodeVariable(variableName, errorCode);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ThrowErrorProcess.bpmn", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByCallActivityOnSubprocessSetsErrorCodeVariable.bpmn"})
    public void testCatchErrorThrownByCallActivityOnSubprocessSetsErrorCodeVariable() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorVariable";
        String errorCode = "error";
        this.checkErrorCodeVariable(variableName, errorCode);
    }

    @Deployment
    public void testCatchErrorThrownByMultiInstanceSubProcessSetsErrorCodeVariable() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorVariable";
        String errorCode = "error";
        this.checkErrorCodeVariable(variableName, errorCode);
    }

    private void checkErrorCodeVariable(String variableName, Object expectedValue) {
        VariableInstance errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(variableName).singleResult();
        Assert.assertThat((Object)errorVariable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)errorVariable.getValue(), (Matcher)CoreMatchers.is((Object)expectedValue));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchBpmnErrorThrownByJavaDelegateInCallActivityOnSubprocessSetsErrorCodeVariable.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithThrownError.bpmn"})
    public void testCatchBpmnErrorThrownByJavaDelegateInCallActivityOnSubprocessSetsErrorCodeVariable() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        String variableName = "errorCode";
        String errorCode = "errorCode";
        this.checkErrorCodeVariable(variableName, errorCode);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/reviewSalesLead.bpmn20.xml"})
    public void testReviewSalesLeadProcess() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("details", "very interesting");
        variables.put("customerName", "Alfresco");
        String procId = this.runtimeService.startProcessInstanceByKey("reviewSaledLead", variables).getId();
        Task task = (Task)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Provide new sales lead", (String)task.getName());
        this.taskService.complete(task.getId());
        Task ratingTask = (Task)this.taskService.createTaskQuery().taskCandidateGroup("accountancy").singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Review customer rating", (String)ratingTask.getName());
        Task profitabilityTask = (Task)this.taskService.createTaskQuery().taskCandidateGroup("management").singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Review profitability", (String)profitabilityTask.getName());
        variables = new HashMap();
        variables.put("notEnoughInformation", true);
        this.taskService.complete(profitabilityTask.getId(), variables);
        Task provideDetailsTask = (Task)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Provide additional details", (String)provideDetailsTask.getName());
        this.taskService.complete(provideDetailsTask.getId());
        List reviewTasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryErrorEventTest.assertEquals((String)"Review customer rating", (String)((Task)reviewTasks.get(0)).getName());
        BoundaryErrorEventTest.assertEquals((String)"Review profitability", (String)((Task)reviewTasks.get(1)).getName());
        this.taskService.complete(((Task)reviewTasks.get(0)).getId());
        variables.put("notEnoughInformation", false);
        this.taskService.complete(((Task)reviewTasks.get(1)).getId(), variables);
        this.assertProcessEnded(procId);
    }
}

