/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.listener;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateCaseVariableInstance;
import org.camunda.bpm.engine.delegate.VariableListener;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.CaseExecutionContext;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.listener.DelegateVariableInstanceSpec;
import org.camunda.bpm.engine.test.cmmn.listener.LogAndUpdateVariableListener;
import org.camunda.bpm.engine.test.cmmn.listener.LogExecutionContextListener;
import org.camunda.bpm.engine.test.cmmn.listener.LogInjectedValuesListener;
import org.camunda.bpm.engine.test.cmmn.listener.LogVariableListener;
import org.camunda.bpm.engine.test.cmmn.listener.ProcessEngineAwareListener;
import org.camunda.bpm.engine.test.cmmn.listener.SimpleBean;

public class VariableListenerTest
extends PluggableProcessEngineTestCase {
    protected Map<Object, Object> beans = null;

    protected void setUp() throws Exception {
        super.setUp();
        LogVariableListener.reset();
        this.beans = this.processEngineConfiguration.getBeans();
    }

    @Deployment
    public void testAnyEventListenerByClass() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(caseInstance.getId()).setVariable("anInstanceVariable", (Object)"anInstanceValue").execute();
        VariableListenerTest.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aNewTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("update").name("aTaskVariable").value("aNewTaskValue").activityInstanceId(taskExecution.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        this.caseService.withCaseExecution(taskExecution.getId()).removeVariable("aTaskVariable").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("delete").name("aTaskVariable").value(null).activityInstanceId(taskExecution.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    public void testCreateEventListenerByClass() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aNewTaskValue").execute();
        VariableListenerTest.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).removeVariable("aTaskVariable").execute();
        VariableListenerTest.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
    }

    @Deployment
    public void testUpdateEventListenerByClass() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aNewTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("update").name("aTaskVariable").value("aNewTaskValue").activityInstanceId(taskExecution.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        this.caseService.withCaseExecution(taskExecution.getId()).removeVariable("aTaskVariable").execute();
        VariableListenerTest.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
    }

    @Deployment
    public void testVariableListenerInvokedFromSourceScope() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(caseInstance.getId()).setVariable("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)0, (int)LogVariableListener.getInvocations().size());
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution((CaseExecution)caseInstance).sourceExecution(taskExecution).event("update").name("aTaskVariable").value("aTaskValue").activityInstanceId(caseInstance.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    public void testDeleteEventListenerByClass() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aNewTaskValue").execute();
        VariableListenerTest.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).removeVariable("aTaskVariable").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("delete").name("aTaskVariable").value(null).activityInstanceId(taskExecution.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    public void testVariableListenerByDelegateExpression() {
        this.beans.put("listener", new LogVariableListener());
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    public void testVariableListenerByExpression() {
        SimpleBean simpleBean = new SimpleBean();
        this.beans.put("bean", simpleBean);
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertTrue((boolean)simpleBean.wasInvoked());
    }

    @Deployment
    public void testVariableListenerByScript() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertTrue((boolean)SimpleBean.wasStaticallyInvoked());
        SimpleBean.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/VariableListenerTest.testListenerOnParentScope.cmmn"})
    public void testListenerSourceExecution() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution((CaseExecution)caseInstance).sourceExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    public void testListenerOnParentScope() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    public void testChildListenersNotInvoked() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        this.caseService.withCaseExecution(caseInstance.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)0, (int)LogVariableListener.getInvocations().size());
        LogVariableListener.reset();
    }

    @Deployment
    public void testListenerOnAncestorScope() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution stageExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        VariableListenerTest.assertNotNull((Object)stageExecution);
        this.caseService.withCaseExecution(stageExecution.getId()).manualStart();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    public void testInvalidListenerClassName() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        try {
            this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
            VariableListenerTest.fail((String)"expected exception during variable listener invocation");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    public void testListenerDoesNotImplementInterface() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        try {
            this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
            VariableListenerTest.fail((String)"expected exception during variable listener invocation");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    public void testDelegateInstanceIsProcessEngineAware() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        VariableListenerTest.assertFalse((boolean)ProcessEngineAwareListener.hasFoundValidRuntimeService());
        this.caseService.withCaseExecution(caseInstance.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        VariableListenerTest.assertTrue((boolean)ProcessEngineAwareListener.hasFoundValidRuntimeService());
        ProcessEngineAwareListener.reset();
    }

    @Deployment
    public void FAILING_testListenerDoesNotInterfereWithHistory() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        this.caseService.withCaseExecution(caseInstance.getId()).setVariableLocal("variable", (Object)"value1").execute();
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            List variableUpdates = this.historyService.createHistoricDetailQuery().variableUpdates().list();
            VariableListenerTest.assertEquals((int)2, (int)variableUpdates.size());
            for (HistoricDetail detail : variableUpdates) {
                HistoricVariableUpdate update = (HistoricVariableUpdate)detail;
                boolean update1Processed = false;
                boolean update2Processed = false;
                if (!update1Processed && update.getValue().equals("value1")) {
                    update1Processed = true;
                    continue;
                }
                if (!update2Processed && update.getValue().equals("value2")) {
                    update2Processed = true;
                    continue;
                }
                VariableListenerTest.fail((String)"unexpected variable update");
            }
        }
    }

    @Deployment
    public void testListenerInvocationFinishesBeforeSubsequentInvocations() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("variable", (Object)"value1").execute();
        List<DelegateCaseVariableInstance> invocations = LogAndUpdateVariableListener.getInvocations();
        VariableListenerTest.assertEquals((int)6, (int)invocations.size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("variable").value("value1").matches(LogAndUpdateVariableListener.getInvocations().get(0));
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("variable").value("value1").matches(LogAndUpdateVariableListener.getInvocations().get(1));
        for (int i = 2; i < 6; ++i) {
            DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("update").name("variable").value("value2").matches(LogAndUpdateVariableListener.getInvocations().get(i));
        }
        LogAndUpdateVariableListener.reset();
    }

    @Deployment
    public void testTwoListenersOnSameScope() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("testVariable").value("value1").matches(LogVariableListener.getInvocations().get(0));
        VariableListenerTest.assertEquals((int)1, (int)LogAndUpdateVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("testVariable").value("value1").matches(LogAndUpdateVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        LogAndUpdateVariableListener.reset();
    }

    @Deployment
    public void testVariableListenerByClassWithFieldExpressions() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogInjectedValuesListener.getResolvedStringValueExpressions().size());
        VariableListenerTest.assertEquals((Object)"injectedValue", (Object)LogInjectedValuesListener.getResolvedStringValueExpressions().get(0));
        VariableListenerTest.assertEquals((int)1, (int)LogInjectedValuesListener.getResolvedJuelExpressions().size());
        VariableListenerTest.assertEquals((Object)"cam", (Object)LogInjectedValuesListener.getResolvedJuelExpressions().get(0));
        LogInjectedValuesListener.reset();
    }

    @Deployment
    public void testVariableListenerByDelegateExpressionWithFieldExpressions() {
        this.beans.put("listener", new LogInjectedValuesListener());
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogInjectedValuesListener.getResolvedStringValueExpressions().size());
        VariableListenerTest.assertEquals((Object)"injectedValue", (Object)LogInjectedValuesListener.getResolvedStringValueExpressions().get(0));
        VariableListenerTest.assertEquals((int)1, (int)LogInjectedValuesListener.getResolvedJuelExpressions().size());
        VariableListenerTest.assertEquals((Object)"cam", (Object)LogInjectedValuesListener.getResolvedJuelExpressions().get(0));
        LogInjectedValuesListener.reset();
    }

    @Deployment
    public void testVariableListenerExecutionContext() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogExecutionContextListener.getCaseExecutionContexts().size());
        CaseExecutionContext executionContext = LogExecutionContextListener.getCaseExecutionContexts().get(0);
        VariableListenerTest.assertNotNull((Object)executionContext);
        VariableListenerTest.assertEquals((String)caseInstance.getId(), (String)executionContext.getCaseInstance().getId());
        VariableListenerTest.assertEquals((String)taskExecution.getId(), (String)((CaseExecutionEntity)executionContext.getExecution()).getId());
        LogExecutionContextListener.reset();
    }

    @Deployment
    public void testInvokeBuiltinListenersOnly() {
        this.processEngineConfiguration.setInvokeCustomVariableListeners(false);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.processEngineConfiguration.getDeploymentCache().getCaseDefinitionById(caseDefinition.getId()).findActivity("PI_HumanTask_1").addBuiltInVariableListener("create", (VariableListener)new LogVariableListener());
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        VariableListenerTest.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        VariableListenerTest.assertEquals((int)0, (int)LogExecutionContextListener.getCaseExecutionContexts().size());
        LogVariableListener.reset();
        LogExecutionContextListener.reset();
        this.processEngineConfiguration.setInvokeCustomVariableListeners(true);
    }

    public void testDefaultCustomListenerInvocationSetting() {
        VariableListenerTest.assertTrue((boolean)this.processEngineConfiguration.isInvokeCustomVariableListeners());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/VariableListenerTest.testVariableListenerWithProcessTask.cmmn", "org/camunda/bpm/engine/test/cmmn/listener/VariableListenerTest.testVariableListenerWithProcessTask.bpmn20.xml"})
    public void testVariableListenerWithProcessTask() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case");
        CaseExecution processTask = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        String processTaskId = processTask.getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        VariableListenerTest.assertEquals((int)1, (int)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution((CaseExecution)caseInstance).sourceExecution(processTask).event("create").name("aVariable").value("aValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    protected void tearDown() throws Exception {
        this.beans.clear();
        super.tearDown();
    }
}

