/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.milestone;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;

public class MilestoneTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/milestone/MilestoneTest.testWithoutEntryCriterias.cmmn"})
    public void testWithoutEntryCriterias() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        MilestoneTest.assertTrue((boolean)caseInstance.isCompleted());
        Object occurVariable = this.caseService.getVariable(caseInstanceId, "occur");
        MilestoneTest.assertNotNull((Object)occurVariable);
        MilestoneTest.assertTrue((boolean)((Boolean)occurVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/milestone/MilestoneTest.testWithEntryCriteria.cmmn"})
    public void testWithEntryCriteria() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        CaseExecution milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        MilestoneTest.assertTrue((boolean)milestone.isAvailable());
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        MilestoneTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "occur"));
        milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().available().singleResult();
        MilestoneTest.assertTrue((boolean)milestone.isAvailable());
        this.caseService.withCaseExecution(humanTaskId).complete();
        Object occurVariable = this.caseService.getVariable(caseInstanceId, "occur");
        MilestoneTest.assertNotNull((Object)occurVariable);
        MilestoneTest.assertTrue((boolean)((Boolean)occurVariable));
        milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().available().singleResult();
        MilestoneTest.assertNull((Object)milestone);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        MilestoneTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/milestone/MilestoneTest.testWithMultipleEntryCriterias.cmmn"})
    public void testWithMultipleEntryCriterias() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        CaseExecution milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2").singleResult()).getId();
        MilestoneTest.assertTrue((boolean)milestone.isAvailable());
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        MilestoneTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "occur"));
        milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().available().singleResult();
        MilestoneTest.assertTrue((boolean)milestone.isAvailable());
        this.caseService.withCaseExecution(humanTaskId).complete();
        Object occurVariable = this.caseService.getVariable(caseInstanceId, "occur");
        MilestoneTest.assertNotNull((Object)occurVariable);
        MilestoneTest.assertTrue((boolean)((Boolean)occurVariable));
        milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().available().singleResult();
        MilestoneTest.assertNull((Object)milestone);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        MilestoneTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/milestone/MilestoneTest.testWithEntryCriteria.cmmn"})
    public void testActivityType() {
        this.caseService.withCaseDefinitionByKey("case").create().getId();
        CaseExecution milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult();
        MilestoneTest.assertEquals((String)"milestone", (String)milestone.getActivityType());
    }
}

