/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.repetition;

import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class RepetitionRuleTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testVariableBasedRule.cmmn"})
    public void testVariableBasedRepetitionRuleEvaluatesToTrue() {
        VariableMap variables = Variables.createVariables().putValue("repeat", (Object)true);
        this.createCaseInstanceByKey("case", variables);
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTask1);
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testVariableBasedRule.cmmn"})
    public void testVariableBasedRepetitionRuleEvaluatesToFalse() {
        VariableMap variables = Variables.createVariables().putValue("repeat", (Object)false);
        this.createCaseInstanceByKey("case", variables);
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTask1);
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testDefaultVariableBasedRule.cmmn"})
    public void testDefaultVariableBasedRepetitionRuleEvaluatesToTrue() {
        VariableMap variables = Variables.createVariables().putValue("repeat", (Object)true);
        this.createCaseInstanceByKey("case", variables);
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTask1);
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testDefaultVariableBasedRule.cmmn"})
    public void testDefaultVariableBasedRepetitionRuleEvaluatesToFalse() {
        VariableMap variables = Variables.createVariables().putValue("repeat", (Object)false);
        this.createCaseInstanceByKey("case", variables);
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTask1);
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
    }

    @Deployment
    public void testRepeatTask() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        CaseExecution originInstance = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)originInstance);
        CaseExecution repetitionInstance = (CaseExecution)query.available().singleResult();
        RepetitionRuleTest.assertNotNull((Object)repetitionInstance);
    }

    @Deployment
    public void testRepeatStage() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        CaseExecution originInstance = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)originInstance);
        CaseExecution repetitionInstance = (CaseExecution)query.available().singleResult();
        RepetitionRuleTest.assertNotNull((Object)repetitionInstance);
    }

    @Deployment
    public void testRepeatMilestone() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        String milestoneId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertTrue((boolean)((CaseExecution)query.singleResult()).isAvailable());
        RepetitionRuleTest.assertFalse((boolean)milestoneId.equals(((CaseExecution)query.singleResult()).getId()));
    }

    @Deployment
    public void testRepeatTaskMultipleTimes() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.disable(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        CaseExecution originInstance = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)originInstance);
        CaseExecution repetitionInstance = (CaseExecution)query.available().singleResult();
        RepetitionRuleTest.assertNotNull((Object)repetitionInstance);
        this.reenable(firstHumanTaskId);
        this.disable(firstHumanTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)2L, (long)query.enabled().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment
    public void testRepeatStageMultipleTimes() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.disable(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        CaseExecution originInstance = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)originInstance);
        CaseExecution repetitionInstance = (CaseExecution)query.available().singleResult();
        RepetitionRuleTest.assertNotNull((Object)repetitionInstance);
        this.reenable(firstHumanTaskId);
        this.disable(firstHumanTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)2L, (long)query.enabled().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment
    public void testRepeatMilestoneMultipleTimes() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        String milestoneId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        this.disable(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertTrue((boolean)((CaseExecution)query.singleResult()).isAvailable());
        RepetitionRuleTest.assertFalse((boolean)milestoneId.equals(((CaseExecution)query.singleResult()).getId()));
        this.reenable(firstHumanTaskId);
        this.disable(firstHumanTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertTrue((boolean)((CaseExecution)query.singleResult()).isAvailable());
        RepetitionRuleTest.assertFalse((boolean)milestoneId.equals(((CaseExecution)query.singleResult()).getId()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatTaskWithoutEntryCriteria.cmmn"})
    public void testRepeatTaskWithoutEntryCriteriaWhenCompleting() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        CaseExecution enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.manualStart(enabledCaseExecution.getId());
        this.complete(enabledCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.manualStart(enabledCaseExecution.getId());
        this.complete(enabledCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.complete(caseInstanceId);
        query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatStageWithoutEntryCriteria.cmmn"})
    public void testRepeatStageWithoutEntryCriteriaWhenCompleting() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        CaseExecution enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.manualStart(enabledStageCaseExecution.getId());
        CaseExecution humanTaskCaseExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.manualStart(humanTaskCaseExecution.getId());
        this.complete(humanTaskCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.manualStart(enabledStageCaseExecution.getId());
        humanTaskCaseExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.manualStart(humanTaskCaseExecution.getId());
        this.complete(humanTaskCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.complete(caseInstanceId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatTaskWithoutEntryCriteria.cmmn"})
    public void testRepeatTaskWithoutEntryCriteriaWhenTerminating() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        CaseExecution enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.manualStart(enabledCaseExecution.getId());
        this.terminate(enabledCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.manualStart(enabledCaseExecution.getId());
        this.terminate(enabledCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.complete(caseInstanceId);
        query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatStageWithoutEntryCriteria.cmmn"})
    public void testRepeatStageWithoutEntryCriteriaWhenTerminating() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        CaseExecution enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.manualStart(enabledStageCaseExecution.getId());
        CaseExecution humanTaskCaseExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.manualStart(humanTaskCaseExecution.getId());
        this.terminate(humanTaskCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.manualStart(enabledStageCaseExecution.getId());
        humanTaskCaseExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.manualStart(humanTaskCaseExecution.getId());
        this.terminate(humanTaskCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.complete(caseInstanceId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment
    public void testRepeatTaskWithoutEntryCriteriaOnCustomStandardEvent() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        CaseExecution enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.disable(enabledCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.disable(enabledCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.complete(caseInstanceId);
        query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment
    public void testRepeatStageWithoutEntryCriteriaOnCustomStandardEvent() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        CaseExecution enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.disable(enabledStageCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)2L, (long)stageQuery.count());
        enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.disable(enabledStageCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)3L, (long)stageQuery.count());
        enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.complete(caseInstanceId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment
    public void testNonRepeatableTaskDependsOnRepeatableTask() {
        this.createCaseInstance();
        CaseExecutionQuery availableQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").available();
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        CaseExecutionQuery enabledQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").enabled();
        String enabledTaskId = ((CaseExecution)enabledQuery.listPage(0, 1).get(0)).getId();
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        RepetitionRuleTest.assertNotNull((Object)secondHumanTask);
        RepetitionRuleTest.assertTrue((boolean)secondHumanTask.isAvailable());
        this.manualStart(enabledTaskId);
        this.complete(enabledTaskId);
        secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        RepetitionRuleTest.assertNotNull((Object)secondHumanTask);
        RepetitionRuleTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment
    public void testRepeatableTaskDependsOnAnotherRepeatableTask() {
        this.createCaseInstance();
        CaseExecutionQuery availableQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").available();
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        CaseExecutionQuery enabledQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").enabled();
        String enabledTaskId = ((CaseExecution)enabledQuery.listPage(0, 1).get(0)).getId();
        this.manualStart(enabledTaskId);
        this.complete(enabledTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        enabledTaskId = ((CaseExecution)enabledQuery.listPage(0, 1).get(0)).getId();
        this.manualStart(enabledTaskId);
        this.complete(enabledTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)2L, (long)query.enabled().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment
    public void testLimitedRepetitions() {
        VariableMap variables = Variables.createVariables().putValue("repetition", (Object)0);
        this.createCaseInstanceByKey("case", variables);
        CaseExecutionQuery availableQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").available();
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        CaseExecutionQuery enabledQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").enabled();
        String enabledTaskId = ((CaseExecution)enabledQuery.listPage(0, 1).get(0)).getId();
        this.manualStart(enabledTaskId);
        this.complete(enabledTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        enabledTaskId = ((CaseExecution)enabledQuery.listPage(0, 1).get(0)).getId();
        this.manualStart(enabledTaskId);
        this.complete(enabledTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)2L, (long)query.enabled().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        enabledTaskId = ((CaseExecution)enabledQuery.listPage(0, 1).get(0)).getId();
        this.manualStart(enabledTaskId);
        this.complete(enabledTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)3L, (long)query.enabled().count());
        RepetitionRuleTest.assertEquals((long)0L, (long)query.available().count());
    }

    @Deployment
    public void testLimitedSequentialRepetitions() {
        VariableMap variables = Variables.createVariables().putValue("repetition", (Object)0);
        this.createCaseInstanceByKey("case", variables);
        CaseExecutionQuery enabledQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").enabled();
        String enabledCaseExecutionId = ((CaseExecution)enabledQuery.singleResult()).getId();
        this.manualStart(enabledCaseExecutionId);
        this.complete(enabledCaseExecutionId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
        enabledCaseExecutionId = ((CaseExecution)enabledQuery.singleResult()).getId();
        this.manualStart(enabledCaseExecutionId);
        this.complete(enabledCaseExecutionId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
        enabledCaseExecutionId = ((CaseExecution)enabledQuery.singleResult()).getId();
        this.manualStart(enabledCaseExecutionId);
        this.complete(enabledCaseExecutionId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)0L, (long)query.count());
    }

    @Deployment
    public void testLimitedParallelRepetitions() {
        VariableMap variables = Variables.createVariables().putValue("repetition", (Object)0);
        this.createCaseInstanceByKey("case", variables);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        String caseExecutionId = ((CaseExecution)query.listPage(0, 1).get(0)).getId();
        this.manualStart(caseExecutionId);
        this.complete(caseExecutionId);
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
    }

    @Deployment
    public void testAutoCompleteStage() {
        String caseInstanceId = this.createCaseInstance().getId();
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        RepetitionRuleTest.assertNull((Object)stage);
        CaseInstance caseInstance = (CaseInstance)this.queryCaseExecutionById(caseInstanceId);
        RepetitionRuleTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment
    public void testAutoCompleteStageWithoutEntryCriteria() {
        VariableMap variables = Variables.createVariables().putValue("manualActivation", (Object)false);
        String caseInstanceId = this.createCaseInstanceByKey("case", variables).getId();
        String stageId = this.queryCaseExecutionByActivityId("PI_Stage_1").getId();
        this.manualStart(stageId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        String activeTaskId = ((CaseExecution)query.singleResult()).getId();
        this.complete(activeTaskId);
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        RepetitionRuleTest.assertNull((Object)stage);
        CaseInstance caseInstance = (CaseInstance)this.queryCaseExecutionById(caseInstanceId);
        RepetitionRuleTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment
    public void testAutoCompleteStageAutoActivationRepeatableTask() {
        String caseInstanceId = this.createCaseInstance().getId();
        String stageId = this.queryCaseExecutionByActivityId("PI_Stage_1").getId();
        this.manualStart(stageId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        String activeTaskId = ((CaseExecution)query.singleResult()).getId();
        this.complete(activeTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        RepetitionRuleTest.assertNotNull((Object)stage);
        RepetitionRuleTest.assertTrue((boolean)stage.isActive());
        CaseInstance caseInstance = (CaseInstance)this.queryCaseExecutionById(caseInstanceId);
        RepetitionRuleTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment
    public void testAutoCompleteStageRequiredRepeatableTask() {
        String caseInstanceId = this.createCaseInstance().getId();
        String stageId = this.queryCaseExecutionByActivityId("PI_Stage_1").getId();
        this.manualStart(stageId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
        String enabledTaskId = ((CaseExecution)query.singleResult()).getId();
        this.manualStart(enabledTaskId);
        this.complete(enabledTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        RepetitionRuleTest.assertNotNull((Object)stage);
        RepetitionRuleTest.assertTrue((boolean)stage.isActive());
        CaseInstance caseInstance = (CaseInstance)this.queryCaseExecutionById(caseInstanceId);
        RepetitionRuleTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatTask.cmmn"})
    public void testShouldNotRepeatTaskAfterCompletion() {
        this.createCaseInstance();
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTask1);
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.enabled().count());
        String humanTask2 = ((CaseExecution)query.enabled().singleResult()).getId();
        this.manualStart(humanTask2);
        this.complete(humanTask2);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment
    public void testIgnoreRepeatOnStandardEvent() {
        this.createCaseInstance();
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.manualStart(humanTask1);
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        String humanTask2 = ((CaseExecution)query.enabled().singleResult()).getId();
        this.disable(humanTask2);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
    }

    protected void fireEntryCriteria(final String caseExecutionId) {
        this.executeHelperCaseCommand(new CmmnProcessEngineTestCase.HelperCaseCommand(){

            public void execute() {
                this.getExecution(caseExecutionId).fireEntryCriteria();
            }
        });
    }
}

