/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.businessruletask;

import java.util.Collections;
import org.camunda.bpm.dmn.engine.DmnDecisionRuleResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.dmn.businessruletask.DecisionResultTestListener;
import org.camunda.bpm.engine.variable.Variables;

public class DmnDecisionResultListenerTest
extends PluggableProcessEngineTestCase {
    protected static final String TEST_PROCESS = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml";
    protected static final String TEST_DECISION = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml";
    protected static final String TEST_DECISION_COLLECT_SUM = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml";
    protected static final String TEST_DECISION_COLLECT_COUNT = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectCountHitPolicyTest.dmn11.xml";
    protected DmnDecisionTableResult results;

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testNoOutput() {
        this.startTestProcess("no output");
        DmnDecisionResultListenerTest.assertTrue((String)"The decision result 'ruleResult' should be empty", (boolean)this.results.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testEmptyOutput() {
        this.startTestProcess("empty output");
        DmnDecisionResultListenerTest.assertFalse((String)"The decision result 'ruleResult' should not be empty", (boolean)this.results.isEmpty());
        DmnDecisionRuleResult decisionOutput = (DmnDecisionRuleResult)this.results.get(0);
        DmnDecisionResultListenerTest.assertNull((Object)decisionOutput.getFirstEntry());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testEmptyMap() {
        this.startTestProcess("empty map");
        DmnDecisionResultListenerTest.assertEquals((int)2, (int)this.results.size());
        for (DmnDecisionRuleResult output : this.results) {
            DmnDecisionResultListenerTest.assertTrue((String)"The decision output should be empty", (boolean)output.isEmpty());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleEntry() {
        this.startTestProcess("single entry");
        DmnDecisionRuleResult firstOutput = (DmnDecisionRuleResult)this.results.get(0);
        DmnDecisionResultListenerTest.assertEquals((Object)"foo", (Object)firstOutput.getFirstEntry());
        DmnDecisionResultListenerTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testMultipleEntries() {
        this.startTestProcess("multiple entries");
        DmnDecisionRuleResult firstOutput = (DmnDecisionRuleResult)this.results.get(0);
        DmnDecisionResultListenerTest.assertEquals((Object)"foo", (Object)firstOutput.get((Object)"result1"));
        DmnDecisionResultListenerTest.assertEquals((Object)"bar", (Object)firstOutput.get((Object)"result2"));
        DmnDecisionResultListenerTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)firstOutput.getEntryTyped("result1"));
        DmnDecisionResultListenerTest.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)firstOutput.getEntryTyped("result2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleEntryList() {
        this.startTestProcess("single entry list");
        DmnDecisionResultListenerTest.assertEquals((int)2, (int)this.results.size());
        for (DmnDecisionRuleResult output : this.results) {
            DmnDecisionResultListenerTest.assertEquals((Object)"foo", (Object)output.getFirstEntry());
            DmnDecisionResultListenerTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)output.getFirstEntryTyped());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testMultipleEntriesList() {
        this.startTestProcess("multiple entries list");
        DmnDecisionResultListenerTest.assertEquals((int)2, (int)this.results.size());
        for (DmnDecisionRuleResult output : this.results) {
            DmnDecisionResultListenerTest.assertEquals((int)2, (int)output.size());
            DmnDecisionResultListenerTest.assertEquals((Object)"foo", (Object)output.get((Object)"result1"));
            DmnDecisionResultListenerTest.assertEquals((Object)"bar", (Object)output.get((Object)"result2"));
            DmnDecisionResultListenerTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)output.getEntryTyped("result1"));
            DmnDecisionResultListenerTest.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)output.getEntryTyped("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectCountHitPolicyTest.dmn11.xml"})
    public void testCollectCountHitPolicyNoOutput() {
        this.startTestProcess("no output");
        DmnDecisionResultListenerTest.assertEquals((int)1, (int)this.results.size());
        DmnDecisionRuleResult firstOutput = (DmnDecisionRuleResult)this.results.get(0);
        DmnDecisionResultListenerTest.assertEquals((Object)0, (Object)firstOutput.getFirstEntry());
        DmnDecisionResultListenerTest.assertEquals((Object)Variables.integerValue((Integer)0), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    public void testCollectSumHitPolicyNoOutput() {
        this.startTestProcess("no output");
        DmnDecisionResultListenerTest.assertTrue((String)"The decision result 'ruleResult' should be empty", (boolean)this.results.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    public void testCollectSumHitPolicySingleEntry() {
        this.startTestProcess("single entry");
        DmnDecisionResultListenerTest.assertEquals((int)1, (int)this.results.size());
        DmnDecisionRuleResult firstOutput = (DmnDecisionRuleResult)this.results.get(0);
        DmnDecisionResultListenerTest.assertEquals((Object)12, (Object)firstOutput.getFirstEntry());
        DmnDecisionResultListenerTest.assertEquals((Object)Variables.integerValue((Integer)12), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    public void testCollectSumHitPolicySingleEntryList() {
        this.startTestProcess("single entry list");
        DmnDecisionResultListenerTest.assertEquals((int)1, (int)this.results.size());
        DmnDecisionRuleResult firstOutput = (DmnDecisionRuleResult)this.results.get(0);
        DmnDecisionResultListenerTest.assertEquals((Object)33, (Object)firstOutput.getFirstEntry());
        DmnDecisionResultListenerTest.assertEquals((Object)Variables.integerValue((Integer)33), (Object)firstOutput.getFirstEntryTyped());
    }

    protected ProcessInstance startTestProcess(String input) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("input", input));
        this.results = DecisionResultTestListener.getDecisionResult();
        DmnDecisionResultListenerTest.assertNotNull((Object)this.results);
        return processInstance;
    }

    protected void tearDown() throws Exception {
        DecisionResultTestListener.reset();
    }
}

