/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.List;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;

public class UserOperationLogDeploymentTest
extends AbstractUserOperationLogTest {
    protected static final String DEPLOYMENT_NAME = "my-deployment";
    protected static final String RESOURCE_NAME = "path/to/my/process.bpmn";
    protected static final String PROCESS_KEY = "process";

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true, true);
        }
    }

    public void testCreateDeployment() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        UserOperationLogDeploymentTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogDeploymentTest.assertEquals((String)"Deployment", (String)userOperationLogEntry.getEntityType());
        UserOperationLogDeploymentTest.assertEquals((String)deployment.getId(), (String)userOperationLogEntry.getDeploymentId());
        UserOperationLogDeploymentTest.assertEquals((String)"Create", (String)userOperationLogEntry.getOperationType());
        UserOperationLogDeploymentTest.assertEquals((String)"duplicateFilterEnabled", (String)userOperationLogEntry.getProperty());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogDeploymentTest.assertFalse((boolean)Boolean.valueOf(userOperationLogEntry.getNewValue()));
        UserOperationLogDeploymentTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getCaseInstanceId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getCaseDefinitionId());
    }

    public void testCreateDeploymentPa() {
        EmbeddedProcessApplication application = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(application.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        UserOperationLogDeploymentTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogDeploymentTest.assertEquals((String)"Deployment", (String)userOperationLogEntry.getEntityType());
        UserOperationLogDeploymentTest.assertEquals((String)deployment.getId(), (String)userOperationLogEntry.getDeploymentId());
        UserOperationLogDeploymentTest.assertEquals((String)"Create", (String)userOperationLogEntry.getOperationType());
        UserOperationLogDeploymentTest.assertEquals((String)"duplicateFilterEnabled", (String)userOperationLogEntry.getProperty());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogDeploymentTest.assertFalse((boolean)Boolean.valueOf(userOperationLogEntry.getNewValue()));
        UserOperationLogDeploymentTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getCaseInstanceId());
        UserOperationLogDeploymentTest.assertNull((Object)userOperationLogEntry.getCaseDefinitionId());
    }

    public void testPropertyDuplicateFiltering() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(false).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        UserOperationLogDeploymentTest.assertEquals((long)2L, (long)query.count());
        UserOperationLogEntry logDuplicateFilterEnabledProperty = (UserOperationLogEntry)query.property("duplicateFilterEnabled").singleResult();
        UserOperationLogDeploymentTest.assertNotNull((Object)logDuplicateFilterEnabledProperty);
        UserOperationLogDeploymentTest.assertEquals((String)"Deployment", (String)logDuplicateFilterEnabledProperty.getEntityType());
        UserOperationLogDeploymentTest.assertEquals((String)deployment.getId(), (String)logDuplicateFilterEnabledProperty.getDeploymentId());
        UserOperationLogDeploymentTest.assertEquals((String)"Create", (String)logDuplicateFilterEnabledProperty.getOperationType());
        UserOperationLogDeploymentTest.assertEquals((String)"demo", (String)logDuplicateFilterEnabledProperty.getUserId());
        UserOperationLogDeploymentTest.assertEquals((String)"duplicateFilterEnabled", (String)logDuplicateFilterEnabledProperty.getProperty());
        UserOperationLogDeploymentTest.assertNull((Object)logDuplicateFilterEnabledProperty.getOrgValue());
        UserOperationLogDeploymentTest.assertTrue((boolean)Boolean.valueOf(logDuplicateFilterEnabledProperty.getNewValue()));
        UserOperationLogEntry logDeployChangedOnlyProperty = (UserOperationLogEntry)query.property("deployChangedOnly").singleResult();
        UserOperationLogDeploymentTest.assertNotNull((Object)logDeployChangedOnlyProperty);
        UserOperationLogDeploymentTest.assertEquals((String)"Deployment", (String)logDeployChangedOnlyProperty.getEntityType());
        UserOperationLogDeploymentTest.assertEquals((String)deployment.getId(), (String)logDeployChangedOnlyProperty.getDeploymentId());
        UserOperationLogDeploymentTest.assertEquals((String)"Create", (String)logDeployChangedOnlyProperty.getOperationType());
        UserOperationLogDeploymentTest.assertEquals((String)"demo", (String)logDeployChangedOnlyProperty.getUserId());
        UserOperationLogDeploymentTest.assertEquals((String)"deployChangedOnly", (String)logDeployChangedOnlyProperty.getProperty());
        UserOperationLogDeploymentTest.assertNull((Object)logDeployChangedOnlyProperty.getOrgValue());
        UserOperationLogDeploymentTest.assertFalse((boolean)Boolean.valueOf(logDeployChangedOnlyProperty.getNewValue()));
        UserOperationLogDeploymentTest.assertEquals((String)logDuplicateFilterEnabledProperty.getOperationId(), (String)logDeployChangedOnlyProperty.getOperationId());
    }

    public void testPropertiesDuplicateFilteringAndDeployChangedOnly() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        UserOperationLogDeploymentTest.assertEquals((long)2L, (long)query.count());
        UserOperationLogEntry logDuplicateFilterEnabledProperty = (UserOperationLogEntry)query.property("duplicateFilterEnabled").singleResult();
        UserOperationLogDeploymentTest.assertNotNull((Object)logDuplicateFilterEnabledProperty);
        UserOperationLogDeploymentTest.assertEquals((String)"Deployment", (String)logDuplicateFilterEnabledProperty.getEntityType());
        UserOperationLogDeploymentTest.assertEquals((String)deployment.getId(), (String)logDuplicateFilterEnabledProperty.getDeploymentId());
        UserOperationLogDeploymentTest.assertEquals((String)"Create", (String)logDuplicateFilterEnabledProperty.getOperationType());
        UserOperationLogDeploymentTest.assertEquals((String)"demo", (String)logDuplicateFilterEnabledProperty.getUserId());
        UserOperationLogDeploymentTest.assertEquals((String)"duplicateFilterEnabled", (String)logDuplicateFilterEnabledProperty.getProperty());
        UserOperationLogDeploymentTest.assertNull((Object)logDuplicateFilterEnabledProperty.getOrgValue());
        UserOperationLogDeploymentTest.assertTrue((boolean)Boolean.valueOf(logDuplicateFilterEnabledProperty.getNewValue()));
        UserOperationLogEntry logDeployChangedOnlyProperty = (UserOperationLogEntry)query.property("deployChangedOnly").singleResult();
        UserOperationLogDeploymentTest.assertNotNull((Object)logDeployChangedOnlyProperty);
        UserOperationLogDeploymentTest.assertEquals((String)"Deployment", (String)logDeployChangedOnlyProperty.getEntityType());
        UserOperationLogDeploymentTest.assertEquals((String)deployment.getId(), (String)logDeployChangedOnlyProperty.getDeploymentId());
        UserOperationLogDeploymentTest.assertEquals((String)"Create", (String)logDeployChangedOnlyProperty.getOperationType());
        UserOperationLogDeploymentTest.assertEquals((String)"demo", (String)logDeployChangedOnlyProperty.getUserId());
        UserOperationLogDeploymentTest.assertEquals((String)"deployChangedOnly", (String)logDeployChangedOnlyProperty.getProperty());
        UserOperationLogDeploymentTest.assertNull((Object)logDeployChangedOnlyProperty.getOrgValue());
        UserOperationLogDeploymentTest.assertTrue((boolean)Boolean.valueOf(logDeployChangedOnlyProperty.getNewValue()));
        UserOperationLogDeploymentTest.assertEquals((String)logDuplicateFilterEnabledProperty.getOperationId(), (String)logDeployChangedOnlyProperty.getOperationId());
    }

    public void testDeleteDeploymentCascadingShouldKeepCreateUserOperationLog() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Create");
        UserOperationLogDeploymentTest.assertEquals((long)1L, (long)query.count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        UserOperationLogDeploymentTest.assertEquals((long)1L, (long)query.count());
    }

    public void testDeleteDeploymentWithoutCascadingShouldKeepCreateUserOperationLog() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Create");
        UserOperationLogDeploymentTest.assertEquals((long)1L, (long)query.count());
        this.repositoryService.deleteDeployment(deployment.getId(), false);
        UserOperationLogDeploymentTest.assertEquals((long)1L, (long)query.count());
    }

    public void testDeleteDeployment() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Delete");
        this.repositoryService.deleteDeployment(deployment.getId(), false);
        UserOperationLogDeploymentTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        UserOperationLogDeploymentTest.assertNotNull((Object)log);
        UserOperationLogDeploymentTest.assertEquals((String)"Deployment", (String)log.getEntityType());
        UserOperationLogDeploymentTest.assertEquals((String)deployment.getId(), (String)log.getDeploymentId());
        UserOperationLogDeploymentTest.assertEquals((String)"Delete", (String)log.getOperationType());
        UserOperationLogDeploymentTest.assertEquals((String)"cascade", (String)log.getProperty());
        UserOperationLogDeploymentTest.assertNull((Object)log.getOrgValue());
        UserOperationLogDeploymentTest.assertFalse((boolean)Boolean.valueOf(log.getNewValue()));
        UserOperationLogDeploymentTest.assertEquals((String)"demo", (String)log.getUserId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getJobDefinitionId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getProcessInstanceId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getProcessDefinitionId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getProcessDefinitionKey());
        UserOperationLogDeploymentTest.assertNull((Object)log.getCaseInstanceId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getCaseDefinitionId());
    }

    public void testDeleteDeploymentCascading() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Delete");
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        UserOperationLogDeploymentTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        UserOperationLogDeploymentTest.assertNotNull((Object)log);
        UserOperationLogDeploymentTest.assertEquals((String)"Deployment", (String)log.getEntityType());
        UserOperationLogDeploymentTest.assertEquals((String)deployment.getId(), (String)log.getDeploymentId());
        UserOperationLogDeploymentTest.assertEquals((String)"Delete", (String)log.getOperationType());
        UserOperationLogDeploymentTest.assertEquals((String)"cascade", (String)log.getProperty());
        UserOperationLogDeploymentTest.assertNull((Object)log.getOrgValue());
        UserOperationLogDeploymentTest.assertTrue((boolean)Boolean.valueOf(log.getNewValue()));
        UserOperationLogDeploymentTest.assertEquals((String)"demo", (String)log.getUserId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getJobDefinitionId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getProcessInstanceId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getProcessDefinitionId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getProcessDefinitionKey());
        UserOperationLogDeploymentTest.assertNull((Object)log.getCaseInstanceId());
        UserOperationLogDeploymentTest.assertNull((Object)log.getCaseDefinitionId());
    }

    protected BpmnModelInstance createProcessWithServiceTask(String key) {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().serviceTask().camundaExpression("${true}")).endEvent().done();
    }
}

