/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobAcquisitionBackoffIdleTest {
    public static final int BASE_IDLE_WAIT_TIME = 5000;
    public static final int MAX_IDLE_WAIT_TIME = 30000;
    protected ControllableJobExecutor jobExecutor;
    protected ConcurrencyTestCase.ThreadControl acquisitionThread;
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            JobAcquisitionBackoffIdleTest.this.jobExecutor = new ControllableJobExecutor();
            JobAcquisitionBackoffIdleTest.this.jobExecutor.setMaxJobsPerAcquisition(1);
            JobAcquisitionBackoffIdleTest.this.jobExecutor.setWaitTimeInMillis(5000);
            JobAcquisitionBackoffIdleTest.this.jobExecutor.setMaxWait(30000L);
            JobAcquisitionBackoffIdleTest.this.acquisitionThread = JobAcquisitionBackoffIdleTest.this.jobExecutor.getAcquisitionThreadControl();
            return configuration.setJobExecutor((JobExecutor)JobAcquisitionBackoffIdleTest.this.jobExecutor);
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule);

    @After
    public void shutdownJobExecutor() {
        this.jobExecutor.shutdown();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testIdlingAfterConcurrentJobAddedNotification() {
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("simpleAsyncProcess");
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.assertJobExecutorWaitEvent(0L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(0L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(5000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(10000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(20000L);
        this.triggerReconfigurationAndNextCycle();
        this.assertJobExecutorWaitEvent(30000L);
    }

    protected void triggerReconfigurationAndNextCycle() {
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
    }

    protected void assertJobExecutorWaitEvent(long expectedTimeout) {
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> waitEvents = this.jobExecutor.getAcquireJobsRunnable().getWaitEvents();
        Assert.assertEquals((long)1L, (long)waitEvents.size());
        Assert.assertEquals((long)expectedTimeout, (long)waitEvents.get(0).getTimeBetweenAcquisitions());
        waitEvents.clear();
    }
}

