/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import junit.framework.TestCase;
import org.apache.ibatis.session.SqlSession;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class JobAcquisitionSuspensionStateTest
extends PluggableProcessEngineTestCase {
    protected CommandExecutor commandExecutor;
    protected String jobId;

    protected void setUp() throws Exception {
        this.commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
    }

    protected void tearDown() throws Exception {
        if (this.jobId != null) {
            this.commandExecutor.execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    JobEntity newTimer = commandContext.getJobManager().findJobById(JobAcquisitionSuspensionStateTest.this.jobId);
                    newTimer.delete();
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(newTimer.getId());
                    return null;
                }
            });
        }
    }

    public void testJobAcquisitionForJobsWithoutSuspensionStateSet() {
        String processInstanceId = "1";
        String myCustomTimerEntity = "myCustomTimerEntity";
        String jobId = "2";
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                Connection connection = null;
                Statement statement = null;
                ResultSet rs = null;
                String tablePrefix = commandContext.getProcessEngineConfiguration().getDatabaseTablePrefix();
                try {
                    SqlSession sqlSession = commandContext.getDbSqlSession().getSqlSession();
                    connection = sqlSession.getConnection();
                    statement = connection.createStatement();
                    String insertStatementString = "INSERT INTO " + tablePrefix + "ACT_RU_JOB(ID_, REV_, RETRIES_, PROCESS_INSTANCE_ID_, TYPE_, EXCLUSIVE_, HANDLER_TYPE_, HANDLER_CFG_) " + "VALUES (" + "'" + "2" + "'," + "1," + "3," + "'" + "1" + "'," + "'timer'," + (String)DbSqlSessionFactory.databaseSpecificTrueConstant.get(JobAcquisitionSuspensionStateTest.this.processEngineConfiguration.getDatabaseType()) + "," + "'" + "timer-start-event" + "'," + "'" + "myCustomTimerEntity" + "'" + ")";
                    int updateResult = statement.executeUpdate(insertStatementString);
                    TestCase.assertEquals((int)1, (int)updateResult);
                    connection.commit();
                    JobAcquisitionSuspensionStateTest.this.jobId = "2";
                    statement.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        });
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                List executableJobs = jobManager.findNextJobsToExecute(new Page(0, 1));
                TestCase.assertEquals((int)1, (int)executableJobs.size());
                TestCase.assertEquals((String)"myCustomTimerEntity", (String)((JobEntity)executableJobs.get(0)).getJobHandlerConfigurationRaw());
                TestCase.assertEquals((int)SuspensionState.ACTIVE.getStateCode(), (int)((JobEntity)executableJobs.get(0)).getSuspensionState());
                executableJobs = jobManager.findExclusiveJobsToExecute("1");
                TestCase.assertEquals((int)1, (int)executableJobs.size());
                TestCase.assertEquals((String)"myCustomTimerEntity", (String)((JobEntity)executableJobs.get(0)).getJobHandlerConfigurationRaw());
                TestCase.assertEquals((int)SuspensionState.ACTIVE.getStateCode(), (int)((JobEntity)executableJobs.get(0)).getSuspensionState());
                return null;
            }
        });
    }
}

