/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricFormField;
import org.camunda.bpm.engine.history.HistoricFormProperty;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.cmd.SubmitStartFormCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.DummySerializable;
import org.camunda.bpm.engine.test.api.runtime.util.CustomSerializable;
import org.camunda.bpm.engine.test.api.runtime.util.FailingSerializable;
import org.camunda.bpm.engine.test.history.SerializableVariable;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class FullHistoryTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected FormService formService;
    protected RepositoryService repositoryService;
    protected CaseService caseService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.formService = this.engineRule.getFormService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.caseService = this.engineRule.getCaseService();
    }

    @Test
    @Deployment
    public void testVariableUpdates() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("number", "one");
        variables.put("character", "a");
        variables.put("bytes", ":-(".getBytes());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveTask", variables);
        this.runtimeService.setVariable(processInstance.getId(), "number", (Object)"two");
        this.runtimeService.setVariable(processInstance.getId(), "bytes", (Object)":-)".getBytes());
        HistoricActivityInstance historicStartEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("theStart").singleResult();
        Assert.assertNotNull((Object)historicStartEvent);
        HistoricActivityInstance waitStateActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("waitState").singleResult();
        Assert.assertNotNull((Object)waitStateActivity);
        HistoricActivityInstance serviceTaskActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTaskActivity);
        List historicDetails = ((HistoricDetailQuery)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().orderByVariableName().asc()).orderByVariableRevision().asc()).list();
        Assert.assertEquals((long)10L, (long)historicDetails.size());
        HistoricVariableUpdate historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(0);
        Assert.assertEquals((Object)"bytes", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)":-(", (Object)new String((byte[])historicVariableUpdate.getValue()));
        Assert.assertEquals((long)0L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)historicStartEvent.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(1);
        Assert.assertEquals((Object)"bytes", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)":-)", (Object)new String((byte[])historicVariableUpdate.getValue()));
        Assert.assertEquals((long)1L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)waitStateActivity.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(2);
        Assert.assertEquals((Object)"character", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)"a", (Object)historicVariableUpdate.getValue());
        Assert.assertEquals((long)0L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)historicStartEvent.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(3);
        Assert.assertEquals((Object)"number", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)"one", (Object)historicVariableUpdate.getValue());
        Assert.assertEquals((long)0L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)historicStartEvent.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(4);
        Assert.assertEquals((Object)"number", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)"two", (Object)historicVariableUpdate.getValue());
        Assert.assertEquals((long)1L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)waitStateActivity.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(5);
        Assert.assertEquals((Object)"zVar1", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)"Event: start", (Object)historicVariableUpdate.getValue());
        Assert.assertEquals((long)0L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)historicStartEvent.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(6);
        Assert.assertEquals((Object)"zVar2", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)"Event: take", (Object)historicVariableUpdate.getValue());
        Assert.assertEquals((long)0L, (long)historicVariableUpdate.getRevision());
        Assert.assertNull((Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(7);
        Assert.assertEquals((Object)"zVar3", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)"Event: start", (Object)historicVariableUpdate.getValue());
        Assert.assertEquals((long)0L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)serviceTaskActivity.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(8);
        Assert.assertEquals((Object)"zVar4", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)"Event: end", (Object)historicVariableUpdate.getValue());
        Assert.assertEquals((long)0L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)serviceTaskActivity.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(9);
        Assert.assertEquals((Object)"zzz", (Object)historicVariableUpdate.getVariableName());
        Assert.assertEquals((Object)123456789L, (Object)historicVariableUpdate.getValue());
        Assert.assertEquals((long)0L, (long)historicVariableUpdate.getRevision());
        Assert.assertEquals((Object)serviceTaskActivity.getId(), (Object)historicVariableUpdate.getActivityInstanceId());
        this.runtimeService.signal(processInstance.getId());
        this.testHelper.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicProcessVariableQuery = (HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc();
        Assert.assertEquals((long)8L, (long)historicProcessVariableQuery.count());
        List historicVariables = historicProcessVariableQuery.list();
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)historicVariables.get(0);
        Assert.assertEquals((Object)"bytes", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)":-)", (Object)new String((byte[])historicVariable.getValue()));
        historicVariable = (HistoricVariableInstance)historicVariables.get(1);
        Assert.assertEquals((Object)"character", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)"a", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(2);
        Assert.assertEquals((Object)"number", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)"two", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(3);
        Assert.assertEquals((Object)"zVar1", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)"Event: start", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(4);
        Assert.assertEquals((Object)"zVar2", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)"Event: take", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(5);
        Assert.assertEquals((Object)"zVar3", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)"Event: start", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(6);
        Assert.assertEquals((Object)"zVar4", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)"Event: end", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(7);
        Assert.assertEquals((Object)"zzz", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)123456789L, (Object)historicVariable.getValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testVariableUpdates.bpmn20.xml"})
    public void testHistoricVariableInstanceQuery() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("process", "one");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveTask", variables);
        this.runtimeService.signal(processInstance.getProcessInstanceId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("process").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("process", (Object)"one").count());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("process", "two");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("receiveTask", variables2);
        this.runtimeService.signal(processInstance2.getProcessInstanceId());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("process").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("process", (Object)"one").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("process", (Object)"two").count());
        HistoricVariableInstance historicProcessVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("process", (Object)"one").singleResult();
        Assert.assertEquals((Object)"process", (Object)historicProcessVariable.getVariableName());
        Assert.assertEquals((Object)"one", (Object)historicProcessVariable.getValue());
        Assert.assertEquals((Object)ValueType.STRING.getName(), (Object)historicProcessVariable.getVariableTypeName());
        Assert.assertEquals((Object)ValueType.STRING.getName(), (Object)historicProcessVariable.getTypeName());
        Assert.assertEquals((Object)historicProcessVariable.getValue(), (Object)historicProcessVariable.getTypedValue().getValue());
        Assert.assertEquals((Object)historicProcessVariable.getTypeName(), (Object)historicProcessVariable.getTypedValue().getType().getName());
        HashMap<String, Number> variables3 = new HashMap<String, Number>();
        variables3.put("long", 1000L);
        variables3.put("double", 25.43);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("receiveTask", variables3);
        this.runtimeService.signal(processInstance3.getProcessInstanceId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("long").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("long", (Object)1000L).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("double").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("double", (Object)25.43).count());
    }

    @Test
    @Deployment
    public void testHistoricVariableUpdatesAllTypes() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss SSS");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "initial value");
        Date startedDate = sdf.parse("01/01/2001 01:23:45 000");
        Date updatedDate = sdf.parse("01/01/2001 01:23:46 000");
        ClockUtil.setCurrentTime((Date)startedDate);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricVariableUpdateProcess", variables);
        List details = ((HistoricDetailQuery)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).orderByVariableName().asc()).orderByTime().asc()).list();
        Assert.assertEquals((long)9L, (long)details.size());
        HistoricVariableUpdate startVarUpdate = (HistoricVariableUpdate)details.get(0);
        Assert.assertEquals((Object)"aVariable", (Object)startVarUpdate.getVariableName());
        Assert.assertEquals((Object)"initial value", (Object)startVarUpdate.getValue());
        Assert.assertEquals((long)0L, (long)startVarUpdate.getRevision());
        Assert.assertEquals((Object)processInstance.getId(), (Object)startVarUpdate.getProcessInstanceId());
        Assert.assertEquals((Object)startedDate, (Object)startVarUpdate.getTime());
        HistoricVariableUpdate updatedStringVariable = (HistoricVariableUpdate)details.get(1);
        Assert.assertEquals((Object)"aVariable", (Object)updatedStringVariable.getVariableName());
        Assert.assertEquals((Object)"updated value", (Object)updatedStringVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)updatedStringVariable.getProcessInstanceId());
        Assert.assertEquals((Object)updatedDate, (Object)updatedStringVariable.getTime());
        HistoricVariableUpdate intVariable = (HistoricVariableUpdate)details.get(2);
        Assert.assertEquals((Object)"bVariable", (Object)intVariable.getVariableName());
        Assert.assertEquals((Object)123, (Object)intVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)intVariable.getProcessInstanceId());
        Assert.assertEquals((Object)updatedDate, (Object)intVariable.getTime());
        HistoricVariableUpdate longVariable = (HistoricVariableUpdate)details.get(3);
        Assert.assertEquals((Object)"cVariable", (Object)longVariable.getVariableName());
        Assert.assertEquals((Object)12345L, (Object)longVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)longVariable.getProcessInstanceId());
        Assert.assertEquals((Object)updatedDate, (Object)longVariable.getTime());
        HistoricVariableUpdate doubleVariable = (HistoricVariableUpdate)details.get(4);
        Assert.assertEquals((Object)"dVariable", (Object)doubleVariable.getVariableName());
        Assert.assertEquals((Object)1234.567, (Object)doubleVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)doubleVariable.getProcessInstanceId());
        Assert.assertEquals((Object)updatedDate, (Object)doubleVariable.getTime());
        HistoricVariableUpdate shortVariable = (HistoricVariableUpdate)details.get(5);
        Assert.assertEquals((Object)"eVariable", (Object)shortVariable.getVariableName());
        Assert.assertEquals((Object)12, (Object)shortVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)shortVariable.getProcessInstanceId());
        Assert.assertEquals((Object)updatedDate, (Object)shortVariable.getTime());
        HistoricVariableUpdate dateVariable = (HistoricVariableUpdate)details.get(6);
        Assert.assertEquals((Object)"fVariable", (Object)dateVariable.getVariableName());
        Assert.assertEquals((Object)sdf.parse("01/01/2001 01:23:45 678"), (Object)dateVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)dateVariable.getProcessInstanceId());
        Assert.assertEquals((Object)updatedDate, (Object)dateVariable.getTime());
        HistoricVariableUpdate serializableVariable = (HistoricVariableUpdate)details.get(7);
        Assert.assertEquals((Object)"gVariable", (Object)serializableVariable.getVariableName());
        Assert.assertEquals((Object)new SerializableVariable("hello hello"), (Object)serializableVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)serializableVariable.getProcessInstanceId());
        Assert.assertEquals((Object)updatedDate, (Object)serializableVariable.getTime());
        HistoricVariableUpdate byteArrayVariable = (HistoricVariableUpdate)details.get(8);
        Assert.assertEquals((Object)"hVariable", (Object)byteArrayVariable.getVariableName());
        Assert.assertEquals((Object)";-)", (Object)new String((byte[])byteArrayVariable.getValue()));
        Assert.assertEquals((Object)processInstance.getId(), (Object)byteArrayVariable.getProcessInstanceId());
        Assert.assertEquals((Object)updatedDate, (Object)byteArrayVariable.getTime());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.testHelper.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicProcessVariableQuery = (HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc();
        Assert.assertEquals((long)8L, (long)historicProcessVariableQuery.count());
        List historicVariables = historicProcessVariableQuery.list();
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)historicVariables.get(0);
        Assert.assertEquals((Object)"aVariable", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)"updated value", (Object)historicVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(1);
        Assert.assertEquals((Object)"bVariable", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)123, (Object)historicVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(2);
        Assert.assertEquals((Object)"cVariable", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)12345L, (Object)historicVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(3);
        Assert.assertEquals((Object)"dVariable", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)1234.567, (Object)historicVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(4);
        Assert.assertEquals((Object)"eVariable", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)12, (Object)historicVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(5);
        Assert.assertEquals((Object)"fVariable", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)sdf.parse("01/01/2001 01:23:45 678"), (Object)historicVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(6);
        Assert.assertEquals((Object)"gVariable", (Object)historicVariable.getVariableName());
        Assert.assertEquals((Object)new SerializableVariable("hello hello"), (Object)historicVariable.getValue());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(7);
        Assert.assertEquals((Object)"hVariable", (Object)historicVariable.getVariableName());
        Assert.assertEquals((String)";-)", (Object)";-)", (Object)new String((byte[])historicVariable.getValue()));
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicVariable.getProcessInstanceId());
    }

    @Test
    @Deployment
    public void testHistoricFormProperties() throws Exception {
        Date startedDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss SSS").parse("01/01/2001 01:23:46 000");
        ClockUtil.setCurrentTime((Date)startedDate);
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("formProp1", "Activiti rocks");
        formProperties.put("formProp2", "12345");
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("historicFormPropertiesProcess").singleResult();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDef.getId(), formProperties);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        List activityIds = this.runtimeService.getActiveActivityIds(task.getExecutionId());
        Assert.assertNotNull((Object)activityIds);
        Assert.assertEquals((long)1L, (long)activityIds.size());
        String taskActivityId = (String)activityIds.get(0);
        formProperties = new HashMap();
        formProperties.put("formProp3", "Activiti still rocks!!!");
        formProperties.put("formProp4", "54321");
        this.formService.submitTaskFormData(task.getId(), formProperties);
        List props = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).orderByFormPropertyId().asc()).list();
        HistoricFormProperty historicProperty1 = (HistoricFormProperty)props.get(0);
        Assert.assertEquals((Object)"formProp1", (Object)historicProperty1.getPropertyId());
        Assert.assertEquals((Object)"Activiti rocks", (Object)historicProperty1.getPropertyValue());
        Assert.assertEquals((Object)startedDate, (Object)historicProperty1.getTime());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicProperty1.getProcessInstanceId());
        Assert.assertNull((Object)historicProperty1.getTaskId());
        Assert.assertNotNull((Object)historicProperty1.getActivityInstanceId());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(historicProperty1.getActivityInstanceId()).singleResult();
        Assert.assertNotNull((Object)historicActivityInstance);
        Assert.assertEquals((Object)"start", (Object)historicActivityInstance.getActivityId());
        HistoricFormProperty historicProperty2 = (HistoricFormProperty)props.get(1);
        Assert.assertEquals((Object)"formProp2", (Object)historicProperty2.getPropertyId());
        Assert.assertEquals((Object)"12345", (Object)historicProperty2.getPropertyValue());
        Assert.assertEquals((Object)startedDate, (Object)historicProperty2.getTime());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicProperty2.getProcessInstanceId());
        Assert.assertNull((Object)historicProperty2.getTaskId());
        Assert.assertNotNull((Object)historicProperty2.getActivityInstanceId());
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(historicProperty2.getActivityInstanceId()).singleResult();
        Assert.assertNotNull((Object)historicActivityInstance);
        Assert.assertEquals((Object)"start", (Object)historicActivityInstance.getActivityId());
        HistoricFormProperty historicProperty3 = (HistoricFormProperty)props.get(2);
        Assert.assertEquals((Object)"formProp3", (Object)historicProperty3.getPropertyId());
        Assert.assertEquals((Object)"Activiti still rocks!!!", (Object)historicProperty3.getPropertyValue());
        Assert.assertEquals((Object)startedDate, (Object)historicProperty3.getTime());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicProperty3.getProcessInstanceId());
        String activityInstanceId = historicProperty3.getActivityInstanceId();
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(activityInstanceId).singleResult();
        Assert.assertNotNull((Object)historicActivityInstance);
        Assert.assertEquals((Object)taskActivityId, (Object)historicActivityInstance.getActivityId());
        Assert.assertNotNull((Object)historicProperty3.getTaskId());
        HistoricFormProperty historicProperty4 = (HistoricFormProperty)props.get(3);
        Assert.assertEquals((Object)"formProp4", (Object)historicProperty4.getPropertyId());
        Assert.assertEquals((Object)"54321", (Object)historicProperty4.getPropertyValue());
        Assert.assertEquals((Object)startedDate, (Object)historicProperty4.getTime());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicProperty4.getProcessInstanceId());
        activityInstanceId = historicProperty4.getActivityInstanceId();
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(activityInstanceId).singleResult();
        Assert.assertNotNull((Object)historicActivityInstance);
        Assert.assertEquals((Object)taskActivityId, (Object)historicActivityInstance.getActivityId());
        Assert.assertNotNull((Object)historicProperty4.getTaskId());
        Assert.assertEquals((long)4L, (long)props.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableQuery() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", "activiti rocks!");
        variables.put("longVar", 12345L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().activityInstanceId(null).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().activityInstanceId("unexisting").count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId("unexisting").count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().activityInstanceId(null).processInstanceId(processInstance.getId()).count());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.testHelper.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId("unexisting").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableQueryExcludeTaskRelatedDetails() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", "activiti rocks!");
        variables.put("longVar", 12345L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)"It is I, le Variable");
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).excludeTaskDetails().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).excludeTaskDetails().taskId(task.getId()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricFormPropertiesQuery() throws Exception {
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("stringVar", "activiti rocks!");
        formProperties.put("longVar", "12345");
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDef.getId(), formProperties);
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().formProperties().activityInstanceId(null).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formProperties().activityInstanceId("unexisting").count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId("unexisting").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        formProperties = new HashMap();
        formProperties.put("taskVar", "task form property");
        this.formService.submitTaskFormData(task.getId(), formProperties);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId("unexisting").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableQuerySorting() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", "activiti rocks!");
        variables.put("longVar", 12345L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByProcessInstanceId().asc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTime().asc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableName().asc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableRevision().asc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableType().asc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByProcessInstanceId().desc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTime().desc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableName().desc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableRevision().desc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableType().desc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByProcessInstanceId().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTime().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableName().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableRevision().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableType().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByProcessInstanceId().desc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTime().desc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableName().desc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableRevision().desc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableType().desc()).list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricFormPropertySorting() throws Exception {
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("stringVar", "activiti rocks!");
        formProperties.put("longVar", "12345");
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult();
        this.formService.submitStartFormData(procDef.getId(), formProperties);
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByProcessInstanceId().asc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByTime().asc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByFormPropertyId().asc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByProcessInstanceId().desc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByTime().desc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByFormPropertyId().desc()).count());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByProcessInstanceId().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByTime().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByFormPropertyId().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByProcessInstanceId().desc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByTime().desc()).list().size());
        Assert.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByFormPropertyId().desc()).list().size());
    }

    @Test
    @Deployment
    public void testHistoricDetailQueryMixed() throws Exception {
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("formProp1", "activiti rocks!");
        formProperties.put("formProp2", "12345");
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("historicDetailMixed").singleResult();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDef.getId(), formProperties);
        List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).orderByVariableName().asc()).list();
        Assert.assertEquals((long)4L, (long)details.size());
        Assert.assertTrue((boolean)(details.get(0) instanceof HistoricFormProperty));
        HistoricFormProperty formProp1 = (HistoricFormProperty)details.get(0);
        Assert.assertEquals((Object)"formProp1", (Object)formProp1.getPropertyId());
        Assert.assertEquals((Object)"activiti rocks!", (Object)formProp1.getPropertyValue());
        Assert.assertTrue((boolean)(details.get(1) instanceof HistoricFormProperty));
        HistoricFormProperty formProp2 = (HistoricFormProperty)details.get(1);
        Assert.assertEquals((Object)"formProp2", (Object)formProp2.getPropertyId());
        Assert.assertEquals((Object)"12345", (Object)formProp2.getPropertyValue());
        Assert.assertTrue((boolean)(details.get(2) instanceof HistoricVariableUpdate));
        HistoricVariableUpdate varUpdate1 = (HistoricVariableUpdate)details.get(2);
        Assert.assertEquals((Object)"variable1", (Object)varUpdate1.getVariableName());
        Assert.assertEquals((Object)"activiti rocks!", (Object)varUpdate1.getValue());
        Assert.assertTrue((boolean)(details.get(3) instanceof HistoricVariableUpdate));
        HistoricVariableUpdate varUpdate2 = (HistoricVariableUpdate)details.get(3);
        Assert.assertEquals((Object)"variable2", (Object)varUpdate2.getVariableName());
        Assert.assertEquals((Object)12345L, (Object)varUpdate2.getValue());
    }

    @Test
    public void testHistoricDetailQueryInvalidSorting() throws Exception {
        try {
            ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().asc()).list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().desc()).list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByProcessInstanceId().list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByTime().list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByVariableName().list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByVariableRevision().list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByVariableType().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment
    public void testHistoricTaskInstanceVariableUpdates() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.runtimeService.setVariable(processInstanceId, "deadline", (Object)"yesterday");
        this.taskService.setVariableLocal(taskId, "bucket", (Object)"23c");
        this.taskService.setVariableLocal(taskId, "mop", (Object)"37i");
        this.taskService.complete(taskId);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        List historicTaskVariableUpdates = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().taskId(taskId).variableUpdates().orderByVariableName().asc()).list();
        Assert.assertEquals((long)2L, (long)historicTaskVariableUpdates.size());
        this.historyService.deleteHistoricTaskInstance(taskId);
        historicTaskVariableUpdates = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().taskId(taskId).variableUpdates().orderByVariableName().asc()).list();
        Assert.assertEquals((long)0L, (long)historicTaskVariableUpdates.size());
    }

    @Test
    @Deployment
    public void testSetVariableOnProcessInstanceWithTimer() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("timerVariablesProcess");
        this.runtimeService.setVariable(processInstance.getId(), "myVar", (Object)123456L);
        Assert.assertEquals((Object)123456L, (Object)this.runtimeService.getVariable(processInstance.getId(), "myVar"));
    }

    @Test
    @Deployment
    public void testDeleteHistoricProcessInstance() {
        HashMap<String, Serializable> vars = new HashMap<String, Serializable>();
        vars.put("processVar", Long.valueOf(123L));
        vars.put("anotherProcessVar", new DummySerializable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest", vars);
        Assert.assertNotNull((Object)processInstance);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)45678);
        this.taskService.setVariableLocal(task.getId(), "anotherTaskVar", (Object)"value");
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId()).count());
        this.historyService.deleteHistoricProcessInstance(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId()).count());
        try {
            this.historyService.deleteHistoricProcessInstance("unexisting");
            Assert.fail((String)"Exception expected when deleting process-instance that is still running");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"No historic process instance found with id: unexisting"));
        }
    }

    @Test
    @Deployment
    public void testDeleteRunningHistoricProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        Assert.assertNotNull((Object)processInstance);
        try {
            this.historyService.deleteHistoricProcessInstance(processInstance.getId());
            Assert.fail((String)"Exception expected when deleting process-instance that is still running");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance is still running, cannot delete historic process instance"));
        }
    }

    @Test
    @Deployment
    public void testDeleteCachedHistoricDetails() {
        final String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HashMap<String, String> formProperties = new HashMap<String, String>();
                formProperties.put("formProp1", "value1");
                ProcessInstance processInstance = new SubmitStartFormCmd(processDefinitionId, null, formProperties).execute(commandContext);
                commandContext.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceId(processInstance.getId());
                return null;
            }
        });
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Test
    @Deployment
    public void testHistoricFormPropertiesOnReEnteringActivity() {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("comeBack", Boolean.TRUE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricFormPropertiesProcess", variables);
        Assert.assertNotNull((Object)processInstance);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("formProp1", "Property value");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.formService.submitTaskFormData(task.getId(), data);
        List details = this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).list();
        Assert.assertNotNull((Object)details);
        Assert.assertEquals((long)1L, (long)details.size());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.formService.submitTaskFormData(task.getId(), data);
        details = this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).list();
        Assert.assertNotNull((Object)details);
        Assert.assertEquals((long)2L, (long)details.size());
        Assert.assertNotSame((Object)((HistoricDetail)details.get(0)).getActivityInstanceId(), (Object)((HistoricDetail)details.get(1)).getActivityInstanceId());
        HistoricActivityInstance historicActInst1 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(((HistoricDetail)details.get(0)).getActivityInstanceId()).singleResult();
        HistoricActivityInstance historicActInst2 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(((HistoricDetail)details.get(1)).getActivityInstanceId()).singleResult();
        Assert.assertEquals((Object)historicActInst1.getActivityId(), (Object)historicActInst2.getActivityId());
    }

    @Test
    @Deployment
    public void testHistoricTaskInstanceQueryTaskVariableValueEquals() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 12345L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        Assert.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().taskId(task.getId()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("longVar", (Object)12345L).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("nullVar", null).count());
        variables.put("longVar", 67890L);
        variables.put("shortVar", (short)456);
        variables.put("integerVar", 5678);
        variables.put("stringVar", "updatedStringValue");
        variables.put("booleanVar", false);
        Calendar otherCal = Calendar.getInstance();
        otherCal.add(5, 1);
        Date otherDate = otherCal.getTime();
        variables.put("dateVar", otherDate);
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        Assert.assertEquals((long)14L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().taskId(task.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("longVar", (Object)12345L).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("longVar", (Object)67890L).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("shortVar", (Object)456).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("integerVar", (Object)5678).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("stringVar", (Object)"updatedStringValue").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("booleanVar", (Object)false).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("dateVar", (Object)otherDate).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("nullVar", null).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryTaskVariableValueEqualsOverwriteType() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "var", (Object)12345L);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().taskId(task.getId()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)12345L).count());
        this.taskService.setVariableLocal(task.getId(), "var", (Object)12345);
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().taskId(task.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)12345L).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)12345).count());
    }

    @Test
    @Deployment
    public void testHistoricTaskInstanceQueryVariableInParallelBranch() throws Exception {
        this.runtimeService.startProcessInstanceByKey("parallelGateway");
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        this.runtimeService.setVariableLocal(task1Execution.getId(), "var", (Object)12345L);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "var", (Object)12345);
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)12345).count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)12345L).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testHistoricTaskInstanceQueryVariableInParallelBranch.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryVariableOfSameTypeInParallelBranch() throws Exception {
        this.runtimeService.startProcessInstanceByKey("parallelGateway");
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        this.runtimeService.setVariableLocal(task1Execution.getId(), "var", (Object)12345L);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "var", (Object)45678L);
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)12345L).count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)45678L).count());
    }

    @Test
    @Deployment
    public void testHistoricTaskInstanceQueryProcessVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 12345L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)12345L).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("nullVar", null).count());
        variables.put("longVar", 67890L);
        variables.put("shortVar", (short)456);
        variables.put("integerVar", 5678);
        variables.put("stringVar", "updatedStringValue");
        variables.put("booleanVar", false);
        Calendar otherCal = Calendar.getInstance();
        otherCal.add(5, 1);
        Date otherDate = otherCal.getTime();
        variables.put("dateVar", otherDate);
        variables.put("nullVar", null);
        this.runtimeService.setVariables(processInstance.getId(), variables);
        Assert.assertEquals((long)14L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)12345L).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)67890L).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("shortVar", (Object)456).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("integerVar", (Object)5678).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("stringVar", (Object)"updatedStringValue").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("booleanVar", (Object)false).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("dateVar", (Object)otherDate).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("nullVar", null).count());
        this.taskService.setVariableLocal(task.getId(), "longVar", (Object)9999L);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)9999L).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)67890L).count());
    }

    @Test
    @Deployment
    public void testHistoricProcessInstanceVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 12345L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricProcessInstanceTest", variables);
        Assert.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testHistoricProcessInstanceVariableValueEquals.bpmn20.xml"})
    public void testHistoricProcessInstanceVariableValueNotEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 12345L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        Calendar otherCal = Calendar.getInstance();
        otherCal.add(5, 1);
        Date otherDate = otherCal.getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricProcessInstanceTest", variables);
        Assert.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("longVar", (Object)12345L).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("nullVar", null).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testHistoricProcessInstanceVariableValueEquals.bpmn20.xml"})
    public void testHistoricProcessInstanceVariableValueLessThanAndGreaterThan() throws Exception {
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("longVar", 12345L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricProcessInstanceTest", variables);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("longVar", (Object)12345L).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testVariableUpdatesAreLinkedToActivity.bpmn20.xml"})
    public void testVariableUpdatesLinkedToActivity() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("ProcessWithSubProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("test", "1");
        this.taskService.complete(task.getId(), variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        variables.clear();
        variables.put("test", "2");
        this.taskService.complete(task.getId(), variables);
        this.testHelper.assertProcessEnded(pi.getId());
        List updates = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        Assert.assertEquals((long)2L, (long)updates.size());
        HashMap<String, HistoricVariableUpdate> updatesMap = new HashMap<String, HistoricVariableUpdate>();
        HistoricVariableUpdate update = (HistoricVariableUpdate)updates.get(0);
        updatesMap.put((String)update.getValue(), update);
        update = (HistoricVariableUpdate)updates.get(1);
        updatesMap.put((String)update.getValue(), update);
        HistoricVariableUpdate update1 = (HistoricVariableUpdate)updatesMap.get("1");
        HistoricVariableUpdate update2 = (HistoricVariableUpdate)updatesMap.get("2");
        Assert.assertNotNull((Object)update1.getActivityInstanceId());
        Assert.assertNotNull((Object)update1.getExecutionId());
        HistoricActivityInstance historicActivityInstance1 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update1.getActivityInstanceId()).singleResult();
        Assert.assertEquals((Object)historicActivityInstance1.getExecutionId(), (Object)update1.getExecutionId());
        Assert.assertEquals((Object)"usertask1", (Object)historicActivityInstance1.getActivityId());
        Assert.assertNotNull((Object)update2.getActivityInstanceId());
        HistoricActivityInstance historicActivityInstance2 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update2.getActivityInstanceId()).singleResult();
        Assert.assertEquals((Object)"usertask2", (Object)historicActivityInstance2.getActivityId());
        Assert.assertFalse((boolean)historicActivityInstance2.getExecutionId().equals(update2.getExecutionId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricDetailQueryByVariableInstanceId() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testVar", "testValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", params);
        HistoricVariableInstance testVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("testVar").singleResult();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        query.variableInstanceId(testVariable.getId());
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }

    @Test
    public void testHistoricDetailQueryByInvalidVariableInstanceId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        query.variableInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.variableInstanceId(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.variableInstanceId((String)null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment
    public void testHistoricDetailActivityInstanceIdForInactiveScopeExecution() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.setVariable(pi.getId(), "foo", (Object)"bar");
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        Assert.assertNotNull((Object)historicDetail.getActivityInstanceId());
    }

    @Test
    public void testHistoricDetailQueryById() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "someName";
        String variableValue = "someValue";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)variableValue);
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        HistoricDetail resultById = (HistoricDetail)this.historyService.createHistoricDetailQuery().detailId(result.getId()).singleResult();
        Assert.assertNotNull((Object)resultById);
        Assert.assertEquals((Object)result.getId(), (Object)resultById.getId());
        Assert.assertEquals((Object)variableName, (Object)((HistoricVariableUpdate)resultById).getVariableName());
        Assert.assertEquals((Object)variableValue, (Object)((HistoricVariableUpdate)resultById).getValue());
        Assert.assertEquals((Object)ValueType.STRING.getName(), (Object)((HistoricVariableUpdate)resultById).getVariableTypeName());
        Assert.assertEquals((Object)ValueType.STRING.getName(), (Object)((HistoricVariableUpdate)resultById).getTypeName());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testHistoricDetailQueryByNonExistingId() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "someName";
        String variableValue = "someValue";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)variableValue);
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().detailId("non-existing").singleResult();
        Assert.assertNull((Object)result);
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testBinaryFetchingEnabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableUpdates().singleResult();
        Assert.assertNotNull((Object)((HistoricVariableUpdate)result).getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testBinaryFetchingDisabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().disableBinaryFetching().variableUpdates().singleResult();
        Assert.assertNull((Object)((HistoricVariableUpdate)result).getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testDisableBinaryFetchingForFileValues() {
        String fileName = "text.txt";
        String encoding = "crazy-encoding";
        String mimeType = "martini/dry";
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file("ABC".getBytes()).encoding(encoding).mimeType(mimeType).create();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("fileVar", (TypedValue)fileValue));
        HistoricVariableUpdate fileVariableInstance = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().singleResult();
        Assert.assertNotNull((Object)fileVariableInstance.getValue());
        fileVariableInstance = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().disableBinaryFetching().singleResult();
        Assert.assertNotNull((Object)fileVariableInstance);
        Assert.assertEquals((Object)"fileVar", (Object)fileVariableInstance.getVariableName());
        Assert.assertNull((Object)fileVariableInstance.getValue());
        FileValue typedValue = (FileValue)fileVariableInstance.getTypedValue();
        Assert.assertNull((Object)typedValue.getValue());
        Assert.assertEquals((Object)ValueType.FILE, (Object)typedValue.getType());
        Assert.assertEquals((Object)fileName, (Object)typedValue.getFilename());
        Assert.assertEquals((Object)encoding, (Object)typedValue.getEncoding());
        Assert.assertEquals((Object)mimeType, (Object)typedValue.getMimeType());
    }

    @Test
    public void testDisableCustomObjectDeserialization() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        this.taskService.setVariables(newTask.getId(), variables);
        List results = this.historyService.createHistoricDetailQuery().disableBinaryFetching().disableCustomObjectDeserialization().variableUpdates().list();
        Assert.assertEquals((long)2L, (long)results.size());
        for (HistoricDetail update : results) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)update;
            Assert.assertNull((Object)variableUpdate.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableUpdate.getTypedValue();
            Assert.assertNotNull((Object)typedValue);
            Assert.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Object is not deserialized"));
            }
            Assert.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testErrorMessage() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "failingSerializable";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)new FailingSerializable());
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().disableBinaryFetching().variableUpdates().singleResult();
        Assert.assertNull((Object)((HistoricVariableUpdate)result).getValue());
        Assert.assertNotNull((Object)((HistoricVariableUpdate)result).getErrorMessage());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testVariableInstance() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "someName";
        String variableValue = "someValue";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)variableValue);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        HistoricVariableUpdate result = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().singleResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)variable.getId(), (Object)result.getVariableInstanceId());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableUpdateProcessDefinitionProperty() {
        String key = "oneTaskProcess";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key);
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"aValue");
        this.taskService.setVariableLocal(taskId, "aLocalVariable", (Object)"anotherValue");
        String firstVariable = ((VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("aVariable").singleResult()).getId();
        String secondVariable = ((VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("aLocalVariable").singleResult()).getId();
        HistoricVariableUpdate instance = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(firstVariable).singleResult();
        Assert.assertNotNull((Object)instance.getProcessDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getProcessDefinitionKey());
        Assert.assertNotNull((Object)instance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)instance.getProcessDefinitionId());
        Assert.assertNull((Object)instance.getCaseDefinitionKey());
        Assert.assertNull((Object)instance.getCaseDefinitionId());
        instance = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(secondVariable).singleResult();
        Assert.assertNotNull((Object)instance.getProcessDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getProcessDefinitionKey());
        Assert.assertNotNull((Object)instance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)instance.getProcessDefinitionId());
        Assert.assertNull((Object)instance.getCaseDefinitionKey());
        Assert.assertNull((Object)instance.getCaseDefinitionId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testHistoricVariableUpdateCaseDefinitionProperty() {
        String key = "oneTaskCase";
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey(key);
        String caseInstanceId = caseInstance.getId();
        String humanTask = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(humanTask);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.caseService.setVariable(caseInstanceId, "aVariable", (Object)"aValue");
        this.taskService.setVariableLocal(taskId, "aLocalVariable", (Object)"anotherValue");
        String firstVariable = ((VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("aVariable").singleResult()).getId();
        String secondVariable = ((VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("aLocalVariable").singleResult()).getId();
        HistoricVariableUpdate instance = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(firstVariable).singleResult();
        Assert.assertNotNull((Object)instance.getCaseDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getCaseDefinitionKey());
        Assert.assertNotNull((Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertNull((Object)instance.getProcessDefinitionKey());
        Assert.assertNull((Object)instance.getProcessDefinitionId());
        instance = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(secondVariable).singleResult();
        Assert.assertNotNull((Object)instance.getCaseDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getCaseDefinitionKey());
        Assert.assertNotNull((Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertNull((Object)instance.getProcessDefinitionKey());
        Assert.assertNull((Object)instance.getProcessDefinitionId());
    }

    @Test
    public void testHistoricVariableUpdateStandaloneTaskDefinitionProperties() {
        String taskId = "myTask";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.taskService.setVariable(taskId, "aVariable", (Object)"anotherValue");
        String firstVariable = ((VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("aVariable").singleResult()).getId();
        HistoricVariableUpdate instance = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(firstVariable).singleResult();
        Assert.assertNull((Object)instance.getProcessDefinitionKey());
        Assert.assertNull((Object)instance.getProcessDefinitionId());
        Assert.assertNull((Object)instance.getCaseDefinitionKey());
        Assert.assertNull((Object)instance.getCaseDefinitionId());
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricFormFieldProcessDefinitionProperty() {
        String key = "oneTaskProcess";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.formService.submitTaskForm(taskId, (Map)Variables.createVariables().putValue("aVariable", (Object)"aValue"));
        HistoricFormField instance = (HistoricFormField)this.historyService.createHistoricDetailQuery().formFields().singleResult();
        Assert.assertNotNull((Object)instance.getProcessDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getProcessDefinitionKey());
        Assert.assertNotNull((Object)instance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)instance.getProcessDefinitionId());
        Assert.assertNull((Object)instance.getCaseDefinitionKey());
        Assert.assertNull((Object)instance.getCaseDefinitionId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceSkipCustomListener() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null, true);
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
        Assert.assertNotNull((Object)instance.getEndTime());
    }
}

